/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison;

import java.time.ZoneId;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.EsqlBinaryComparison;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThan;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanOrEqual;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanDoublesEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanIntsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanKeywordsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.predicate.Negatable;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparisonProcessor;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class LessThan
extends EsqlBinaryComparison
implements Negatable<BinaryComparison> {
    private static final Map<DataType, EsqlArithmeticOperation.BinaryEvaluator> evaluatorMap = Map.ofEntries(Map.entry(DataTypes.INTEGER, LessThanIntsEvaluator.Factory::new), Map.entry(DataTypes.DOUBLE, LessThanDoublesEvaluator.Factory::new), Map.entry(DataTypes.LONG, LessThanLongsEvaluator.Factory::new), Map.entry(DataTypes.UNSIGNED_LONG, LessThanLongsEvaluator.Factory::new), Map.entry(DataTypes.DATETIME, LessThanLongsEvaluator.Factory::new), Map.entry(DataTypes.KEYWORD, LessThanKeywordsEvaluator.Factory::new), Map.entry(DataTypes.TEXT, LessThanKeywordsEvaluator.Factory::new), Map.entry(DataTypes.VERSION, LessThanKeywordsEvaluator.Factory::new), Map.entry(DataTypes.IP, LessThanKeywordsEvaluator.Factory::new));

    public LessThan(Source source, Expression left, Expression right, ZoneId zoneId) {
        super(source, left, right, BinaryComparisonProcessor.BinaryComparisonOperation.LT, zoneId, evaluatorMap);
    }

    protected NodeInfo<LessThan> info() {
        return NodeInfo.create((Node)this, LessThan::new, (Object)this.left(), (Object)this.right(), (Object)this.zoneId());
    }

    protected LessThan replaceChildren(Expression newLeft, Expression newRight) {
        return new LessThan(this.source(), newLeft, newRight, this.zoneId());
    }

    public GreaterThan swapLeftAndRight() {
        return new GreaterThan(this.source(), this.right(), this.left(), this.zoneId());
    }

    public GreaterThanOrEqual negate() {
        return new GreaterThanOrEqual(this.source(), this.left(), this.right(), this.zoneId());
    }

    public BinaryComparison reverse() {
        return new GreaterThan(this.source(), this.left(), this.right(), this.zoneId());
    }

    static boolean processInts(int lhs, int rhs) {
        return lhs < rhs;
    }

    static boolean processLongs(long lhs, long rhs) {
        return lhs < rhs;
    }

    static boolean processDoubles(double lhs, double rhs) {
        return lhs < rhs;
    }

    static boolean processKeywords(BytesRef lhs, BytesRef rhs) {
        return lhs.compareTo(rhs) < 0;
    }
}

