/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.lucene.search.AutomatonQueries;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.InsensitiveBinaryComparison;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class InsensitiveEquals
extends InsensitiveBinaryComparison {
    public InsensitiveEquals(Source source, Expression left, Expression right) {
        super(source, left, right);
    }

    protected NodeInfo<InsensitiveEquals> info() {
        return NodeInfo.create((Node)this, InsensitiveEquals::new, (Object)this.left(), (Object)this.right());
    }

    protected InsensitiveEquals replaceChildren(Expression newLeft, Expression newRight) {
        return new InsensitiveEquals(this.source(), newLeft, newRight);
    }

    static boolean process(BytesRef lhs, BytesRef rhs) {
        return InsensitiveEquals.processConstant(lhs, new ByteRunAutomaton(InsensitiveEquals.automaton(rhs)));
    }

    static boolean processConstant(BytesRef lhs, ByteRunAutomaton rhs) {
        return rhs.run(lhs.bytes, lhs.offset, lhs.length);
    }

    public String symbol() {
        return "=~";
    }

    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isString((Expression)this.left(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST).and(TypeResolutions.isString((Expression)this.right(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND)).and(TypeResolutions.isFoldable((Expression)this.right(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND));
    }

    public static Automaton automaton(BytesRef val) {
        return AutomatonQueries.toCaseInsensitiveString((String)val.utf8ToString());
    }

    public Boolean fold() {
        BytesRef leftVal = BytesRefs.toBytesRef((Object)this.left().fold());
        BytesRef rightVal = BytesRefs.toBytesRef((Object)this.right().fold());
        if (leftVal == null || rightVal == null) {
            return null;
        }
        return InsensitiveEquals.process(leftVal, rightVal);
    }
}

