/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison;

import java.time.ZoneId;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.EsqlBinaryComparison;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanOrEqualDoublesEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanOrEqualIntsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanOrEqualKeywordsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanOrEqualLongsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThan;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanOrEqual;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.predicate.Negatable;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparisonProcessor;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class GreaterThanOrEqual
extends EsqlBinaryComparison
implements Negatable<BinaryComparison> {
    private static final Map<DataType, EsqlArithmeticOperation.BinaryEvaluator> evaluatorMap = Map.ofEntries(Map.entry(DataTypes.INTEGER, GreaterThanOrEqualIntsEvaluator.Factory::new), Map.entry(DataTypes.DOUBLE, GreaterThanOrEqualDoublesEvaluator.Factory::new), Map.entry(DataTypes.LONG, GreaterThanOrEqualLongsEvaluator.Factory::new), Map.entry(DataTypes.UNSIGNED_LONG, GreaterThanOrEqualLongsEvaluator.Factory::new), Map.entry(DataTypes.DATETIME, GreaterThanOrEqualLongsEvaluator.Factory::new), Map.entry(DataTypes.KEYWORD, GreaterThanOrEqualKeywordsEvaluator.Factory::new), Map.entry(DataTypes.TEXT, GreaterThanOrEqualKeywordsEvaluator.Factory::new), Map.entry(DataTypes.VERSION, GreaterThanOrEqualKeywordsEvaluator.Factory::new), Map.entry(DataTypes.IP, GreaterThanOrEqualKeywordsEvaluator.Factory::new));

    public GreaterThanOrEqual(Source source, Expression left, Expression right) {
        super(source, left, right, BinaryComparisonProcessor.BinaryComparisonOperation.GTE, evaluatorMap);
    }

    public GreaterThanOrEqual(Source source, Expression left, Expression right, ZoneId zoneId) {
        super(source, left, right, BinaryComparisonProcessor.BinaryComparisonOperation.GTE, zoneId, evaluatorMap);
    }

    protected NodeInfo<GreaterThanOrEqual> info() {
        return NodeInfo.create((Node)this, GreaterThanOrEqual::new, (Object)this.left(), (Object)this.right(), (Object)this.zoneId());
    }

    protected GreaterThanOrEqual replaceChildren(Expression newLeft, Expression newRight) {
        return new GreaterThanOrEqual(this.source(), newLeft, newRight, this.zoneId());
    }

    public LessThanOrEqual swapLeftAndRight() {
        return new LessThanOrEqual(this.source(), this.right(), this.left(), this.zoneId());
    }

    public LessThan negate() {
        return new LessThan(this.source(), this.left(), this.right(), this.zoneId());
    }

    public BinaryComparison reverse() {
        return new LessThanOrEqual(this.source(), this.left(), this.right(), this.zoneId());
    }

    static boolean processInts(int lhs, int rhs) {
        return lhs >= rhs;
    }

    static boolean processLongs(long lhs, long rhs) {
        return lhs >= rhs;
    }

    static boolean processDoubles(double lhs, double rhs) {
        return lhs >= rhs;
    }

    static boolean processKeywords(BytesRef lhs, BytesRef rhs) {
        return lhs.compareTo(rhs) >= 0;
    }
}

