/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison;

import java.time.ZoneId;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeRegistry;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparisonProcessor;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public abstract class EsqlBinaryComparison
extends BinaryComparison
implements EvaluatorMapper {
    private final Map<DataType, EsqlArithmeticOperation.BinaryEvaluator> evaluatorMap;

    protected EsqlBinaryComparison(Source source, Expression left, Expression right, BinaryComparisonProcessor.BinaryComparisonOperation operation, Map<DataType, EsqlArithmeticOperation.BinaryEvaluator> evaluatorMap) {
        this(source, left, right, operation, null, evaluatorMap);
    }

    protected EsqlBinaryComparison(Source source, Expression left, Expression right, BinaryComparisonProcessor.BinaryComparisonOperation operation, ZoneId zoneId, Map<DataType, EsqlArithmeticOperation.BinaryEvaluator> evaluatorMap) {
        super(source, left, right, operation, zoneId);
        this.evaluatorMap = evaluatorMap;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory rhs;
        EvalOperator.ExpressionEvaluator.Factory lhs;
        DataType commonType = EsqlDataTypeRegistry.INSTANCE.commonType(this.left().dataType(), this.right().dataType());
        if (commonType.isNumeric()) {
            lhs = Cast.cast(this.source(), this.left().dataType(), commonType, toEvaluator.apply(this.left()));
            rhs = Cast.cast(this.source(), this.right().dataType(), commonType, toEvaluator.apply(this.right()));
        } else {
            lhs = toEvaluator.apply(this.left());
            rhs = toEvaluator.apply(this.right());
        }
        if (!this.evaluatorMap.containsKey(commonType)) {
            throw new EsqlIllegalArgumentException("Unsupported type " + this.left().dataType());
        }
        return this.evaluatorMap.get(commonType).apply(this.source(), lhs, rhs);
    }

    @Override
    public Boolean fold() {
        return (Boolean)EvaluatorMapper.super.fold();
    }

    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution typeResolution = super.resolveType();
        if (typeResolution.unresolved()) {
            return typeResolution;
        }
        return this.checkCompatibility();
    }

    protected Expression.TypeResolution resolveInputType(Expression e, TypeResolutions.ParamOrdinal paramOrdinal) {
        return TypeResolutions.isType((Expression)e, this.evaluatorMap::containsKey, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)paramOrdinal, (String[])((String[])this.evaluatorMap.keySet().stream().map(DataType::typeName).toArray(String[]::new)));
    }

    protected Expression.TypeResolution checkCompatibility() {
        DataType leftType = this.left().dataType();
        DataType rightType = this.right().dataType();
        if (rightType == DataTypes.UNSIGNED_LONG && !(leftType == DataTypes.UNSIGNED_LONG || leftType == DataTypes.NULL) || leftType == DataTypes.UNSIGNED_LONG && !(rightType == DataTypes.UNSIGNED_LONG || rightType == DataTypes.NULL)) {
            return new Expression.TypeResolution(this.formatIncompatibleTypesMessage());
        }
        if (leftType.isNumeric() && rightType.isNumeric() || DataTypes.isString((DataType)leftType) && DataTypes.isString((DataType)rightType) || leftType.equals((Object)rightType) || DataTypes.isNull((DataType)leftType) || DataTypes.isNull((DataType)rightType)) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        return new Expression.TypeResolution(this.formatIncompatibleTypesMessage());
    }

    public String formatIncompatibleTypesMessage() {
        if (this.left().dataType().equals((Object)DataTypes.UNSIGNED_LONG)) {
            return LoggerMessageFormat.format(null, (String)"first argument of [{}] is [unsigned_long] and second is [{}]. [unsigned_long] can only be operated on together with another [unsigned_long]", (Object[])new Object[]{this.sourceText(), this.right().dataType().typeName()});
        }
        if (this.right().dataType().equals((Object)DataTypes.UNSIGNED_LONG)) {
            return LoggerMessageFormat.format(null, (String)"first argument of [{}] is [{}] and second is [unsigned_long]. [unsigned_long] can only be operated on together with another [unsigned_long]", (Object[])new Object[]{this.sourceText(), this.left().dataType().typeName()});
        }
        return LoggerMessageFormat.format(null, (String)"first argument of [{}] is [{}] so second argument must also be [{}] but was [{}]", (Object[])new Object[]{this.sourceText(), this.left().dataType().isNumeric() ? "numeric" : this.left().dataType().typeName(), this.left().dataType().isNumeric() ? "numeric" : this.left().dataType().typeName(), this.right().dataType().typeName()});
    }
}

