/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison;

import java.time.ZoneId;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.EqualsBoolsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.EqualsDoublesEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.EqualsGeometriesEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.EqualsIntsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.EqualsKeywordsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.EqualsLongsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.EsqlBinaryComparison;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.predicate.Negatable;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparisonProcessor;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Equals
extends EsqlBinaryComparison
implements Negatable<BinaryComparison> {
    private static final Map<DataType, EsqlArithmeticOperation.BinaryEvaluator> evaluatorMap = Map.ofEntries(Map.entry(DataTypes.BOOLEAN, EqualsBoolsEvaluator.Factory::new), Map.entry(DataTypes.INTEGER, EqualsIntsEvaluator.Factory::new), Map.entry(DataTypes.DOUBLE, EqualsDoublesEvaluator.Factory::new), Map.entry(DataTypes.LONG, EqualsLongsEvaluator.Factory::new), Map.entry(DataTypes.UNSIGNED_LONG, EqualsLongsEvaluator.Factory::new), Map.entry(DataTypes.DATETIME, EqualsLongsEvaluator.Factory::new), Map.entry(EsqlDataTypes.GEO_POINT, EqualsGeometriesEvaluator.Factory::new), Map.entry(EsqlDataTypes.CARTESIAN_POINT, EqualsGeometriesEvaluator.Factory::new), Map.entry(EsqlDataTypes.GEO_SHAPE, EqualsGeometriesEvaluator.Factory::new), Map.entry(EsqlDataTypes.CARTESIAN_SHAPE, EqualsGeometriesEvaluator.Factory::new), Map.entry(DataTypes.KEYWORD, EqualsKeywordsEvaluator.Factory::new), Map.entry(DataTypes.TEXT, EqualsKeywordsEvaluator.Factory::new), Map.entry(DataTypes.VERSION, EqualsKeywordsEvaluator.Factory::new), Map.entry(DataTypes.IP, EqualsKeywordsEvaluator.Factory::new));

    public Equals(Source source, Expression left, Expression right) {
        super(source, left, right, BinaryComparisonProcessor.BinaryComparisonOperation.EQ, evaluatorMap);
    }

    public Equals(Source source, Expression left, Expression right, ZoneId zoneId) {
        super(source, left, right, BinaryComparisonProcessor.BinaryComparisonOperation.EQ, zoneId, evaluatorMap);
    }

    protected NodeInfo<Equals> info() {
        return NodeInfo.create((Node)this, Equals::new, (Object)this.left(), (Object)this.right(), (Object)this.zoneId());
    }

    protected Equals replaceChildren(Expression newLeft, Expression newRight) {
        return new Equals(this.source(), newLeft, newRight, this.zoneId());
    }

    public Equals swapLeftAndRight() {
        return new Equals(this.source(), this.right(), this.left(), this.zoneId());
    }

    public BinaryComparison reverse() {
        return this;
    }

    public BinaryComparison negate() {
        return new NotEquals(this.source(), this.left(), this.right(), this.zoneId());
    }

    static boolean processInts(int lhs, int rhs) {
        return lhs == rhs;
    }

    static boolean processLongs(long lhs, long rhs) {
        return lhs == rhs;
    }

    static boolean processDoubles(double lhs, double rhs) {
        return lhs == rhs;
    }

    static boolean processKeywords(BytesRef lhs, BytesRef rhs) {
        return lhs.equals((Object)rhs);
    }

    static boolean processBools(boolean lhs, boolean rhs) {
        return lhs == rhs;
    }

    static boolean processGeometries(BytesRef lhs, BytesRef rhs) {
        return lhs.equals((Object)rhs);
    }
}

