/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.type.EsField;

public record ResolvedEnrichPolicy(String matchField, String matchType, List<String> enrichFields, Map<String, String> concreteIndices, Map<String, EsField> mapping) implements Writeable
{
    public ResolvedEnrichPolicy(StreamInput in) throws IOException {
        this(in.readString(), in.readString(), in.readStringCollectionAsList(), in.readMap(StreamInput::readString), in.readMap(StreamInput::readString, ResolvedEnrichPolicy::readEsField));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.matchField);
        out.writeString(this.matchType);
        out.writeStringCollection(this.enrichFields);
        out.writeMap(this.concreteIndices, StreamOutput::writeString);
        out.writeMap(this.mapping, ResolvedEnrichPolicy::writeEsField);
    }

    private static void writeEsField(StreamOutput out, EsField field) throws IOException {
        out.writeString(field.getName());
        out.writeString(field.getDataType().typeName());
        out.writeMap(field.getProperties(), ResolvedEnrichPolicy::writeEsField);
        out.writeBoolean(field.isAggregatable());
        out.writeBoolean(field.isAlias());
    }

    private static EsField readEsField(StreamInput in) throws IOException {
        return new EsField(in.readString(), EsqlDataTypes.fromTypeName(in.readString()), in.readMap(ResolvedEnrichPolicy::readEsField), in.readBoolean(), in.readBoolean());
    }
}

