/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.analysis;

import java.util.Collection;
import java.util.Map;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.xpack.esql.enrich.ResolvedEnrichPolicy;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;

public final class EnrichResolution {
    private final Map<Key, ResolvedEnrichPolicy> resolvedPolicies = ConcurrentCollections.newConcurrentMap();
    private final Map<Key, String> errors = ConcurrentCollections.newConcurrentMap();

    public ResolvedEnrichPolicy getResolvedPolicy(String policyName, Enrich.Mode mode) {
        return this.resolvedPolicies.get(new Key(policyName, mode));
    }

    public Collection<ResolvedEnrichPolicy> resolvedEnrichPolicies() {
        return this.resolvedPolicies.values();
    }

    public String getError(String policyName, Enrich.Mode mode) {
        String error = this.errors.get(new Key(policyName, mode));
        if (error != null) {
            return error;
        }
        assert (false) : "unresolved enrich policy [" + policyName + "] mode [" + mode + "]";
        return "unresolved enrich policy [" + policyName + "] mode [" + mode + "]";
    }

    public void addResolvedPolicy(String policyName, Enrich.Mode mode, ResolvedEnrichPolicy policy) {
        this.resolvedPolicies.putIfAbsent(new Key(policyName, mode), policy);
    }

    public void addError(String policyName, Enrich.Mode mode, String reason) {
        this.errors.putIfAbsent(new Key(policyName, mode), reason);
    }

    private record Key(String policyName, Enrich.Mode mode) {
    }
}

