/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.analysis.AnalyzerContext;
import org.elasticsearch.xpack.esql.analysis.Verifier;
import org.elasticsearch.xpack.esql.enrich.ResolvedEnrichPolicy;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.expression.UnresolvedNamePattern;
import org.elasticsearch.xpack.esql.expression.function.EsqlFunctionRegistry;
import org.elasticsearch.xpack.esql.expression.function.UnsupportedAttribute;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.In;
import org.elasticsearch.xpack.esql.plan.logical.Drop;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.EsqlAggregate;
import org.elasticsearch.xpack.esql.plan.logical.EsqlUnresolvedRelation;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Keep;
import org.elasticsearch.xpack.esql.plan.logical.MvExpand;
import org.elasticsearch.xpack.esql.plan.logical.Rename;
import org.elasticsearch.xpack.esql.plan.logical.local.EsqlProject;
import org.elasticsearch.xpack.esql.stats.FeatureMetric;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.analyzer.AnalyzerRules;
import org.elasticsearch.xpack.ql.capabilities.Resolvables;
import org.elasticsearch.xpack.ql.common.Failure;
import org.elasticsearch.xpack.ql.expression.Alias;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.AttributeMap;
import org.elasticsearch.xpack.ql.expression.EmptyAttribute;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.expression.ReferenceAttribute;
import org.elasticsearch.xpack.ql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.ql.expression.UnresolvedStar;
import org.elasticsearch.xpack.ql.expression.function.Function;
import org.elasticsearch.xpack.ql.expression.function.FunctionDefinition;
import org.elasticsearch.xpack.ql.expression.function.FunctionRegistry;
import org.elasticsearch.xpack.ql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.predicate.BinaryOperator;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.ql.index.EsIndex;
import org.elasticsearch.xpack.ql.plan.TableIdentifier;
import org.elasticsearch.xpack.ql.plan.logical.Aggregate;
import org.elasticsearch.xpack.ql.plan.logical.EsRelation;
import org.elasticsearch.xpack.ql.plan.logical.Limit;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.Project;
import org.elasticsearch.xpack.ql.rule.ParameterizedRule;
import org.elasticsearch.xpack.ql.rule.ParameterizedRuleExecutor;
import org.elasticsearch.xpack.ql.rule.Rule;
import org.elasticsearch.xpack.ql.rule.RuleExecutor;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.type.EsField;
import org.elasticsearch.xpack.ql.type.InvalidMappedField;
import org.elasticsearch.xpack.ql.type.UnsupportedEsField;
import org.elasticsearch.xpack.ql.util.CollectionUtils;
import org.elasticsearch.xpack.ql.util.Holder;
import org.elasticsearch.xpack.ql.util.StringUtils;

public class Analyzer
extends ParameterizedRuleExecutor<LogicalPlan, AnalyzerContext> {
    public static final List<Attribute> NO_FIELDS = List.of(new ReferenceAttribute(Source.EMPTY, "<no-fields>", DataTypes.NULL, null, Nullability.TRUE, null, true));
    private static final Iterable<RuleExecutor.Batch<LogicalPlan>> rules;
    private final Verifier verifier;

    public Analyzer(AnalyzerContext context, Verifier verifier) {
        super((Object)context);
        this.verifier = verifier;
    }

    public LogicalPlan analyze(LogicalPlan plan) {
        BitSet partialMetrics = new BitSet(FeatureMetric.values().length);
        return this.verify((LogicalPlan)this.execute((Node)plan), this.gatherPreAnalysisMetrics(plan, partialMetrics));
    }

    public LogicalPlan verify(LogicalPlan plan, BitSet partialMetrics) {
        Collection<Failure> failures = this.verifier.verify(plan, partialMetrics);
        if (!failures.isEmpty()) {
            throw new VerificationException(failures);
        }
        return plan;
    }

    protected Iterable<RuleExecutor.Batch<LogicalPlan>> batches() {
        return rules;
    }

    private static List<Attribute> mappingAsAttributes(Source source, Map<String, EsField> mapping) {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        Analyzer.mappingAsAttributes(list, source, null, mapping);
        list.sort(Comparator.comparing(Attribute::qualifiedName));
        return list;
    }

    private static void mappingAsAttributes(List<Attribute> list, Source source, String parentName, Map<String, EsField> mapping) {
        for (Map.Entry<String, EsField> entry : mapping.entrySet()) {
            String name = entry.getKey();
            EsField t = entry.getValue();
            if (t == null) continue;
            name = parentName == null ? name : parentName + "." + name;
            Map fieldProperties = t.getProperties();
            DataType type = EsqlDataTypes.widenSmallNumericTypes(t.getDataType());
            if (type != t.getDataType()) {
                t = new EsField(t.getName(), type, t.getProperties(), t.isAggregatable(), t.isAlias());
            }
            if (EsqlDataTypes.isPrimitive(type)) {
                FieldAttribute attribute;
                if (t instanceof UnsupportedEsField) {
                    UnsupportedEsField uef = (UnsupportedEsField)t;
                    attribute = new UnsupportedAttribute(source, name, uef);
                } else {
                    attribute = new FieldAttribute(source, null, name, t);
                }
                list.add((Attribute)attribute);
            }
            if (type == DataTypes.NESTED || fieldProperties.isEmpty()) continue;
            Analyzer.mappingAsAttributes(list, source, name, fieldProperties);
        }
    }

    private static List<Attribute> resolveAgainstList(UnresolvedNamePattern up, Collection<Attribute> attrList) {
        UnresolvedAttribute ua = new UnresolvedAttribute(up.source(), up.pattern(), null);
        Predicate<Attribute> matcher = a -> up.match(a.name()) || up.match(a.qualifiedName());
        List matches = AnalyzerRules.maybeResolveAgainstList(matcher, () -> ua, attrList, (boolean)true, a -> Analyzer.handleSpecialFields(ua, a));
        return Analyzer.potentialCandidatesIfNoMatchesFound(ua, matches, attrList, list -> UnresolvedNamePattern.errorMessage(up.pattern(), list));
    }

    private static List<Attribute> resolveAgainstList(UnresolvedAttribute ua, Collection<Attribute> attrList) {
        List matches = AnalyzerRules.maybeResolveAgainstList((UnresolvedAttribute)ua, attrList, a -> Analyzer.handleSpecialFields(ua, a));
        return Analyzer.potentialCandidatesIfNoMatchesFound(ua, matches, attrList, list -> UnresolvedAttribute.errorMessage((String)ua.name(), (List)list));
    }

    private static List<Attribute> potentialCandidatesIfNoMatchesFound(UnresolvedAttribute ua, List<Attribute> matches, Collection<Attribute> attrList, java.util.function.Function<List<String>, String> messageProducer) {
        if (matches.isEmpty()) {
            HashSet<String> names = new HashSet<String>(attrList.size());
            for (Attribute a : attrList) {
                String nameCandidate = a.name();
                if (!EsqlDataTypes.isPrimitive(a.dataType())) continue;
                names.add(nameCandidate);
            }
            String name = ua.name();
            UnresolvedAttribute unresolved = ua.withUnresolvedMessage(messageProducer.apply(StringUtils.findSimilar((String)name, names)));
            matches = Collections.singletonList(unresolved);
        }
        return matches;
    }

    private static Attribute handleSpecialFields(UnresolvedAttribute u, Attribute named) {
        FieldAttribute fa;
        EsField field;
        if (named instanceof FieldAttribute && (field = (fa = (FieldAttribute)named).field()) instanceof InvalidMappedField) {
            InvalidMappedField imf = (InvalidMappedField)field;
            named = u.withUnresolvedMessage("Cannot use field [" + fa.name() + "] due to ambiguities being " + imf.errorMessage());
        }
        return named.withLocation(u.source());
    }

    private BitSet gatherPreAnalysisMetrics(LogicalPlan plan, BitSet b) {
        if (!plan.collectFirstChildren(Limit.class::isInstance).isEmpty()) {
            b.set(FeatureMetric.LIMIT.ordinal());
        }
        plan.forEachDown(p -> FeatureMetric.set(p, b));
        return b;
    }

    static {
        RuleExecutor.Batch resolution = new RuleExecutor.Batch("Resolution", new Rule[]{new ResolveTable(), new ResolveEnrich(), new ResolveFunctions(), new ResolveRefs(), new ImplicitCasting()});
        RuleExecutor.Batch finish = new RuleExecutor.Batch("Finish Analysis", RuleExecutor.Limiter.ONCE, new Rule[]{new AddImplicitLimit()});
        rules = List.of(resolution, finish);
    }

    private static class ResolveTable
    extends AnalyzerRules.ParameterizedAnalyzerRule<EsqlUnresolvedRelation, AnalyzerContext> {
        private ResolveTable() {
        }

        protected LogicalPlan rule(EsqlUnresolvedRelation plan, AnalyzerContext context) {
            if (!context.indexResolution().isValid()) {
                return plan.unresolvedMessage().equals(context.indexResolution().toString()) ? plan : new EsqlUnresolvedRelation(plan.source(), plan.table(), plan.metadataFields(), context.indexResolution().toString());
            }
            TableIdentifier table = plan.table();
            if (!context.indexResolution().matches(table.index())) {
                new EsqlUnresolvedRelation(plan.source(), plan.table(), plan.metadataFields(), "invalid [" + table + "] resolution to [" + context.indexResolution() + "]");
            }
            EsIndex esIndex = context.indexResolution().get();
            List<Attribute> attributes = Analyzer.mappingAsAttributes(plan.source(), esIndex.mapping());
            attributes.addAll(plan.metadataFields());
            return new EsRelation(plan.source(), esIndex, attributes.isEmpty() ? NO_FIELDS : attributes);
        }
    }

    private static class ResolveEnrich
    extends AnalyzerRules.ParameterizedAnalyzerRule<Enrich, AnalyzerContext> {
        private ResolveEnrich() {
        }

        protected LogicalPlan rule(Enrich plan, AnalyzerContext context) {
            if (!plan.policyName().resolved()) {
                return plan;
            }
            String policyName = (String)plan.policyName().fold();
            ResolvedEnrichPolicy resolved = context.enrichResolution().getResolvedPolicy(policyName, plan.mode());
            if (resolved != null) {
                EnrichPolicy policy = new EnrichPolicy(resolved.matchType(), null, List.of(), resolved.matchField(), resolved.enrichFields());
                UnresolvedAttribute matchField = plan.matchField() == null || plan.matchField() instanceof EmptyAttribute ? new UnresolvedAttribute(plan.source(), policy.getMatchField()) : plan.matchField();
                List<NamedExpression> enrichFields = ResolveEnrich.calculateEnrichFields(plan.source(), policyName, Analyzer.mappingAsAttributes(plan.source(), resolved.mapping()), plan.enrichFields(), policy);
                return new Enrich(plan.source(), plan.child(), plan.mode(), plan.policyName(), (NamedExpression)matchField, policy, resolved.concreteIndices(), enrichFields);
            }
            String error = context.enrichResolution().getError(policyName, plan.mode());
            UnresolvedAttribute policyNameExp = new UnresolvedAttribute(plan.policyName().source(), policyName, null, error);
            return new Enrich(plan.source(), plan.child(), plan.mode(), (Expression)policyNameExp, plan.matchField(), null, Map.of(), List.of());
        }

        public static List<NamedExpression> calculateEnrichFields(Source source, String policyName, List<Attribute> mapping, List<NamedExpression> enrichFields, EnrichPolicy policy) {
            HashSet policyEnrichFieldSet = new HashSet(policy.getEnrichFields());
            Map<String, Attribute> fieldMap = mapping.stream().filter(e -> policyEnrichFieldSet.contains(e.name())).collect(Collectors.toMap(NamedExpression::name, java.util.function.Function.identity()));
            ArrayList<NamedExpression> result = new ArrayList<NamedExpression>();
            if (enrichFields == null || enrichFields.isEmpty()) {
                for (String enrichFieldName : policy.getEnrichFields()) {
                    result.add(ResolveEnrich.createEnrichFieldExpression(source, policyName, fieldMap, enrichFieldName));
                }
            } else {
                for (NamedExpression enrichField : enrichFields) {
                    NamedExpression namedExpression;
                    NamedExpression namedExpression2;
                    if (enrichField instanceof Alias) {
                        Alias a = (Alias)enrichField;
                        namedExpression2 = a.child();
                    } else {
                        namedExpression2 = enrichField;
                    }
                    String enrichFieldName = Expressions.name((Expression)namedExpression2);
                    NamedExpression field = ResolveEnrich.createEnrichFieldExpression(source, policyName, fieldMap, enrichFieldName);
                    if (enrichField instanceof Alias) {
                        Alias a = (Alias)enrichField;
                        namedExpression = new Alias(a.source(), a.name(), (Expression)field);
                    } else {
                        namedExpression = field;
                    }
                    result.add(namedExpression);
                }
            }
            return result;
        }

        private static NamedExpression createEnrichFieldExpression(Source source, String policyName, Map<String, Attribute> fieldMap, String enrichFieldName) {
            Attribute mappedField = fieldMap.get(enrichFieldName);
            if (mappedField == null) {
                String msg = "Enrich field [" + enrichFieldName + "] not found in enrich policy [" + policyName + "]";
                List similar = StringUtils.findSimilar((String)enrichFieldName, fieldMap.keySet());
                if (!CollectionUtils.isEmpty((Collection)similar)) {
                    msg = msg + ", did you mean " + (similar.size() == 1 ? "[" + (String)similar.get(0) + "]" : "any of " + similar) + "?";
                }
                return new UnresolvedAttribute(source, enrichFieldName, null, msg);
            }
            return new ReferenceAttribute(source, enrichFieldName, mappedField.dataType(), null, Nullability.TRUE, null, false);
        }
    }

    private static class ResolveFunctions
    extends AnalyzerRules.ParameterizedAnalyzerRule<LogicalPlan, AnalyzerContext> {
        private ResolveFunctions() {
        }

        protected LogicalPlan rule(LogicalPlan plan, AnalyzerContext context) {
            return (LogicalPlan)plan.transformExpressionsOnly(UnresolvedFunction.class, uf -> ResolveFunctions.resolveFunction(uf, context.configuration(), context.functionRegistry()));
        }

        public static Function resolveFunction(UnresolvedFunction uf, Configuration configuration, FunctionRegistry functionRegistry) {
            UnresolvedFunction f = null;
            if (uf.analyzed()) {
                f = uf;
            } else {
                String functionName = functionRegistry.resolveAlias(uf.name());
                if (!functionRegistry.functionExists(functionName)) {
                    f = uf.missing(functionName, (Iterable)functionRegistry.listFunctions());
                } else {
                    FunctionDefinition def = functionRegistry.resolveFunction(functionName);
                    f = uf.buildResolved(configuration, def);
                }
            }
            return f;
        }
    }

    private static class ResolveRefs
    extends AnalyzerRules.BaseAnalyzerRule {
        private static final DataType[] GEO_TYPES = new DataType[]{EsqlDataTypes.GEO_POINT, EsqlDataTypes.GEO_SHAPE};
        private static final DataType[] NON_GEO_TYPES = new DataType[]{DataTypes.KEYWORD, DataTypes.TEXT, DataTypes.IP, DataTypes.LONG, DataTypes.INTEGER, DataTypes.FLOAT, DataTypes.DOUBLE, DataTypes.DATETIME};

        private ResolveRefs() {
        }

        protected LogicalPlan doRule(LogicalPlan plan) {
            Object p;
            ArrayList<Attribute> childrenOutput = new ArrayList<Attribute>();
            for (LogicalPlan child : plan.children()) {
                List output = child.output();
                childrenOutput.addAll(output);
            }
            if (plan instanceof Aggregate) {
                Aggregate agg = (Aggregate)plan;
                return this.resolveAggregate(agg, childrenOutput);
            }
            if (plan instanceof Drop) {
                Drop d = (Drop)plan;
                return this.resolveDrop(d, childrenOutput);
            }
            if (plan instanceof Rename) {
                Rename r = (Rename)plan;
                return this.resolveRename(r, childrenOutput);
            }
            if (plan instanceof Keep) {
                p = (Keep)plan;
                return this.resolveKeep((Project)p, (List<Attribute>)childrenOutput);
            }
            if (plan instanceof Eval) {
                p = (Eval)plan;
                return this.resolveEval((Eval)((Object)p), childrenOutput);
            }
            if (plan instanceof Enrich) {
                p = (Enrich)plan;
                return this.resolveEnrich((Enrich)((Object)p), childrenOutput);
            }
            if (plan instanceof MvExpand) {
                p = (MvExpand)plan;
                return this.resolveMvExpand((MvExpand)((Object)p), childrenOutput);
            }
            return (LogicalPlan)plan.transformExpressionsOnly(UnresolvedAttribute.class, ua -> this.maybeResolveAttribute((UnresolvedAttribute)ua, (List<Attribute>)childrenOutput));
        }

        private LogicalPlan resolveAggregate(Aggregate a, List<Attribute> childrenOutput) {
            Holder changed = new Holder((Object)false);
            ArrayList<Expression> groupings = a.groupings();
            if (!Resolvables.resolved((Iterable)groupings)) {
                ArrayList<Expression> newGroupings = new ArrayList<Expression>(groupings.size());
                for (Expression g : groupings) {
                    Expression resolved = (Expression)g.transformUp(UnresolvedAttribute.class, ua -> this.maybeResolveAttribute((UnresolvedAttribute)ua, childrenOutput));
                    if (resolved != g) {
                        changed.set((Object)true);
                    }
                    newGroupings.add(resolved);
                }
                groupings = newGroupings;
                if (((Boolean)changed.get()).booleanValue()) {
                    a = new EsqlAggregate(a.source(), a.child(), newGroupings, a.aggregates());
                    changed.set((Object)false);
                }
            }
            if (!a.expressionsResolved()) {
                AttributeMap resolved = new AttributeMap();
                for (Expression e : groupings) {
                    Attribute attr = Expressions.attribute((Expression)e);
                    if (attr == null || !attr.resolved()) continue;
                    resolved.put(attr, (Object)attr);
                }
                List<Attribute> resolvedList = NamedExpressions.mergeOutputAttributes(new ArrayList(resolved.keySet()), childrenOutput);
                ArrayList<NamedExpression> newAggregates = new ArrayList<NamedExpression>();
                for (NamedExpression aggregate : a.aggregates()) {
                    NamedExpression agg = (NamedExpression)aggregate.transformUp(UnresolvedAttribute.class, ua -> {
                        UnresolvedAttribute ne = ua;
                        Attribute maybeResolved = this.maybeResolveAttribute((UnresolvedAttribute)ua, resolvedList);
                        if (maybeResolved != null) {
                            changed.set((Object)true);
                            ne = maybeResolved;
                        }
                        return ne;
                    });
                    newAggregates.add(agg);
                }
                a = (Boolean)changed.get() != false ? new EsqlAggregate(a.source(), a.child(), groupings, newAggregates) : a;
            }
            return a;
        }

        private LogicalPlan resolveMvExpand(MvExpand p, List<Attribute> childrenOutput) {
            NamedExpression namedExpression = p.target();
            if (namedExpression instanceof UnresolvedAttribute) {
                UnresolvedAttribute ua = (UnresolvedAttribute)namedExpression;
                Attribute resolved = this.maybeResolveAttribute(ua, childrenOutput);
                if (resolved == ua) {
                    return p;
                }
                return new MvExpand(p.source(), p.child(), (NamedExpression)resolved, (Attribute)(resolved.resolved() ? new ReferenceAttribute(resolved.source(), resolved.name(), resolved.dataType(), null, resolved.nullable(), null, false) : resolved));
            }
            return p;
        }

        private Attribute maybeResolveAttribute(UnresolvedAttribute ua, List<Attribute> childrenOutput) {
            if (ua.customMessage()) {
                return ua;
            }
            return this.resolveAttribute(ua, childrenOutput);
        }

        private Attribute resolveAttribute(UnresolvedAttribute ua, List<Attribute> childrenOutput) {
            UnresolvedAttribute resolved = ua;
            List<Attribute> named = Analyzer.resolveAgainstList(ua, childrenOutput);
            if (named.size() == 1) {
                resolved = named.get(0);
                if (this.log.isTraceEnabled() && resolved.resolved()) {
                    this.log.trace("Resolved {} to {}", (Object)ua, (Object)resolved);
                }
            } else if (named.size() > 0) {
                resolved = ua.withUnresolvedMessage("Resolved [" + ua + "] unexpectedly to multiple attributes " + named);
            }
            return resolved;
        }

        private LogicalPlan resolveEval(Eval eval, List<Attribute> childOutput) {
            ArrayList<Attribute> allResolvedInputs = new ArrayList<Attribute>(childOutput);
            ArrayList<Alias> newFields = new ArrayList<Alias>();
            boolean changed = false;
            for (Alias field : eval.fields()) {
                Alias result = (Alias)field.transformUp(UnresolvedAttribute.class, ua -> this.resolveAttribute((UnresolvedAttribute)ua, (List<Attribute>)allResolvedInputs));
                changed |= result != field;
                newFields.add(result);
                if (!result.resolved()) continue;
                Attribute existing = allResolvedInputs.stream().filter(attr -> attr.name().equals(result.name())).findFirst().orElse(null);
                if (existing != null) {
                    allResolvedInputs.remove(existing);
                }
                allResolvedInputs.add(result.toAttribute());
            }
            return changed ? new Eval(eval.source(), eval.child(), newFields) : eval;
        }

        private LogicalPlan resolveKeep(Project p, List<Attribute> childOutput) {
            ArrayList<Object> resolvedProjections = new ArrayList<Attribute>();
            List projections = p.projections();
            if (projections.isEmpty() || projections.size() == 1 && projections.get(0) instanceof UnresolvedStar) {
                resolvedProjections.addAll(childOutput);
            } else {
                LinkedHashMap<Attribute, Integer> priorities = new LinkedHashMap<Attribute, Integer>();
                for (NamedExpression proj : projections) {
                    int priority;
                    List<Attribute> resolved;
                    if (proj instanceof UnresolvedStar) {
                        resolved = childOutput;
                        priority = 2;
                    } else if (proj instanceof UnresolvedNamePattern) {
                        UnresolvedNamePattern up = (UnresolvedNamePattern)proj;
                        resolved = Analyzer.resolveAgainstList(up, childOutput);
                        priority = 1;
                    } else if (proj instanceof UnresolvedAttribute) {
                        UnresolvedAttribute ua = (UnresolvedAttribute)proj;
                        resolved = Analyzer.resolveAgainstList(ua, childOutput);
                        priority = 0;
                    } else {
                        throw new EsqlIllegalArgumentException("unexpected projection: " + proj);
                    }
                    for (Attribute attr : resolved) {
                        Integer previousPrio = (Integer)priorities.get(attr);
                        if (previousPrio != null && previousPrio < priority) continue;
                        priorities.remove(attr);
                        priorities.put(attr, priority);
                    }
                }
                resolvedProjections = new ArrayList(priorities.keySet());
            }
            return new EsqlProject(p.source(), p.child(), resolvedProjections);
        }

        private LogicalPlan resolveDrop(Drop drop, List<Attribute> childOutput) {
            ArrayList<Attribute> resolvedProjections = new ArrayList<Attribute>(childOutput);
            for (NamedExpression ne : drop.removals()) {
                List<NamedExpression> resolved;
                if (ne instanceof UnresolvedNamePattern) {
                    UnresolvedNamePattern np = (UnresolvedNamePattern)ne;
                    resolved = Analyzer.resolveAgainstList(np, childOutput);
                } else if (ne instanceof UnresolvedAttribute) {
                    UnresolvedAttribute ua = (UnresolvedAttribute)ne;
                    resolved = Analyzer.resolveAgainstList(ua, childOutput);
                } else {
                    resolved = Collections.singletonList(ne);
                }
                resolvedProjections.removeIf(resolved::contains);
                resolved.forEach(r -> {
                    if (!r.resolved() && !(r instanceof UnsupportedAttribute)) {
                        resolvedProjections.add((Attribute)r);
                    }
                });
            }
            return new EsqlProject(drop.source(), drop.child(), resolvedProjections);
        }

        private LogicalPlan resolveRename(Rename rename, List<Attribute> childrenOutput) {
            ArrayList<Attribute> projections = new ArrayList<Attribute>(childrenOutput);
            int renamingsCount = rename.renamings().size();
            ArrayList unresolved = new ArrayList(renamingsCount);
            HashMap reverseAliasing = new HashMap(renamingsCount);
            rename.renamings().forEach(alias -> {
                Expression patt28249$temp = alias.child();
                if (patt28249$temp instanceof UnresolvedAttribute) {
                    UnresolvedAttribute ua = (UnresolvedAttribute)patt28249$temp;
                    if (!alias.name().equals(ua.name())) {
                        projections.removeIf(x -> x.name().equals(alias.name()));
                        Attribute resolved = this.maybeResolveAttribute(ua, childrenOutput);
                        if (resolved instanceof UnsupportedAttribute || resolved.resolved()) {
                            Alias realiased = alias.replaceChildren(List.of(resolved));
                            projections.replaceAll(arg_0 -> ResolveRefs.lambda$resolveRename$7(resolved, (NamedExpression)realiased, arg_0));
                            childrenOutput.removeIf(x -> x.equals((Object)resolved));
                            reverseAliasing.put(resolved.name(), alias.name());
                        } else {
                            boolean updated = false;
                            if (reverseAliasing.containsValue(resolved.name())) {
                                ListIterator<Alias> li = projections.listIterator();
                                while (li.hasNext()) {
                                    Alias a;
                                    Object patt29556$temp = li.next();
                                    if (!(patt29556$temp instanceof Alias) || !(a = (Alias)patt29556$temp).name().equals(resolved.name())) continue;
                                    reverseAliasing.put(resolved.name(), alias.name());
                                    li.set(alias.replaceChildren(a.children()));
                                    updated = true;
                                    break;
                                }
                            }
                            if (!updated) {
                                Attribute u = resolved;
                                String previousAliasName = (String)reverseAliasing.get(resolved.name());
                                if (previousAliasName != null) {
                                    String message = LoggerMessageFormat.format(null, (String)"Column [{}] renamed to [{}] and is no longer available [{}]", (Object[])new Object[]{resolved.name(), previousAliasName, alias.sourceText()});
                                    u = ua.withUnresolvedMessage(message);
                                }
                                unresolved.add(u);
                            }
                        }
                    }
                }
            });
            projections.addAll(unresolved);
            return new EsqlProject(rename.source(), rename.child(), projections);
        }

        private LogicalPlan resolveEnrich(Enrich enrich, List<Attribute> childrenOutput) {
            Attribute attribute = enrich.matchField().toAttribute();
            if (attribute instanceof UnresolvedAttribute) {
                UnresolvedAttribute ua = (UnresolvedAttribute)attribute;
                Attribute resolved = this.maybeResolveAttribute(ua, childrenOutput);
                if (resolved.equals((Object)ua)) {
                    return enrich;
                }
                if (resolved.resolved() && enrich.policy() != null) {
                    DataType dataType = resolved.dataType();
                    String matchType = enrich.policy().getType();
                    Object[] allowed = this.allowedEnrichTypes(matchType);
                    if (!Arrays.asList(allowed).contains(dataType)) {
                        String suffix = "only " + Arrays.toString(allowed) + " allowed for type [" + matchType + "]";
                        resolved = ua.withUnresolvedMessage("Unsupported type [" + resolved.dataType() + "] for enrich matching field [" + ua.name() + "]; " + suffix);
                    }
                }
                return new Enrich(enrich.source(), enrich.child(), enrich.mode(), enrich.policyName(), (NamedExpression)resolved, enrich.policy(), enrich.concreteIndices(), enrich.enrichFields());
            }
            return enrich;
        }

        private DataType[] allowedEnrichTypes(String matchType) {
            return matchType.equals("geo_match") ? GEO_TYPES : NON_GEO_TYPES;
        }

        private static /* synthetic */ NamedExpression lambda$resolveRename$7(Attribute resolved, NamedExpression realiased, NamedExpression x) {
            return x.equals((Object)resolved) ? realiased : x;
        }
    }

    private static class ImplicitCasting
    extends ParameterizedRule<LogicalPlan, LogicalPlan, AnalyzerContext> {
        private ImplicitCasting() {
        }

        public LogicalPlan apply(LogicalPlan plan, AnalyzerContext context) {
            return (LogicalPlan)plan.transformExpressionsUp(ScalarFunction.class, e -> ImplicitCasting.cast(e, (EsqlFunctionRegistry)context.functionRegistry()));
        }

        private static Expression cast(ScalarFunction f, EsqlFunctionRegistry registry) {
            if (f instanceof EsqlScalarFunction) {
                EsqlScalarFunction esf = (EsqlScalarFunction)f;
                return ImplicitCasting.processScalarFunction(esf, registry);
            }
            if (f instanceof EsqlArithmeticOperation || f instanceof BinaryComparison) {
                return ImplicitCasting.processBinaryOperator((BinaryOperator)f);
            }
            if (f instanceof In) {
                In in = (In)f;
                return ImplicitCasting.processIn(in);
            }
            return f;
        }

        private static Expression processScalarFunction(EsqlScalarFunction f, EsqlFunctionRegistry registry) {
            List args = f.arguments();
            List<DataType> targetDataTypes = registry.getDataTypeForStringLiteralConversion(f.getClass());
            if (targetDataTypes == null || targetDataTypes.isEmpty()) {
                return f;
            }
            ArrayList<Expression> newChildren = new ArrayList<Expression>(args.size());
            boolean childrenChanged = false;
            DataType targetDataType = DataTypes.NULL;
            for (int i = 0; i < args.size(); ++i) {
                Expression arg = (Expression)args.get(i);
                if (arg.resolved() && arg.dataType() == DataTypes.KEYWORD && arg.foldable() && !(arg instanceof EsqlScalarFunction)) {
                    if (i < targetDataTypes.size()) {
                        targetDataType = targetDataTypes.get(i);
                    }
                    if (targetDataType != DataTypes.NULL && targetDataType != DataTypes.UNSUPPORTED) {
                        Expression e = ImplicitCasting.castStringLiteral(arg, targetDataType);
                        childrenChanged = true;
                        newChildren.add(e);
                        continue;
                    }
                }
                newChildren.add((Expression)args.get(i));
            }
            return childrenChanged ? (Expression)f.replaceChildren(newChildren) : f;
        }

        private static Expression processBinaryOperator(BinaryOperator<?, ?, ?, ?> o) {
            Expression left = o.left();
            Expression right = o.right();
            if (!left.resolved() || !right.resolved()) {
                return o;
            }
            ArrayList<Expression> newChildren = new ArrayList<Expression>(2);
            boolean childrenChanged = false;
            DataType targetDataType = DataTypes.NULL;
            Literal from = Literal.NULL;
            if (left.dataType() == DataTypes.KEYWORD && left.foldable() && ImplicitCasting.supportsImplicitCasting(right.dataType()) && !(left instanceof EsqlScalarFunction)) {
                targetDataType = right.dataType();
                from = left;
            }
            if (right.dataType() == DataTypes.KEYWORD && right.foldable() && ImplicitCasting.supportsImplicitCasting(left.dataType()) && !(right instanceof EsqlScalarFunction)) {
                targetDataType = left.dataType();
                from = right;
            }
            if (from != Literal.NULL) {
                Expression e = ImplicitCasting.castStringLiteral((Expression)from, targetDataType);
                newChildren.add(from == left ? e : left);
                newChildren.add(from == right ? e : right);
                childrenChanged = true;
            }
            return childrenChanged ? o.replaceChildren(newChildren) : o;
        }

        private static Expression processIn(In in) {
            Expression left = in.value();
            List right = in.list();
            if (!left.resolved() || !ImplicitCasting.supportsImplicitCasting(left.dataType())) {
                return in;
            }
            ArrayList<Expression> newChildren = new ArrayList<Expression>(right.size() + 1);
            boolean childrenChanged = false;
            for (Expression value : right) {
                if (value.dataType() == DataTypes.KEYWORD && value.foldable()) {
                    Expression e = ImplicitCasting.castStringLiteral(value, left.dataType());
                    newChildren.add(e);
                    childrenChanged = true;
                    continue;
                }
                newChildren.add(value);
            }
            newChildren.add(left);
            return childrenChanged ? in.replaceChildren(newChildren) : in;
        }

        private static boolean supportsImplicitCasting(DataType type) {
            return type == DataTypes.DATETIME || type == DataTypes.IP || type == DataTypes.VERSION || type == DataTypes.BOOLEAN;
        }

        public static Expression castStringLiteral(Expression from, DataType target) {
            assert (from.foldable());
            try {
                Object to = EsqlDataTypeConverter.convert(from.fold(), target);
                return new Literal(from.source(), to, target);
            }
            catch (Exception e) {
                String message = LoggerMessageFormat.format((String)"Cannot convert string [{}] to [{}], error [{}]", (Object[])new Object[]{from.fold(), target, e.getMessage()});
                return new UnsupportedAttribute(from.source(), String.valueOf(from.fold()), new UnsupportedEsField(String.valueOf(from.fold()), from.dataType().typeName()), message);
            }
        }
    }

    private static class AddImplicitLimit
    extends ParameterizedRule<LogicalPlan, LogicalPlan, AnalyzerContext> {
        private AddImplicitLimit() {
        }

        public LogicalPlan apply(LogicalPlan logicalPlan, AnalyzerContext context) {
            int limit;
            List limits = logicalPlan.collectFirstChildren(Limit.class::isInstance);
            if (limits.isEmpty()) {
                HeaderWarning.addWarning((String)"No limit defined, adding default limit of [{}]", (Object[])new Object[]{context.configuration().resultTruncationDefaultSize()});
                limit = context.configuration().resultTruncationDefaultSize();
            } else {
                limit = context.configuration().resultTruncationMaxSize();
            }
            Source source = logicalPlan.source();
            return new Limit(source, (Expression)new Literal(source, (Object)limit, DataTypes.INTEGER), logicalPlan);
        }
    }
}

