/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.esql.action.EsqlQueryRequest;
import org.elasticsearch.xpack.esql.parser.ContentLocation;
import org.elasticsearch.xpack.esql.parser.TypedParamValue;
import org.elasticsearch.xpack.esql.plugin.QueryPragmas;

final class RequestXContent {
    private static final ConstructingObjectParser<TypedParamValue, Void> PARAM_PARSER = new ConstructingObjectParser("params", true, objects -> new TypedParamValue((String)objects[1], objects[0]));
    private static final ParseField VALUE = new ParseField("value", new String[0]);
    private static final ParseField TYPE = new ParseField("type", new String[0]);
    static final ParseField QUERY_FIELD;
    private static final ParseField COLUMNAR_FIELD;
    private static final ParseField FILTER_FIELD;
    static final ParseField PRAGMA_FIELD;
    private static final ParseField PARAMS_FIELD;
    private static final ParseField LOCALE_FIELD;
    private static final ParseField PROFILE_FIELD;
    static final ParseField WAIT_FOR_COMPLETION_TIMEOUT;
    static final ParseField KEEP_ALIVE;
    static final ParseField KEEP_ON_COMPLETION;
    private static final ObjectParser<EsqlQueryRequest, Void> SYNC_PARSER;
    private static final ObjectParser<EsqlQueryRequest, Void> ASYNC_PARSER;

    RequestXContent() {
    }

    static EsqlQueryRequest parseSync(XContentParser parser) {
        return (EsqlQueryRequest)((Object)SYNC_PARSER.apply(parser, null));
    }

    static EsqlQueryRequest parseAsync(XContentParser parser) {
        return (EsqlQueryRequest)((Object)ASYNC_PARSER.apply(parser, null));
    }

    private static void objectParserCommon(ObjectParser<EsqlQueryRequest, ?> parser) {
        parser.declareString(EsqlQueryRequest::query, QUERY_FIELD);
        parser.declareBoolean(EsqlQueryRequest::columnar, COLUMNAR_FIELD);
        parser.declareObject(EsqlQueryRequest::filter, (p, c) -> AbstractQueryBuilder.parseTopLevelQuery((XContentParser)p), FILTER_FIELD);
        parser.declareObject(EsqlQueryRequest::pragmas, (p, c) -> new QueryPragmas(Settings.builder().loadFromMap(p.map()).build()), PRAGMA_FIELD);
        parser.declareField(EsqlQueryRequest::params, RequestXContent::parseParams, PARAMS_FIELD, ObjectParser.ValueType.VALUE_ARRAY);
        parser.declareString((request, localeTag) -> request.locale(Locale.forLanguageTag(localeTag)), LOCALE_FIELD);
        parser.declareBoolean(EsqlQueryRequest::profile, PROFILE_FIELD);
    }

    private static ObjectParser<EsqlQueryRequest, Void> objectParserSync(Supplier<EsqlQueryRequest> supplier) {
        ObjectParser parser = new ObjectParser("esql/query", false, supplier);
        RequestXContent.objectParserCommon(parser);
        return parser;
    }

    private static ObjectParser<EsqlQueryRequest, Void> objectParserAsync(Supplier<EsqlQueryRequest> supplier) {
        ObjectParser parser = new ObjectParser("esql/async_query", false, supplier);
        RequestXContent.objectParserCommon(parser);
        parser.declareBoolean(EsqlQueryRequest::keepOnCompletion, KEEP_ON_COMPLETION);
        parser.declareField(EsqlQueryRequest::waitForCompletionTimeout, (p, c) -> TimeValue.parseTimeValue((String)p.text(), (String)WAIT_FOR_COMPLETION_TIMEOUT.getPreferredName()), WAIT_FOR_COMPLETION_TIMEOUT, ObjectParser.ValueType.VALUE);
        parser.declareField(EsqlQueryRequest::keepAlive, (p, c) -> TimeValue.parseTimeValue((String)p.text(), (String)KEEP_ALIVE.getPreferredName()), KEEP_ALIVE, ObjectParser.ValueType.VALUE);
        return parser;
    }

    private static List<TypedParamValue> parseParams(XContentParser p) throws IOException {
        ArrayList<TypedParamValue> result = new ArrayList<TypedParamValue>();
        XContentParser.Token token = p.currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            Object value = null;
            String type = null;
            TypedParamValue previousParam = null;
            while ((token = p.nextToken()) != XContentParser.Token.END_ARRAY) {
                TypedParamValue currentParam;
                XContentLocation loc = p.getTokenLocation();
                if (token == XContentParser.Token.START_OBJECT) {
                    currentParam = (TypedParamValue)PARAM_PARSER.apply(p, null);
                    if (previousParam != null && !previousParam.hasExplicitType() || result.isEmpty()) {
                        currentParam.tokenLocation(RequestXContent.toProto(loc));
                    }
                } else {
                    if (token == XContentParser.Token.VALUE_STRING) {
                        value = p.text();
                        type = "keyword";
                    } else if (token == XContentParser.Token.VALUE_NUMBER) {
                        XContentParser.NumberType numberType = p.numberType();
                        if (numberType == XContentParser.NumberType.INT) {
                            value = p.intValue();
                            type = "integer";
                        } else if (numberType == XContentParser.NumberType.LONG) {
                            value = p.longValue();
                            type = "long";
                        } else if (numberType == XContentParser.NumberType.DOUBLE) {
                            value = p.doubleValue();
                            type = "double";
                        }
                    } else if (token == XContentParser.Token.VALUE_BOOLEAN) {
                        value = p.booleanValue();
                        type = "boolean";
                    } else if (token == XContentParser.Token.VALUE_NULL) {
                        value = null;
                        type = "null";
                    } else {
                        throw new XContentParseException(loc, "Failed to parse object: unexpected token [" + token + "] found");
                    }
                    currentParam = new TypedParamValue(type, value, false);
                    if (previousParam != null && previousParam.hasExplicitType() || result.isEmpty()) {
                        currentParam.tokenLocation(RequestXContent.toProto(loc));
                    }
                }
                result.add(currentParam);
                previousParam = currentParam;
            }
        }
        return result;
    }

    static ContentLocation toProto(XContentLocation toProto) {
        if (toProto == null) {
            return null;
        }
        return new ContentLocation(toProto.lineNumber(), toProto.columnNumber());
    }

    static XContentLocation fromProto(ContentLocation fromProto) {
        if (fromProto == null) {
            return null;
        }
        return new XContentLocation(fromProto.lineNumber, fromProto.columnNumber);
    }

    static {
        PARAM_PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> XContentParserUtils.parseFieldsValue((XContentParser)p), VALUE, ObjectParser.ValueType.VALUE);
        PARAM_PARSER.declareString(ConstructingObjectParser.constructorArg(), TYPE);
        QUERY_FIELD = new ParseField("query", new String[0]);
        COLUMNAR_FIELD = new ParseField("columnar", new String[0]);
        FILTER_FIELD = new ParseField("filter", new String[0]);
        PRAGMA_FIELD = new ParseField("pragma", new String[0]);
        PARAMS_FIELD = new ParseField("params", new String[0]);
        LOCALE_FIELD = new ParseField("locale", new String[0]);
        PROFILE_FIELD = new ParseField("profile", new String[0]);
        WAIT_FOR_COMPLETION_TIMEOUT = new ParseField("wait_for_completion_timeout", new String[0]);
        KEEP_ALIVE = new ParseField("keep_alive", new String[0]);
        KEEP_ON_COMPLETION = new ParseField("keep_on_completion", new String[0]);
        SYNC_PARSER = RequestXContent.objectParserSync(EsqlQueryRequest::syncEsqlQueryRequest);
        ASYNC_PARSER = RequestXContent.objectParserAsync(EsqlQueryRequest::asyncEsqlQueryRequest);
    }
}

