/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.reservedstate.ReservedClusterStateHandler;
import org.elasticsearch.reservedstate.TransformState;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xpack.autoscaling.action.PutAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.action.TransportDeleteAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.action.TransportPutAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingCalculateCapacityService;

public class ReservedAutoscalingPolicyAction
implements ReservedClusterStateHandler<List<PutAutoscalingPolicyAction.Request>> {
    public static final String NAME = "autoscaling";
    private final AutoscalingCalculateCapacityService.Holder policyValidatorHolder;

    public ReservedAutoscalingPolicyAction(AutoscalingCalculateCapacityService.Holder policyValidatorHolder) {
        this.policyValidatorHolder = policyValidatorHolder;
    }

    public String name() {
        return NAME;
    }

    private Collection<PutAutoscalingPolicyAction.Request> prepare(List<PutAutoscalingPolicyAction.Request> policies) {
        for (PutAutoscalingPolicyAction.Request policy : policies) {
            this.validate((MasterNodeRequest)policy);
        }
        return policies;
    }

    public TransformState transform(Object source, TransformState prevState) throws Exception {
        Collection<PutAutoscalingPolicyAction.Request> requests = this.prepare((List)source);
        ClusterState state = prevState.state();
        for (PutAutoscalingPolicyAction.Request request : requests) {
            state = TransportPutAutoscalingPolicyAction.putAutoscalingPolicy(state, request, this.policyValidatorHolder.get());
        }
        Set entities = requests.stream().map(r -> r.name()).collect(Collectors.toSet());
        HashSet toDelete = new HashSet(prevState.keys());
        toDelete.removeAll(entities);
        for (String repositoryToDelete : toDelete) {
            state = TransportDeleteAutoscalingPolicyAction.deleteAutoscalingPolicy(state, repositoryToDelete);
        }
        return new TransformState(state, entities);
    }

    public List<PutAutoscalingPolicyAction.Request> fromXContent(XContentParser parser) throws IOException {
        ArrayList<PutAutoscalingPolicyAction.Request> result = new ArrayList<PutAutoscalingPolicyAction.Request>();
        Map source = parser.map();
        for (String name : source.keySet()) {
            Map content = (Map)source.get(name);
            XContentParser policyParser = XContentHelper.mapToXContentParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (Map)content);
            try {
                result.add(PutAutoscalingPolicyAction.Request.parse(policyParser, name));
            }
            finally {
                if (policyParser == null) continue;
                policyParser.close();
            }
        }
        return result;
    }
}

