/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.autoscaling.policy.AutoscalingPolicy;

public class GetAutoscalingPolicyAction
extends ActionType<Response> {
    public static final GetAutoscalingPolicyAction INSTANCE = new GetAutoscalingPolicyAction();
    public static final String NAME = "cluster:admin/autoscaling/get_autoscaling_policy";

    private GetAutoscalingPolicyAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final AutoscalingPolicy policy;

        public AutoscalingPolicy policy() {
            return this.policy;
        }

        public Response(AutoscalingPolicy policy) {
            this.policy = Objects.requireNonNull(policy);
        }

        public Response(StreamInput in) throws IOException {
            this.policy = new AutoscalingPolicy(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.policy.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.policy.toXContent(builder, params);
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return this.policy.equals(response.policy);
        }

        public int hashCode() {
            return Objects.hash(this.policy);
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request> {
        private final String name;

        public String name() {
            return this.name;
        }

        public Request(String name) {
            this.name = Objects.requireNonNull(name);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.name = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.name);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return this.name.equals(request.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }
}

