/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.utils;

import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;

public final class LicenseUtils {
    public static final LicensedFeature.Momentary LICENSED_ENT_SEARCH_FEATURE = LicensedFeature.momentary(null, (String)"enterprise_search", (License.OperationMode)License.OperationMode.PLATINUM);

    public static boolean supportedLicense(XPackLicenseState licenseState) {
        return LICENSED_ENT_SEARCH_FEATURE.check(licenseState);
    }

    public static ElasticsearchSecurityException newComplianceException(XPackLicenseState licenseState, Product product) {
        String licenseStatus = licenseState.statusDescription();
        ElasticsearchSecurityException e = new ElasticsearchSecurityException("Current license is non-compliant for " + product.getName() + ". Current license is {}. This feature requires an active trial, platinum or enterprise license.", RestStatus.FORBIDDEN, new Object[]{licenseStatus});
        return e;
    }

    public static enum Product {
        SEARCH_APPLICATION("search application"),
        BEHAVIORAL_ANALYTICS("behavioral analytics"),
        QUERY_RULES("query rules");

        private final String name;

        private Product(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

