/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.rules.AppliedQueryRules;
import org.elasticsearch.xpack.application.rules.QueryRuleCriteria;
import org.elasticsearch.xpack.application.rules.QueryRuleCriteriaType;
import org.elasticsearch.xpack.searchbusinessrules.PinnedQueryBuilder;

public class QueryRule
implements Writeable,
ToXContentObject {
    private final String id;
    private final QueryRuleType type;
    private final List<QueryRuleCriteria> criteria;
    private final Map<String, Object> actions;
    private static final ConstructingObjectParser<QueryRule, String> PARSER = new ConstructingObjectParser("query_rule", false, (params, resourceName) -> {
        String id = (String)params[0];
        QueryRuleType type = QueryRuleType.queryRuleType((String)params[1]);
        List criteria = (List)params[2];
        Map actions = (Map)params[3];
        return new QueryRule(id, type, criteria, actions);
    });
    public static final ParseField ID_FIELD = new ParseField("rule_id", new String[0]);
    public static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    public static final ParseField CRITERIA_FIELD = new ParseField("criteria", new String[0]);
    public static final ParseField ACTIONS_FIELD = new ParseField("actions", new String[0]);

    public QueryRule(String id, QueryRuleType type, List<QueryRuleCriteria> criteria, Map<String, Object> actions) {
        if (Strings.isNullOrEmpty((String)id)) {
            throw new IllegalArgumentException("Query rule id cannot be null or blank");
        }
        this.id = id;
        Objects.requireNonNull(type, "Query rule type cannot be null");
        this.type = type;
        Objects.requireNonNull(criteria, "Query rule criteria cannot be null");
        if (criteria.isEmpty()) {
            throw new IllegalArgumentException("Query rule criteria cannot be empty");
        }
        this.criteria = criteria;
        Objects.requireNonNull(actions, "Query rule actions cannot be null");
        if (actions.isEmpty()) {
            throw new IllegalArgumentException("Query rule actions cannot be empty");
        }
        this.actions = actions;
        this.validate();
    }

    public QueryRule(StreamInput in) throws IOException {
        this.id = in.readString();
        this.type = QueryRuleType.queryRuleType(in.readString());
        this.criteria = in.readCollectionAsList(QueryRuleCriteria::new);
        this.actions = in.readGenericMap();
        this.validate();
    }

    private void validate() {
        if (this.type == QueryRuleType.PINNED) {
            boolean ruleContainsPinnedDocs;
            boolean ruleContainsPinnedIds = this.actions.containsKey(PinnedQueryBuilder.IDS_FIELD.getPreferredName());
            if (!(ruleContainsPinnedIds ^ (ruleContainsPinnedDocs = this.actions.containsKey(PinnedQueryBuilder.DOCS_FIELD.getPreferredName())))) {
                throw new ElasticsearchParseException("pinned query rule actions must contain only one of either ids or docs", new Object[0]);
            }
        } else {
            throw new IllegalArgumentException("Unsupported QueryRuleType: " + this.type);
        }
        this.validatePinnedAction(this.actions.get(PinnedQueryBuilder.IDS_FIELD.getPreferredName()));
        this.validatePinnedAction(this.actions.get(PinnedQueryBuilder.DOCS_FIELD.getPreferredName()));
    }

    private void validatePinnedAction(Object action) {
        if (action != null) {
            if (!(action instanceof List)) {
                throw new ElasticsearchParseException("pinned query rule actions must be a list", new Object[0]);
            }
            if (((List)action).isEmpty()) {
                throw new ElasticsearchParseException("pinned query rule actions cannot be empty", new Object[0]);
            }
            if (((List)action).size() > 100) {
                throw new ElasticsearchParseException("pinned hits cannot exceed 100", new Object[0]);
            }
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeString(this.type.toString());
        out.writeCollection(this.criteria);
        out.writeGenericMap(this.actions);
    }

    public static QueryRule fromXContentBytes(BytesReference source, XContentType xContentType) {
        QueryRule queryRule;
        block8: {
            XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)xContentType);
            try {
                queryRule = QueryRule.fromXContent(parser);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse: " + source.utf8ToString(), (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return queryRule;
    }

    public static QueryRule fromXContent(XContentParser parser) {
        return (QueryRule)PARSER.apply(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID_FIELD.getPreferredName(), this.id);
        builder.field(TYPE_FIELD.getPreferredName(), (Enum)this.type);
        builder.xContentList(CRITERIA_FIELD.getPreferredName(), this.criteria);
        builder.field(ACTIONS_FIELD.getPreferredName());
        builder.map(this.actions);
        builder.endObject();
        return builder;
    }

    public String id() {
        return this.id;
    }

    public QueryRuleType type() {
        return this.type;
    }

    public List<QueryRuleCriteria> criteria() {
        return this.criteria;
    }

    public Map<String, Object> actions() {
        return this.actions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryRule queryRule = (QueryRule)o;
        return Objects.equals(this.id, queryRule.id) && this.type == queryRule.type && Objects.equals(this.criteria, queryRule.criteria) && Objects.equals(this.actions, queryRule.actions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.criteria, this.actions});
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public AppliedQueryRules applyRule(AppliedQueryRules appliedRules, Map<String, Object> matchCriteria) {
        if (this.type != QueryRuleType.PINNED) {
            throw new UnsupportedOperationException("Only pinned query rules are supported");
        }
        ArrayList matchingPinnedIds = new ArrayList();
        ArrayList<PinnedQueryBuilder.Item> matchingPinnedDocs = new ArrayList<PinnedQueryBuilder.Item>();
        Boolean isRuleMatch = null;
        for (QueryRuleCriteria criterion : this.criteria) {
            for (String match : matchCriteria.keySet()) {
                Object matchValue = matchCriteria.get(match);
                QueryRuleCriteriaType criteriaType = criterion.criteriaType();
                String criteriaMetadata = criterion.criteriaMetadata();
                if (criteriaType != QueryRuleCriteriaType.ALWAYS && (criteriaMetadata == null || !criteriaMetadata.equals(match))) continue;
                boolean singleCriterionMatches = criterion.isMatch(matchValue, criteriaType, false);
                isRuleMatch = isRuleMatch == null ? singleCriterionMatches : isRuleMatch != false && singleCriterionMatches;
            }
        }
        if (isRuleMatch != null && isRuleMatch.booleanValue()) {
            if (this.actions.containsKey(PinnedQueryBuilder.IDS_FIELD.getPreferredName())) {
                matchingPinnedIds.addAll((List)this.actions.get(PinnedQueryBuilder.IDS_FIELD.getPreferredName()));
            } else if (this.actions.containsKey(PinnedQueryBuilder.DOCS_FIELD.getPreferredName())) {
                List docsToPin = (List)this.actions.get(PinnedQueryBuilder.DOCS_FIELD.getPreferredName());
                List<PinnedQueryBuilder.Item> items = docsToPin.stream().map(map -> new PinnedQueryBuilder.Item((String)map.get(PinnedQueryBuilder.Item.INDEX_FIELD.getPreferredName()), (String)map.get(PinnedQueryBuilder.Item.ID_FIELD.getPreferredName()))).toList();
                matchingPinnedDocs.addAll(items);
            }
        }
        List<String> pinnedIds = appliedRules.pinnedIds();
        List<PinnedQueryBuilder.Item> pinnedDocs = appliedRules.pinnedDocs();
        pinnedIds.addAll(matchingPinnedIds);
        pinnedDocs.addAll(matchingPinnedDocs);
        return new AppliedQueryRules(pinnedIds, pinnedDocs);
    }

    static {
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), ID_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TYPE_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> QueryRuleCriteria.fromXContent(p), CRITERIA_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), ACTIONS_FIELD);
    }

    public static enum QueryRuleType {
        PINNED;


        public static QueryRuleType queryRuleType(String type) {
            for (QueryRuleType queryRuleType : QueryRuleType.values()) {
                if (!queryRuleType.name().equalsIgnoreCase(type)) continue;
                return queryRuleType;
            }
            throw new IllegalArgumentException("Unknown QueryRuleType: " + type);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

