/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.syncjob.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.connector.Connector;
import org.elasticsearch.xpack.application.connector.syncjob.ConnectorSyncJob;
import org.elasticsearch.xpack.application.connector.syncjob.ConnectorSyncJobTriggerMethod;
import org.elasticsearch.xpack.application.connector.syncjob.ConnectorSyncJobType;
import org.elasticsearch.xpack.application.connector.syncjob.action.ConnectorSyncJobActionRequest;

public class PostConnectorSyncJobAction {
    public static final String NAME = "indices:data/write/xpack/connector/sync_job/post";
    public static final ActionType<Response> INSTANCE = new ActionType("indices:data/write/xpack/connector/sync_job/post");

    private PostConnectorSyncJobAction() {
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final String id;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.id = in.readString();
        }

        public Response(String id) {
            this.id = id;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.id);
        }

        public String getId() {
            return this.id;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(ConnectorSyncJob.ID_FIELD.getPreferredName(), this.id);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.id, response.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }

    public static class Request
    extends ConnectorSyncJobActionRequest
    implements ToXContentObject {
        public static final String EMPTY_CONNECTOR_ID_ERROR_MESSAGE = "[id] of the connector cannot be null or empty";
        private final String id;
        private final ConnectorSyncJobType jobType;
        private final ConnectorSyncJobTriggerMethod triggerMethod;
        private static final ConstructingObjectParser<Request, Void> PARSER = new ConstructingObjectParser("connector_sync_job_post_request", false, args -> {
            String connectorId = (String)args[0];
            String syncJobTypeString = (String)args[1];
            String triggerMethodString = (String)args[2];
            boolean syncJobTypeSpecified = syncJobTypeString != null;
            boolean triggerMethodSpecified = triggerMethodString != null;
            return new Request(connectorId, syncJobTypeSpecified ? ConnectorSyncJobType.fromString(syncJobTypeString) : null, triggerMethodSpecified ? ConnectorSyncJobTriggerMethod.fromString(triggerMethodString) : null);
        });

        public Request(String id, ConnectorSyncJobType jobType, ConnectorSyncJobTriggerMethod triggerMethod) {
            this.id = id;
            this.jobType = jobType;
            this.triggerMethod = triggerMethod;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.id = in.readString();
            this.jobType = (ConnectorSyncJobType)in.readOptionalEnum(ConnectorSyncJobType.class);
            this.triggerMethod = (ConnectorSyncJobTriggerMethod)in.readOptionalEnum(ConnectorSyncJobTriggerMethod.class);
        }

        public String getId() {
            return this.id;
        }

        public ConnectorSyncJobType getJobType() {
            return this.jobType;
        }

        public ConnectorSyncJobTriggerMethod getTriggerMethod() {
            return this.triggerMethod;
        }

        public static Request fromXContentBytes(BytesReference source, XContentType xContentType) {
            Request request;
            block8: {
                XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)xContentType);
                try {
                    request = Request.fromXContent(parser);
                    if (parser == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new ElasticsearchParseException("Failed to parse: " + source.utf8ToString(), (Throwable)e, new Object[0]);
                    }
                }
                parser.close();
            }
            return request;
        }

        public static Request fromXContent(XContentParser parser) throws IOException {
            return (Request)((Object)PARSER.parse(parser, null));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Connector.ID_FIELD.getPreferredName(), this.id);
            builder.field(ConnectorSyncJob.JOB_TYPE_FIELD.getPreferredName(), (Enum)this.jobType);
            builder.field(ConnectorSyncJob.TRIGGER_METHOD_FIELD.getPreferredName(), (Enum)this.triggerMethod);
            builder.endObject();
            return builder;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.getId())) {
                validationException = ValidateActions.addValidationError((String)EMPTY_CONNECTOR_ID_ERROR_MESSAGE, validationException);
            }
            return validationException;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.id);
            out.writeOptionalEnum((Enum)this.jobType);
            out.writeOptionalEnum((Enum)this.triggerMethod);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.id, request.id) && this.jobType == request.jobType && this.triggerMethod == request.triggerMethod;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.id, this.jobType, this.triggerMethod});
        }

        @Override
        public String[] indices() {
            return new String[]{".elastic-connectors-sync-jobs-v1", ".elastic-connectors-v1"};
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), ConnectorSyncJob.ID_FIELD);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), ConnectorSyncJob.JOB_TYPE_FIELD);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), ConnectorSyncJob.TRIGGER_METHOD_FIELD);
        }
    }
}

