/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.syncjob;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.xpack.application.connector.ConnectorSyncStatus;
import org.elasticsearch.xpack.application.connector.syncjob.ConnectorSyncJobInvalidStatusTransitionException;

public class ConnectorSyncJobStateMachine {
    private static final Map<ConnectorSyncStatus, Set<ConnectorSyncStatus>> VALID_TRANSITIONS = Map.of(ConnectorSyncStatus.PENDING, EnumSet.of(ConnectorSyncStatus.IN_PROGRESS, ConnectorSyncStatus.CANCELED), ConnectorSyncStatus.IN_PROGRESS, EnumSet.of(ConnectorSyncStatus.CANCELING, ConnectorSyncStatus.COMPLETED, ConnectorSyncStatus.SUSPENDED, ConnectorSyncStatus.ERROR), ConnectorSyncStatus.COMPLETED, Collections.emptySet(), ConnectorSyncStatus.SUSPENDED, EnumSet.of(ConnectorSyncStatus.IN_PROGRESS, ConnectorSyncStatus.CANCELED), ConnectorSyncStatus.CANCELING, EnumSet.of(ConnectorSyncStatus.CANCELED, ConnectorSyncStatus.ERROR), ConnectorSyncStatus.CANCELED, Collections.emptySet(), ConnectorSyncStatus.ERROR, Collections.emptySet());

    public static boolean isValidTransition(ConnectorSyncStatus current, ConnectorSyncStatus next) {
        return VALID_TRANSITIONS.getOrDefault((Object)current, Collections.emptySet()).contains((Object)next);
    }

    public static void assertValidStateTransition(ConnectorSyncStatus current, ConnectorSyncStatus next) throws ConnectorSyncJobInvalidStatusTransitionException {
        if (ConnectorSyncJobStateMachine.isValidTransition(current, next)) {
            return;
        }
        throw new ConnectorSyncJobInvalidStatusTransitionException(current, next);
    }
}

