/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.connector.Connector;
import org.elasticsearch.xpack.application.connector.ConnectorStatus;
import org.elasticsearch.xpack.application.connector.action.ConnectorActionRequest;
import org.elasticsearch.xpack.application.connector.action.ConnectorUpdateActionResponse;

public class UpdateConnectorStatusAction {
    public static final String NAME = "indices:data/write/xpack/connector/update_status";
    public static final ActionType<ConnectorUpdateActionResponse> INSTANCE = new ActionType("indices:data/write/xpack/connector/update_status");

    public static class Request
    extends ConnectorActionRequest
    implements ToXContentObject {
        private final String connectorId;
        private final ConnectorStatus status;
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("connector_update_status_request", false, (args, connectorId) -> new Request((String)connectorId, (ConnectorStatus)((Object)((Object)args[0]))));

        public Request(String connectorId, ConnectorStatus status) {
            this.connectorId = connectorId;
            this.status = status;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.connectorId = in.readString();
            this.status = (ConnectorStatus)in.readEnum(ConnectorStatus.class);
        }

        public String getConnectorId() {
            return this.connectorId;
        }

        public ConnectorStatus getStatus() {
            return this.status;
        }

        public static Request fromXContentBytes(String connectorId, BytesReference source, XContentType xContentType) {
            Request request;
            block8: {
                XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)xContentType);
                try {
                    request = Request.fromXContent(parser, connectorId);
                    if (parser == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new ElasticsearchParseException("Failed to parse: " + source.utf8ToString(), (Throwable)e, new Object[0]);
                    }
                }
                parser.close();
            }
            return request;
        }

        public static Request fromXContent(XContentParser parser, String connectorId) throws IOException {
            return (Request)((Object)PARSER.parse(parser, (Object)connectorId));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Connector.STATUS_FIELD.getPreferredName(), (Enum)this.status);
            builder.endObject();
            return builder;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.connectorId)) {
                validationException = ValidateActions.addValidationError((String)"[connector_id] cannot be [null] or [\"\"].", validationException);
            }
            if (this.status == null) {
                validationException = ValidateActions.addValidationError((String)"[status] cannot be [null].", (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.connectorId);
            out.writeEnum((Enum)this.status);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.connectorId, request.connectorId) && this.status == request.status;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.connectorId, this.status});
        }

        static {
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ConnectorStatus.connectorStatus(p.text()), Connector.STATUS_FIELD, ObjectParser.ValueType.STRING);
        }
    }
}

