/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.connector.Connector;
import org.elasticsearch.xpack.application.connector.action.ConnectorActionRequest;

public class PostConnectorAction {
    public static final String NAME = "indices:data/write/xpack/connector/post";
    public static final ActionType<Response> INSTANCE = new ActionType("indices:data/write/xpack/connector/post");

    private PostConnectorAction() {
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final String id;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.id = in.readString();
        }

        public Response(String id) {
            this.id = id;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.id);
        }

        public String getId() {
            return this.id;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Connector.ID_FIELD.getPreferredName(), this.id);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.id, response.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }

    public static class Request
    extends ConnectorActionRequest
    implements ToXContentObject {
        @Nullable
        private final String description;
        @Nullable
        private final String indexName;
        @Nullable
        private final Boolean isNative;
        @Nullable
        private final String language;
        @Nullable
        private final String name;
        @Nullable
        private final String serviceType;
        private static final ConstructingObjectParser<Request, Void> PARSER = new ConstructingObjectParser("connector_put_request", false, args -> new Request((String)args[0], (String)args[1], (Boolean)args[2], (String)args[3], (String)args[4], (String)args[5]));

        public Request(String description, String indexName, Boolean isNative, String language, String name, String serviceType) {
            this.description = description;
            this.indexName = indexName;
            this.isNative = isNative;
            this.language = language;
            this.name = name;
            this.serviceType = serviceType;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.description = in.readOptionalString();
            this.indexName = in.readOptionalString();
            this.isNative = in.readOptionalBoolean();
            this.language = in.readOptionalString();
            this.name = in.readOptionalString();
            this.serviceType = in.readOptionalString();
        }

        public static Request fromXContentBytes(BytesReference source, XContentType xContentType) {
            Request request;
            block8: {
                XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)xContentType);
                try {
                    request = Request.fromXContent(parser);
                    if (parser == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new ElasticsearchParseException("Failed to parse: " + source.utf8ToString(), (Throwable)e, new Object[0]);
                    }
                }
                parser.close();
            }
            return request;
        }

        public static Request fromXContent(XContentParser parser) throws IOException {
            return (Request)((Object)PARSER.parse(parser, null));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.description != null) {
                builder.field("description", this.description);
            }
            if (this.indexName != null) {
                builder.field("index_name", this.indexName);
            }
            if (this.isNative != null) {
                builder.field("is_native", this.isNative);
            }
            if (this.language != null) {
                builder.field("language", this.language);
            }
            if (this.name != null) {
                builder.field("name", this.name);
            }
            if (this.serviceType != null) {
                builder.field("service_type", this.serviceType);
            }
            builder.endObject();
            return builder;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            validationException = this.validateIndexName(this.indexName, validationException);
            return validationException;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.description);
            out.writeOptionalString(this.indexName);
            out.writeOptionalBoolean(this.isNative);
            out.writeOptionalString(this.language);
            out.writeOptionalString(this.name);
            out.writeOptionalString(this.serviceType);
        }

        public String getDescription() {
            return this.description;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public Boolean getIsNative() {
            return this.isNative;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getName() {
            return this.name;
        }

        public String getServiceType() {
            return this.serviceType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.description, request.description) && Objects.equals(this.indexName, request.indexName) && Objects.equals(this.isNative, request.isNative) && Objects.equals(this.language, request.language) && Objects.equals(this.name, request.name) && Objects.equals(this.serviceType, request.serviceType);
        }

        public int hashCode() {
            return Objects.hash(this.description, this.indexName, this.isNative, this.language, this.name, this.serviceType);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("description", new String[0]));
            PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField("index_name", new String[0]));
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField("is_native", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("language", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("name", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("service_type", new String[0]));
        }
    }
}

