/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.lifecycle.action;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public final class UpdateDataStreamGlobalRetentionResponse
extends ActionResponse
implements ChunkedToXContentObject {
    public static final UpdateDataStreamGlobalRetentionResponse FAILED = new UpdateDataStreamGlobalRetentionResponse(false, false, List.of());
    private final boolean acknowledged;
    private final boolean dryRun;
    private final List<AffectedDataStream> affectedDataStreams;

    public UpdateDataStreamGlobalRetentionResponse(StreamInput in) throws IOException {
        super(in);
        this.acknowledged = in.readBoolean();
        this.dryRun = in.readBoolean();
        this.affectedDataStreams = in.readCollectionAsImmutableList(AffectedDataStream::read);
    }

    public UpdateDataStreamGlobalRetentionResponse(boolean acknowledged, List<AffectedDataStream> affectedDataStreams) {
        this(acknowledged, false, affectedDataStreams);
    }

    public UpdateDataStreamGlobalRetentionResponse(boolean acknowledged, boolean dryRun, List<AffectedDataStream> affectedDataStreams) {
        this.acknowledged = acknowledged;
        this.dryRun = dryRun;
        this.affectedDataStreams = affectedDataStreams;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.acknowledged);
        out.writeBoolean(this.dryRun);
        out.writeCollection(this.affectedDataStreams);
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat((Iterator[])new Iterator[]{ChunkedToXContentHelper.startObject(), Iterators.single((builder, params1) -> {
            builder.field("acknowledged", this.acknowledged);
            builder.field("dry_run", this.dryRun);
            return builder;
        }), ChunkedToXContentHelper.startArray((String)"affected_data_streams"), Iterators.map(this.affectedDataStreams.iterator(), affectedDataStream -> affectedDataStream::toXContent), ChunkedToXContentHelper.endArray(), ChunkedToXContentHelper.endObject()});
    }

    public boolean isAcknowledged() {
        return this.acknowledged;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public List<AffectedDataStream> getAffectedDataStreams() {
        return this.affectedDataStreams;
    }

    public record AffectedDataStream(String dataStreamName, TimeValue newEffectiveRetention, TimeValue previousEffectiveRetention) implements Writeable,
    ToXContentObject
    {
        public static AffectedDataStream read(StreamInput in) throws IOException {
            return new AffectedDataStream(in.readString(), in.readOptionalTimeValue(), in.readOptionalTimeValue());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.dataStreamName);
            out.writeOptionalTimeValue(this.newEffectiveRetention);
            out.writeOptionalTimeValue(this.previousEffectiveRetention);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("name", this.dataStreamName);
            builder.field("new_effective_retention", this.newEffectiveRetention == null ? "infinite" : this.newEffectiveRetention.getStringRep());
            builder.field("previous_effective_retention", this.previousEffectiveRetention == null ? "infinite" : this.previousEffectiveRetention.getStringRep());
            builder.endObject();
            return builder;
        }
    }
}

