/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.RemoteClusterActionType;
import org.elasticsearch.client.internal.RemoteClusterClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.transport.NoSuchRemoteClusterException;
import org.elasticsearch.transport.RemoteClusterAwareRequest;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

final class RemoteClusterAwareClient
implements RemoteClusterClient {
    private final TransportService service;
    private final String clusterAlias;
    private final RemoteClusterService remoteClusterService;
    private final Executor responseExecutor;
    private final boolean ensureConnected;

    RemoteClusterAwareClient(TransportService service, String clusterAlias, Executor responseExecutor, boolean ensureConnected) {
        this.service = service;
        this.clusterAlias = clusterAlias;
        this.remoteClusterService = service.getRemoteClusterService();
        this.responseExecutor = responseExecutor;
        this.ensureConnected = ensureConnected;
    }

    @Override
    public <Request extends ActionRequest, Response extends TransportResponse> void execute(RemoteClusterActionType<Response> action, Request request, ActionListener<Response> listener) {
        this.maybeEnsureConnected(listener.delegateFailureAndWrap((delegateListener, v) -> {
            Transport.Connection connection;
            try {
                if (request instanceof RemoteClusterAwareRequest) {
                    DiscoveryNode preferredTargetNode = ((RemoteClusterAwareRequest)((Object)request)).getPreferredTargetNode();
                    connection = this.remoteClusterService.getConnection(preferredTargetNode, this.clusterAlias);
                } else {
                    connection = this.remoteClusterService.getConnection(this.clusterAlias);
                }
            }
            catch (NoSuchRemoteClusterException e) {
                if (!this.ensureConnected) {
                    this.remoteClusterService.ensureConnected(this.clusterAlias, ActionListener.noop());
                }
                throw e;
            }
            this.service.sendRequest(connection, action.name(), (TransportRequest)request, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler(delegateListener, action.getResponseReader(), this.responseExecutor));
        }));
    }

    private void maybeEnsureConnected(ActionListener<Void> ensureConnectedListener) {
        if (this.ensureConnected) {
            ActionListener.run(ensureConnectedListener, l -> this.remoteClusterService.ensureConnected(this.clusterAlias, (ActionListener<Void>)l));
        } else {
            ensureConnectedListener.onResponse(null);
        }
    }
}

