/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile.aggregation;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorable;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.profile.Timer;
import org.elasticsearch.search.profile.aggregation.AggregationProfileBreakdown;
import org.elasticsearch.search.profile.aggregation.AggregationTimingType;

public class ProfilingLeafBucketCollector
extends LeafBucketCollector {
    private LeafBucketCollector delegate;
    private Timer collectTimer;

    public ProfilingLeafBucketCollector(LeafBucketCollector delegate, AggregationProfileBreakdown profileBreakdown) {
        this.delegate = delegate;
        this.collectTimer = profileBreakdown.getNewTimer(AggregationTimingType.COLLECT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collect(int doc, long bucket) throws IOException {
        this.collectTimer.start();
        try {
            this.delegate.collect(doc, bucket);
        }
        finally {
            this.collectTimer.stop();
        }
    }

    public DocIdSetIterator competitiveIterator() throws IOException {
        return this.delegate.competitiveIterator();
    }

    @Override
    public void setScorer(Scorable scorer) throws IOException {
        this.delegate.setScorer(scorer);
    }

    @Override
    public boolean isNoop() {
        return this.delegate.isNoop();
    }
}

