/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.search.profile.Timer;

public abstract class AbstractProfileBreakdown<T extends Enum<T>> {
    private final Map<T, Collection<Timer>> timings;

    public AbstractProfileBreakdown(Class<T> clazz) {
        Enum[] enumConstants = (Enum[])clazz.getEnumConstants();
        this.timings = new HashMap<T, Collection<Timer>>(enumConstants.length, 1.0f);
        for (int i = 0; i < enumConstants.length; ++i) {
            Collection listOfTimers = Collections.synchronizedCollection(new ArrayList());
            this.timings.put(enumConstants[i], listOfTimers);
        }
    }

    public final Timer getNewTimer(T timingType) {
        Timer timer = new Timer();
        this.timings.get(timingType).add(timer);
        return timer;
    }

    public final Map<String, Long> toBreakdownMap() {
        Map map = Maps.newMapWithExpectedSize(this.timings.keySet().size() * 2);
        this.timings.forEach((timingType, timers) -> {
            map.put(timingType.toString(), timers.stream().map(Timer::getApproximateTiming).mapToLong(Long::valueOf).sum());
            map.put(timingType + "_count", timers.stream().map(Timer::getCount).mapToLong(Long::valueOf).sum());
        });
        return Collections.unmodifiableMap(map);
    }

    protected Map<String, Object> toDebugMap() {
        return Collections.emptyMap();
    }

    public final long toNodeTime() {
        long total = 0L;
        for (Collection<Timer> timings : this.timings.values()) {
            total += timings.stream().map(Timer::getApproximateTiming).mapToLong(Long::valueOf).sum();
        }
        return total;
    }
}

