/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceProvider;

class SyntheticSourceProvider
implements SourceProvider {
    private final SourceLoader sourceLoader;
    private volatile SyntheticSourceLeafLoader[] leafLoaders;

    SyntheticSourceProvider(Mapping mapping) {
        this.sourceLoader = new SourceLoader.Synthetic(mapping);
    }

    @Override
    public Source getSource(LeafReaderContext ctx, int doc) throws IOException {
        this.maybeInit(ctx);
        if (this.leafLoaders[ctx.ord] == null) {
            this.leafLoaders[ctx.ord] = new SyntheticSourceLeafLoader(ctx);
        }
        return this.leafLoaders[ctx.ord].getSource(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeInit(LeafReaderContext ctx) {
        if (this.leafLoaders == null) {
            SyntheticSourceProvider syntheticSourceProvider = this;
            synchronized (syntheticSourceProvider) {
                if (this.leafLoaders == null) {
                    this.leafLoaders = new SyntheticSourceLeafLoader[this.findParentContext(ctx).leaves().size()];
                }
            }
        }
    }

    private IndexReaderContext findParentContext(LeafReaderContext ctx) {
        if (ctx.parent != null) {
            return ctx.parent;
        }
        assert (ctx.isTopLevel);
        return ctx;
    }

    private class SyntheticSourceLeafLoader {
        private final LeafStoredFieldLoader leafLoader;
        private final SourceLoader.Leaf leaf;

        SyntheticSourceLeafLoader(LeafReaderContext ctx) throws IOException {
            this.leafLoader = SyntheticSourceProvider.this.sourceLoader.requiredStoredFields().isEmpty() ? StoredFieldLoader.empty().getLoader(ctx, null) : StoredFieldLoader.create(false, SyntheticSourceProvider.this.sourceLoader.requiredStoredFields()).getLoader(ctx, null);
            this.leaf = SyntheticSourceProvider.this.sourceLoader.leaf(ctx.reader(), null);
        }

        Source getSource(int doc) throws IOException {
            this.leafLoader.advanceTo(doc);
            return this.leaf.source(this.leafLoader, doc);
        }
    }
}

