/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.ChunkedInferenceServiceResults;
import org.elasticsearch.inference.ChunkingOptions;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.TaskType;

public interface InferenceService
extends Closeable {
    default public void init(Client client) {
    }

    public String name();

    public void parseRequestConfig(String var1, TaskType var2, Map<String, Object> var3, Set<String> var4, ActionListener<Model> var5);

    public Model parsePersistedConfigWithSecrets(String var1, TaskType var2, Map<String, Object> var3, Map<String, Object> var4);

    public Model parsePersistedConfig(String var1, TaskType var2, Map<String, Object> var3);

    public void infer(Model var1, @Nullable String var2, List<String> var3, Map<String, Object> var4, InputType var5, TimeValue var6, ActionListener<InferenceServiceResults> var7);

    public void chunkedInfer(Model var1, @Nullable String var2, List<String> var3, Map<String, Object> var4, InputType var5, ChunkingOptions var6, TimeValue var7, ActionListener<List<ChunkedInferenceServiceResults>> var8);

    public void start(Model var1, ActionListener<Boolean> var2);

    default public void stop(String modelId, ActionListener<Boolean> listener) {
        listener.onResponse(true);
    }

    default public void putModel(Model modelVariant, ActionListener<Boolean> listener) {
        listener.onResponse(true);
    }

    default public void isModelDownloaded(Model model, ActionListener<Boolean> listener) {
        listener.onResponse(false);
    }

    default public void checkModelConfig(Model model, ActionListener<Model> listener) {
        listener.onResponse(model);
    }

    default public boolean isInClusterService() {
        return false;
    }

    public TransportVersion getMinimalSupportedVersion();
}

