/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.vectors;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.fielddata.LeafFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.vectors.BinaryDenseVectorDocValuesField;
import org.elasticsearch.script.field.vectors.ByteBinaryDenseVectorDocValuesField;
import org.elasticsearch.script.field.vectors.ByteKnnDenseVectorDocValuesField;
import org.elasticsearch.script.field.vectors.KnnDenseVectorDocValuesField;

final class VectorDVLeafFieldData
implements LeafFieldData {
    private final LeafReader reader;
    private final String field;
    private final IndexVersion indexVersion;
    private final DenseVectorFieldMapper.ElementType elementType;
    private final int dims;
    private final boolean indexed;

    VectorDVLeafFieldData(LeafReader reader, String field, IndexVersion indexVersion, DenseVectorFieldMapper.ElementType elementType, int dims, boolean indexed) {
        this.reader = reader;
        this.field = field;
        this.indexVersion = indexVersion;
        this.elementType = elementType;
        this.dims = dims;
        this.indexed = indexed;
    }

    public long ramBytesUsed() {
        return 0L;
    }

    @Override
    public SortedBinaryDocValues getBytesValues() {
        throw new UnsupportedOperationException("String representation of doc values for vector fields is not supported");
    }

    @Override
    public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
        try {
            if (this.indexed) {
                return switch (this.elementType) {
                    default -> throw new IncompatibleClassChangeError();
                    case DenseVectorFieldMapper.ElementType.BYTE -> new ByteKnnDenseVectorDocValuesField(this.reader.getByteVectorValues(this.field), name, this.dims);
                    case DenseVectorFieldMapper.ElementType.FLOAT -> new KnnDenseVectorDocValuesField(this.reader.getFloatVectorValues(this.field), name, this.dims);
                };
            }
            BinaryDocValues values = DocValues.getBinary((LeafReader)this.reader, (String)this.field);
            return switch (this.elementType) {
                default -> throw new IncompatibleClassChangeError();
                case DenseVectorFieldMapper.ElementType.BYTE -> new ByteBinaryDenseVectorDocValuesField(values, name, this.elementType, this.dims);
                case DenseVectorFieldMapper.ElementType.FLOAT -> new BinaryDenseVectorDocValuesField(values, name, this.elementType, this.dims, this.indexVersion);
            };
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load doc values for vector field!", e);
        }
    }

    public void close() {
    }
}

