/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FlatFieldVectorsWriter;
import org.apache.lucene.codecs.FlatVectorsWriter;
import org.apache.lucene.codecs.KnnFieldVectorsWriter;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.apache.lucene.codecs.lucene99.Lucene99ScalarQuantizedVectorsFormat;
import org.apache.lucene.codecs.lucene99.Lucene99ScalarQuantizedVectorsWriter;
import org.apache.lucene.codecs.lucene99.OffHeapQuantizedByteVectorValues;
import org.apache.lucene.codecs.perfield.PerFieldKnnVectorsFormat;
import org.apache.lucene.index.DocIDMerger;
import org.apache.lucene.index.DocsWithFieldSet;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.VectorUtil;
import org.apache.lucene.util.hnsw.CloseableRandomVectorScorerSupplier;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.apache.lucene.util.quantization.QuantizedByteVectorValues;
import org.apache.lucene.util.quantization.QuantizedVectorsReader;
import org.apache.lucene.util.quantization.RandomAccessQuantizedByteVectorValues;
import org.apache.lucene.util.quantization.ScalarQuantizedRandomVectorScorerSupplier;
import org.apache.lucene.util.quantization.ScalarQuantizer;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.vec.VectorScorerFactory;
import org.elasticsearch.vec.VectorScorerSupplierAdapter;
import org.elasticsearch.vec.VectorSimilarityType;

public final class ES814ScalarQuantizedVectorsWriter
extends FlatVectorsWriter {
    static final int DIRECT_MONOTONIC_BLOCK_SHIFT = 16;
    private static final long SHALLOW_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ES814ScalarQuantizedVectorsWriter.class);
    private static final float REQUANTIZATION_LIMIT = 0.2f;
    private final SegmentWriteState segmentWriteState;
    private final List<FieldWriter> fields = new ArrayList<FieldWriter>();
    private final IndexOutput meta;
    private final IndexOutput quantizedVectorData;
    private final Float confidenceInterval;
    private final FlatVectorsWriter rawVectorDelegate;
    private boolean finished;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ES814ScalarQuantizedVectorsWriter(SegmentWriteState state, Float confidenceInterval, FlatVectorsWriter rawVectorDelegate) throws IOException {
        this.confidenceInterval = confidenceInterval;
        this.segmentWriteState = state;
        String metaFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"vemq");
        String quantizedVectorDataFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"veq");
        this.rawVectorDelegate = rawVectorDelegate;
        boolean success = false;
        try {
            this.meta = state.directory.createOutput(metaFileName, state.context);
            this.quantizedVectorData = state.directory.createOutput(quantizedVectorDataFileName, state.context);
            CodecUtil.writeIndexHeader((DataOutput)this.meta, (String)"Lucene99ScalarQuantizedVectorsFormatMeta", (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            CodecUtil.writeIndexHeader((DataOutput)this.quantizedVectorData, (String)"Lucene99ScalarQuantizedVectorsFormatData", (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            success = true;
        }
        finally {
            if (!success) {
                org.elasticsearch.core.IOUtils.closeWhileHandlingException((Closeable)((Object)this));
            }
        }
    }

    public FlatFieldVectorsWriter<?> addField(FieldInfo fieldInfo, KnnFieldVectorsWriter<?> indexWriter) throws IOException {
        if (fieldInfo.getVectorEncoding().equals((Object)VectorEncoding.FLOAT32)) {
            float confidenceInterval = this.confidenceInterval == null ? Lucene99ScalarQuantizedVectorsFormat.calculateDefaultConfidenceInterval((int)fieldInfo.getVectorDimension()) : this.confidenceInterval.floatValue();
            FieldWriter quantizedWriter = new FieldWriter(confidenceInterval, fieldInfo, this.segmentWriteState.infoStream, (KnnFieldVectorsWriter<?>)indexWriter);
            this.fields.add(quantizedWriter);
            indexWriter = quantizedWriter;
        }
        return this.rawVectorDelegate.addField(fieldInfo, indexWriter);
    }

    public void mergeOneField(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        this.rawVectorDelegate.mergeOneField(fieldInfo, mergeState);
        if (fieldInfo.getVectorEncoding().equals((Object)VectorEncoding.FLOAT32)) {
            ScalarQuantizer mergedQuantizationState = this.mergeQuantiles(fieldInfo, mergeState);
            MergedQuantizedVectorValues byteVectorValues = MergedQuantizedVectorValues.mergeQuantizedByteVectorValues(fieldInfo, mergeState, mergedQuantizationState);
            long vectorDataOffset = this.quantizedVectorData.alignFilePointer(4);
            DocsWithFieldSet docsWithField = Lucene99ScalarQuantizedVectorsWriter.writeQuantizedVectorData((IndexOutput)this.quantizedVectorData, (QuantizedByteVectorValues)byteVectorValues);
            long vectorDataLength = this.quantizedVectorData.getFilePointer() - vectorDataOffset;
            float confidenceInterval = this.confidenceInterval == null ? Lucene99ScalarQuantizedVectorsFormat.calculateDefaultConfidenceInterval((int)fieldInfo.getVectorDimension()) : this.confidenceInterval.floatValue();
            this.writeMeta(fieldInfo, this.segmentWriteState.segmentInfo.maxDoc(), vectorDataOffset, vectorDataLength, Float.valueOf(confidenceInterval), Float.valueOf(mergedQuantizationState.getLowerQuantile()), Float.valueOf(mergedQuantizationState.getUpperQuantile()), docsWithField);
        }
    }

    public CloseableRandomVectorScorerSupplier mergeOneFieldToIndex(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        if (fieldInfo.getVectorEncoding().equals((Object)VectorEncoding.FLOAT32)) {
            this.rawVectorDelegate.mergeOneField(fieldInfo, mergeState);
            ScalarQuantizer mergedQuantizationState = this.mergeQuantiles(fieldInfo, mergeState);
            return this.mergeOneFieldToIndex(this.segmentWriteState, fieldInfo, mergeState, mergedQuantizationState);
        }
        return this.rawVectorDelegate.mergeOneFieldToIndex(fieldInfo, mergeState);
    }

    public void flush(int maxDoc, Sorter.DocMap sortMap) throws IOException {
        this.rawVectorDelegate.flush(maxDoc, sortMap);
        for (FieldWriter field : this.fields) {
            field.finish();
            if (sortMap == null) {
                this.writeField(field, maxDoc);
                continue;
            }
            this.writeSortingField(field, maxDoc, sortMap);
        }
    }

    public void finish() throws IOException {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        this.finished = true;
        this.rawVectorDelegate.finish();
        if (this.meta != null) {
            this.meta.writeInt(-1);
            CodecUtil.writeFooter((IndexOutput)this.meta);
        }
        if (this.quantizedVectorData != null) {
            CodecUtil.writeFooter((IndexOutput)this.quantizedVectorData);
        }
    }

    public long ramBytesUsed() {
        long total = SHALLOW_RAM_BYTES_USED;
        for (FieldWriter field : this.fields) {
            total += field.ramBytesUsed();
        }
        return total;
    }

    private void writeField(FieldWriter fieldData, int maxDoc) throws IOException {
        long vectorDataOffset = this.quantizedVectorData.alignFilePointer(4);
        this.writeQuantizedVectors(fieldData);
        long vectorDataLength = this.quantizedVectorData.getFilePointer() - vectorDataOffset;
        this.writeMeta(fieldData.fieldInfo, maxDoc, vectorDataOffset, vectorDataLength, this.confidenceInterval, Float.valueOf(fieldData.minQuantile), Float.valueOf(fieldData.maxQuantile), fieldData.docsWithField);
    }

    private void writeMeta(FieldInfo field, int maxDoc, long vectorDataOffset, long vectorDataLength, Float confidenceInterval, Float lowerQuantile, Float upperQuantile, DocsWithFieldSet docsWithField) throws IOException {
        this.meta.writeInt(field.number);
        this.meta.writeInt(field.getVectorEncoding().ordinal());
        this.meta.writeInt(field.getVectorSimilarityFunction().ordinal());
        this.meta.writeVLong(vectorDataOffset);
        this.meta.writeVLong(vectorDataLength);
        this.meta.writeVInt(field.getVectorDimension());
        int count = docsWithField.cardinality();
        this.meta.writeInt(count);
        if (count > 0) {
            assert (Float.isFinite(lowerQuantile.floatValue()) && Float.isFinite(upperQuantile.floatValue()));
            this.meta.writeInt(Float.floatToIntBits(confidenceInterval != null ? confidenceInterval.floatValue() : Lucene99ScalarQuantizedVectorsFormat.calculateDefaultConfidenceInterval((int)field.getVectorDimension())));
            this.meta.writeInt(Float.floatToIntBits(lowerQuantile.floatValue()));
            this.meta.writeInt(Float.floatToIntBits(upperQuantile.floatValue()));
        }
        OrdToDocDISIReaderConfiguration.writeStoredMeta((int)16, (IndexOutput)this.meta, (IndexOutput)this.quantizedVectorData, (int)count, (int)maxDoc, (DocsWithFieldSet)docsWithField);
    }

    private void writeQuantizedVectors(FieldWriter fieldData) throws IOException {
        ScalarQuantizer scalarQuantizer = fieldData.createQuantizer();
        byte[] vector = new byte[fieldData.fieldInfo.getVectorDimension()];
        ByteBuffer offsetBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        float[] copy = fieldData.normalize ? new float[fieldData.fieldInfo.getVectorDimension()] : null;
        for (float[] v : fieldData.floatVectors) {
            if (fieldData.normalize) {
                System.arraycopy(v, 0, copy, 0, copy.length);
                VectorUtil.l2normalize((float[])copy);
                v = copy;
            }
            float offsetCorrection = scalarQuantizer.quantize(v, vector, fieldData.fieldInfo.getVectorSimilarityFunction());
            this.quantizedVectorData.writeBytes(vector, vector.length);
            offsetBuffer.putFloat(offsetCorrection);
            this.quantizedVectorData.writeBytes(offsetBuffer.array(), offsetBuffer.array().length);
            offsetBuffer.rewind();
        }
    }

    private void writeSortingField(FieldWriter fieldData, int maxDoc, Sorter.DocMap sortMap) throws IOException {
        int[] docIdOffsets = new int[sortMap.size()];
        int offset = 1;
        DocIdSetIterator iterator = fieldData.docsWithField.iterator();
        int docID = iterator.nextDoc();
        while (docID != Integer.MAX_VALUE) {
            int newDocID = sortMap.oldToNew(docID);
            docIdOffsets[newDocID] = offset++;
            docID = iterator.nextDoc();
        }
        DocsWithFieldSet newDocsWithField = new DocsWithFieldSet();
        int[] ordMap = new int[offset - 1];
        int ord = 0;
        int doc = 0;
        for (int docIdOffset : docIdOffsets) {
            if (docIdOffset != 0) {
                ordMap[ord] = docIdOffset - 1;
                newDocsWithField.add(doc);
                ++ord;
            }
            ++doc;
        }
        long vectorDataOffset = this.quantizedVectorData.alignFilePointer(4);
        this.writeSortedQuantizedVectors(fieldData, ordMap);
        long quantizedVectorLength = this.quantizedVectorData.getFilePointer() - vectorDataOffset;
        this.writeMeta(fieldData.fieldInfo, maxDoc, vectorDataOffset, quantizedVectorLength, this.confidenceInterval, Float.valueOf(fieldData.minQuantile), Float.valueOf(fieldData.maxQuantile), newDocsWithField);
    }

    private void writeSortedQuantizedVectors(FieldWriter fieldData, int[] ordMap) throws IOException {
        ScalarQuantizer scalarQuantizer = fieldData.createQuantizer();
        byte[] vector = new byte[fieldData.fieldInfo.getVectorDimension()];
        ByteBuffer offsetBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        float[] copy = fieldData.normalize ? new float[fieldData.fieldInfo.getVectorDimension()] : null;
        for (int ordinal : ordMap) {
            float[] v = fieldData.floatVectors.get(ordinal);
            if (fieldData.normalize) {
                System.arraycopy(v, 0, copy, 0, copy.length);
                VectorUtil.l2normalize((float[])copy);
                v = copy;
            }
            float offsetCorrection = scalarQuantizer.quantize(v, vector, fieldData.fieldInfo.getVectorSimilarityFunction());
            this.quantizedVectorData.writeBytes(vector, vector.length);
            offsetBuffer.putFloat(offsetCorrection);
            this.quantizedVectorData.writeBytes(offsetBuffer.array(), offsetBuffer.array().length);
            offsetBuffer.rewind();
        }
    }

    private ScalarQuantizer mergeQuantiles(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        assert (fieldInfo.getVectorEncoding() == VectorEncoding.FLOAT32);
        float confidenceInterval = this.confidenceInterval == null ? Lucene99ScalarQuantizedVectorsFormat.calculateDefaultConfidenceInterval((int)fieldInfo.getVectorDimension()) : this.confidenceInterval.floatValue();
        return Lucene99ScalarQuantizedVectorsWriter.mergeAndRecalculateQuantiles((MergeState)mergeState, (FieldInfo)fieldInfo, (float)confidenceInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScalarQuantizedCloseableRandomVectorScorerSupplier mergeOneFieldToIndex(SegmentWriteState segmentWriteState, FieldInfo fieldInfo, MergeState mergeState, ScalarQuantizer mergedQuantizationState) throws IOException {
        ScalarQuantizedCloseableRandomVectorScorerSupplier scalarQuantizedCloseableRandomVectorScorerSupplier;
        block5: {
            long vectorDataOffset = this.quantizedVectorData.alignFilePointer(4);
            IndexOutput tempQuantizedVectorData = segmentWriteState.directory.createTempOutput(this.quantizedVectorData.getName(), "temp", segmentWriteState.context);
            IndexInput quantizationDataInput = null;
            boolean success = false;
            try {
                Optional<VectorScorerSupplierAdapter> scorer;
                MergedQuantizedVectorValues byteVectorValues = MergedQuantizedVectorValues.mergeQuantizedByteVectorValues(fieldInfo, mergeState, mergedQuantizationState);
                DocsWithFieldSet docsWithField = Lucene99ScalarQuantizedVectorsWriter.writeQuantizedVectorData((IndexOutput)tempQuantizedVectorData, (QuantizedByteVectorValues)byteVectorValues);
                CodecUtil.writeFooter((IndexOutput)tempQuantizedVectorData);
                org.elasticsearch.core.IOUtils.close((Closeable)tempQuantizedVectorData);
                quantizationDataInput = segmentWriteState.directory.openInput(tempQuantizedVectorData.getName(), segmentWriteState.context);
                this.quantizedVectorData.copyBytes((DataInput)quantizationDataInput, quantizationDataInput.length() - (long)CodecUtil.footerLength());
                long vectorDataLength = this.quantizedVectorData.getFilePointer() - vectorDataOffset;
                CodecUtil.retrieveChecksum((IndexInput)quantizationDataInput);
                float confidenceInterval = this.confidenceInterval == null ? Lucene99ScalarQuantizedVectorsFormat.calculateDefaultConfidenceInterval((int)fieldInfo.getVectorDimension()) : this.confidenceInterval.floatValue();
                this.writeMeta(fieldInfo, segmentWriteState.segmentInfo.maxDoc(), vectorDataOffset, vectorDataLength, Float.valueOf(confidenceInterval), Float.valueOf(mergedQuantizationState.getLowerQuantile()), Float.valueOf(mergedQuantizationState.getUpperQuantile()), docsWithField);
                success = true;
                IndexInput finalQuantizationDataInput = quantizationDataInput;
                ScalarQuantizedRandomVectorScorerSupplier scorerSupplier = null;
                Optional factory = VectorScorerFactory.instance();
                if (factory.isPresent() && (scorer = ((VectorScorerFactory)factory.get()).getScalarQuantizedVectorScorer(byteVectorValues.dimension(), docsWithField.cardinality(), mergedQuantizationState.getConstantMultiplier(), VectorSimilarityType.of((VectorSimilarityFunction)fieldInfo.getVectorSimilarityFunction()), quantizationDataInput).map(VectorScorerSupplierAdapter::new)).isPresent()) {
                    scorerSupplier = (RandomVectorScorerSupplier)scorer.get();
                }
                if (scorerSupplier == null) {
                    scorerSupplier = new ScalarQuantizedRandomVectorScorerSupplier(fieldInfo.getVectorSimilarityFunction(), mergedQuantizationState, (RandomAccessQuantizedByteVectorValues)new OffHeapQuantizedByteVectorValues.DenseOffHeapVectorValues(fieldInfo.getVectorDimension(), docsWithField.cardinality(), quantizationDataInput));
                }
                scalarQuantizedCloseableRandomVectorScorerSupplier = new ScalarQuantizedCloseableRandomVectorScorerSupplier(() -> {
                    org.elasticsearch.core.IOUtils.close((Closeable)finalQuantizationDataInput);
                    segmentWriteState.directory.deleteFile(tempQuantizedVectorData.getName());
                }, docsWithField.cardinality(), (RandomVectorScorerSupplier)scorerSupplier);
                if (success) break block5;
            }
            catch (Throwable throwable) {
                if (!success) {
                    org.elasticsearch.core.IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{tempQuantizedVectorData, quantizationDataInput});
                    ES814ScalarQuantizedVectorsWriter.deleteFilesIgnoringExceptions(segmentWriteState.directory, tempQuantizedVectorData.getName());
                }
                throw throwable;
            }
            org.elasticsearch.core.IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{tempQuantizedVectorData, quantizationDataInput});
            ES814ScalarQuantizedVectorsWriter.deleteFilesIgnoringExceptions(segmentWriteState.directory, tempQuantizedVectorData.getName());
        }
        return scalarQuantizedCloseableRandomVectorScorerSupplier;
    }

    @SuppressForbidden(reason="closing using Lucene's variant")
    private static void deleteFilesIgnoringExceptions(Directory dir, String ... files) {
        IOUtils.deleteFilesIgnoringExceptions((Directory)dir, (String[])files);
    }

    private static QuantizedVectorsReader getQuantizedKnnVectorsReader(KnnVectorsReader vectorsReader, String fieldName) {
        if (vectorsReader instanceof PerFieldKnnVectorsFormat.FieldsReader) {
            vectorsReader = ((PerFieldKnnVectorsFormat.FieldsReader)vectorsReader).getFieldReader(fieldName);
        }
        if (vectorsReader instanceof QuantizedVectorsReader) {
            return (QuantizedVectorsReader)vectorsReader;
        }
        return null;
    }

    static boolean shouldRequantize(ScalarQuantizer existingQuantiles, ScalarQuantizer newQuantiles) {
        float tol = 0.2f * (newQuantiles.getUpperQuantile() - newQuantiles.getLowerQuantile()) / 128.0f;
        if (Math.abs(existingQuantiles.getUpperQuantile() - newQuantiles.getUpperQuantile()) > tol) {
            return true;
        }
        return Math.abs(existingQuantiles.getLowerQuantile() - newQuantiles.getLowerQuantile()) > tol;
    }

    public void close() throws IOException {
        org.elasticsearch.core.IOUtils.close((Closeable[])new Closeable[]{this.meta, this.quantizedVectorData, this.rawVectorDelegate});
    }

    static class FieldWriter
    extends FlatFieldVectorsWriter<float[]> {
        private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(FieldWriter.class);
        private final List<float[]> floatVectors;
        private final FieldInfo fieldInfo;
        private final float confidenceInterval;
        private final InfoStream infoStream;
        private final boolean normalize;
        private float minQuantile = Float.POSITIVE_INFINITY;
        private float maxQuantile = Float.NEGATIVE_INFINITY;
        private boolean finished;
        private final DocsWithFieldSet docsWithField;

        FieldWriter(float confidenceInterval, FieldInfo fieldInfo, InfoStream infoStream, KnnFieldVectorsWriter<?> indexWriter) {
            super(indexWriter);
            this.confidenceInterval = confidenceInterval;
            this.fieldInfo = fieldInfo;
            this.normalize = fieldInfo.getVectorSimilarityFunction() == VectorSimilarityFunction.COSINE;
            this.floatVectors = new ArrayList<float[]>();
            this.infoStream = infoStream;
            this.docsWithField = new DocsWithFieldSet();
        }

        void finish() throws IOException {
            if (this.finished) {
                return;
            }
            if (this.floatVectors.size() == 0) {
                this.finished = true;
                return;
            }
            ScalarQuantizer quantizer = ScalarQuantizer.fromVectors((FloatVectorValues)new FloatVectorWrapper(this.floatVectors, this.fieldInfo.getVectorSimilarityFunction() == VectorSimilarityFunction.COSINE), (float)this.confidenceInterval, (int)this.floatVectors.size());
            this.minQuantile = quantizer.getLowerQuantile();
            this.maxQuantile = quantizer.getUpperQuantile();
            if (this.infoStream.isEnabled("QVEC")) {
                this.infoStream.message("QVEC", "quantized field= confidenceInterval=" + this.confidenceInterval + " minQuantile=" + this.minQuantile + " maxQuantile=" + this.maxQuantile);
            }
            this.finished = true;
        }

        ScalarQuantizer createQuantizer() {
            assert (this.finished);
            return new ScalarQuantizer(this.minQuantile, this.maxQuantile, this.confidenceInterval);
        }

        public long ramBytesUsed() {
            long size = SHALLOW_SIZE;
            if (this.indexingDelegate != null) {
                size += this.indexingDelegate.ramBytesUsed();
            }
            if (this.floatVectors.size() == 0) {
                return size;
            }
            return size + (long)this.floatVectors.size() * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        }

        public void addValue(int docID, float[] vectorValue) throws IOException {
            this.docsWithField.add(docID);
            this.floatVectors.add(vectorValue);
            if (this.indexingDelegate != null) {
                this.indexingDelegate.addValue(docID, (Object)vectorValue);
            }
        }

        public float[] copyValue(float[] vectorValue) {
            throw new UnsupportedOperationException();
        }
    }

    static class MergedQuantizedVectorValues
    extends QuantizedByteVectorValues {
        private final List<QuantizedByteVectorValueSub> subs;
        private final DocIDMerger<QuantizedByteVectorValueSub> docIdMerger;
        private final int size;
        private int docId;
        private QuantizedByteVectorValueSub current;

        public static MergedQuantizedVectorValues mergeQuantizedByteVectorValues(FieldInfo fieldInfo, MergeState mergeState, ScalarQuantizer scalarQuantizer) throws IOException {
            assert (fieldInfo != null && fieldInfo.hasVectorValues());
            ArrayList<QuantizedByteVectorValueSub> subs = new ArrayList<QuantizedByteVectorValueSub>();
            for (int i = 0; i < mergeState.knnVectorsReaders.length; ++i) {
                if (mergeState.knnVectorsReaders[i] == null || mergeState.knnVectorsReaders[i].getFloatVectorValues(fieldInfo.name) == null) continue;
                QuantizedVectorsReader reader = ES814ScalarQuantizedVectorsWriter.getQuantizedKnnVectorsReader(mergeState.knnVectorsReaders[i], fieldInfo.name);
                assert (scalarQuantizer != null);
                QuantizedByteVectorValueSub sub = reader == null || reader.getQuantizationState(fieldInfo.name) == null || ES814ScalarQuantizedVectorsWriter.shouldRequantize(reader.getQuantizationState(fieldInfo.name), scalarQuantizer) ? new QuantizedByteVectorValueSub(mergeState.docMaps[i], new QuantizedFloatVectorValues(mergeState.knnVectorsReaders[i].getFloatVectorValues(fieldInfo.name), fieldInfo.getVectorSimilarityFunction(), scalarQuantizer)) : new QuantizedByteVectorValueSub(mergeState.docMaps[i], new OffsetCorrectedQuantizedByteVectorValues(reader.getQuantizedVectorValues(fieldInfo.name), fieldInfo.getVectorSimilarityFunction(), scalarQuantizer, reader.getQuantizationState(fieldInfo.name)));
                subs.add(sub);
            }
            return new MergedQuantizedVectorValues(subs, mergeState);
        }

        private MergedQuantizedVectorValues(List<QuantizedByteVectorValueSub> subs, MergeState mergeState) throws IOException {
            this.subs = subs;
            this.docIdMerger = DocIDMerger.of(subs, (boolean)mergeState.needsIndexSort);
            int totalSize = 0;
            for (QuantizedByteVectorValueSub sub : subs) {
                totalSize += sub.values.size();
            }
            this.size = totalSize;
            this.docId = -1;
        }

        public byte[] vectorValue() throws IOException {
            return this.current.values.vectorValue();
        }

        public int docID() {
            return this.docId;
        }

        public int nextDoc() throws IOException {
            this.current = (QuantizedByteVectorValueSub)this.docIdMerger.next();
            this.docId = this.current == null ? Integer.MAX_VALUE : this.current.mappedDocID;
            return this.docId;
        }

        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.size;
        }

        public int dimension() {
            return this.subs.get((int)0).values.dimension();
        }

        public float getScoreCorrectionConstant() throws IOException {
            return this.current.values.getScoreCorrectionConstant();
        }
    }

    static final class ScalarQuantizedCloseableRandomVectorScorerSupplier
    implements CloseableRandomVectorScorerSupplier {
        private final RandomVectorScorerSupplier supplier;
        private final Closeable onClose;
        private final int numVectors;

        ScalarQuantizedCloseableRandomVectorScorerSupplier(Closeable onClose, int numVectors, RandomVectorScorerSupplier supplier) {
            this.onClose = onClose;
            this.supplier = supplier;
            this.numVectors = numVectors;
        }

        public RandomVectorScorer scorer(int ord) throws IOException {
            return this.supplier.scorer(ord);
        }

        public RandomVectorScorerSupplier copy() throws IOException {
            return this.supplier.copy();
        }

        public void close() throws IOException {
            this.onClose.close();
        }

        public int totalVectorCount() {
            return this.numVectors;
        }
    }

    private static final class OffsetCorrectedQuantizedByteVectorValues
    extends QuantizedByteVectorValues {
        private final QuantizedByteVectorValues in;
        private final VectorSimilarityFunction vectorSimilarityFunction;
        private final ScalarQuantizer scalarQuantizer;
        private final ScalarQuantizer oldScalarQuantizer;

        private OffsetCorrectedQuantizedByteVectorValues(QuantizedByteVectorValues in, VectorSimilarityFunction vectorSimilarityFunction, ScalarQuantizer scalarQuantizer, ScalarQuantizer oldScalarQuantizer) {
            this.in = in;
            this.vectorSimilarityFunction = vectorSimilarityFunction;
            this.scalarQuantizer = scalarQuantizer;
            this.oldScalarQuantizer = oldScalarQuantizer;
        }

        public float getScoreCorrectionConstant() throws IOException {
            return this.scalarQuantizer.recalculateCorrectiveOffset(this.in.vectorValue(), this.oldScalarQuantizer, this.vectorSimilarityFunction);
        }

        public int dimension() {
            return this.in.dimension();
        }

        public int size() {
            return this.in.size();
        }

        public byte[] vectorValue() throws IOException {
            return this.in.vectorValue();
        }

        public int docID() {
            return this.in.docID();
        }

        public int nextDoc() throws IOException {
            return this.in.nextDoc();
        }

        public int advance(int target) throws IOException {
            return this.in.advance(target);
        }
    }

    private static class QuantizedFloatVectorValues
    extends QuantizedByteVectorValues {
        private final FloatVectorValues values;
        private final ScalarQuantizer quantizer;
        private final byte[] quantizedVector;
        private final float[] normalizedVector;
        private float offsetValue = 0.0f;
        private final VectorSimilarityFunction vectorSimilarityFunction;

        QuantizedFloatVectorValues(FloatVectorValues values, VectorSimilarityFunction vectorSimilarityFunction, ScalarQuantizer quantizer) {
            this.values = values;
            this.quantizer = quantizer;
            this.quantizedVector = new byte[values.dimension()];
            this.vectorSimilarityFunction = vectorSimilarityFunction;
            this.normalizedVector = (float[])(vectorSimilarityFunction == VectorSimilarityFunction.COSINE ? new float[values.dimension()] : null);
        }

        public float getScoreCorrectionConstant() {
            return this.offsetValue;
        }

        public int dimension() {
            return this.values.dimension();
        }

        public int size() {
            return this.values.size();
        }

        public byte[] vectorValue() throws IOException {
            return this.quantizedVector;
        }

        public int docID() {
            return this.values.docID();
        }

        public int nextDoc() throws IOException {
            int doc = this.values.nextDoc();
            if (doc != Integer.MAX_VALUE) {
                this.quantize();
            }
            return doc;
        }

        public int advance(int target) throws IOException {
            int doc = this.values.advance(target);
            if (doc != Integer.MAX_VALUE) {
                this.quantize();
            }
            return doc;
        }

        private void quantize() throws IOException {
            if (this.vectorSimilarityFunction == VectorSimilarityFunction.COSINE) {
                System.arraycopy(this.values.vectorValue(), 0, this.normalizedVector, 0, this.normalizedVector.length);
                VectorUtil.l2normalize((float[])this.normalizedVector);
                this.offsetValue = this.quantizer.quantize(this.normalizedVector, this.quantizedVector, this.vectorSimilarityFunction);
            } else {
                this.offsetValue = this.quantizer.quantize(this.values.vectorValue(), this.quantizedVector, this.vectorSimilarityFunction);
            }
        }
    }

    private static class QuantizedByteVectorValueSub
    extends DocIDMerger.Sub {
        private final QuantizedByteVectorValues values;

        QuantizedByteVectorValueSub(MergeState.DocMap docMap, QuantizedByteVectorValues values) {
            super(docMap);
            this.values = values;
            assert (values.docID() == -1);
        }

        public int nextDoc() throws IOException {
            return this.values.nextDoc();
        }
    }

    static class FloatVectorWrapper
    extends FloatVectorValues {
        private final List<float[]> vectorList;
        private final float[] copy;
        private final boolean normalize;
        protected int curDoc = -1;

        FloatVectorWrapper(List<float[]> vectorList, boolean normalize) {
            this.vectorList = vectorList;
            this.copy = new float[vectorList.get(0).length];
            this.normalize = normalize;
        }

        public int dimension() {
            return this.vectorList.get(0).length;
        }

        public int size() {
            return this.vectorList.size();
        }

        public float[] vectorValue() throws IOException {
            if (this.curDoc == -1 || this.curDoc >= this.vectorList.size()) {
                throw new IOException("Current doc not set or too many iterations");
            }
            if (this.normalize) {
                System.arraycopy(this.vectorList.get(this.curDoc), 0, this.copy, 0, this.copy.length);
                VectorUtil.l2normalize((float[])this.copy);
                return this.copy;
            }
            return this.vectorList.get(this.curDoc);
        }

        public int docID() {
            if (this.curDoc >= this.vectorList.size()) {
                return Integer.MAX_VALUE;
            }
            return this.curDoc;
        }

        public int nextDoc() throws IOException {
            ++this.curDoc;
            return this.docID();
        }

        public int advance(int target) throws IOException {
            this.curDoc = target;
            return this.docID();
        }
    }
}

