/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionHandler;
import org.elasticsearch.common.util.concurrent.SizeBlockingQueue;

public class EsAbortPolicy
extends EsRejectedExecutionHandler {
    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        if (!executor.isShutdown() && EsAbortPolicy.isForceExecution(r)) {
            BlockingQueue<Runnable> blockingQueue = executor.getQueue();
            if (blockingQueue instanceof SizeBlockingQueue) {
                SizeBlockingQueue sizeBlockingQueue = (SizeBlockingQueue)blockingQueue;
                try {
                    sizeBlockingQueue.forcePut(r);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException("forced execution, but got interrupted", e);
                }
                if (!(executor.isShutdown() && sizeBlockingQueue.remove(r))) {
                    return;
                }
            } else {
                throw new IllegalStateException("expected but did not find SizeBlockingQueue: " + executor);
            }
        }
        this.incrementRejections();
        throw EsAbortPolicy.newRejectedException(r, executor, executor.isShutdown());
    }

    private static boolean isForceExecution(Runnable r) {
        AbstractRunnable abstractRunnable;
        return r instanceof AbstractRunnable && (abstractRunnable = (AbstractRunnable)r).isForceExecution();
    }
}

