/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.component;

import org.elasticsearch.bootstrap.ElasticsearchProcess;

public final class Lifecycle {
    private volatile State state = State.INITIALIZED;

    public State state() {
        return this.state;
    }

    public boolean initialized() {
        return this.state == State.INITIALIZED;
    }

    public boolean started() {
        return this.state == State.STARTED;
    }

    public boolean stopped() {
        return this.state == State.STOPPED;
    }

    public boolean closed() {
        return this.state == State.CLOSED;
    }

    public boolean stoppedOrClosed() {
        State state = this.state;
        return state == State.STOPPED || state == State.CLOSED;
    }

    public boolean canMoveToStarted() throws IllegalStateException {
        return switch (this.state) {
            default -> throw new IncompatibleClassChangeError();
            case State.INITIALIZED -> true;
            case State.STARTED -> false;
            case State.STOPPED -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"STOPPED -> STARTED");
                }
                throw new IllegalStateException(ElasticsearchProcess.isStopping() ? "Can't start lifecycle object when the Elasticsearch process is shutting down" : "Can't move to started state when stopped");
            }
            case State.CLOSED -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"CLOSED -> STARTED");
                }
                throw new IllegalStateException("Can't move to started state when closed");
            }
        };
    }

    public synchronized boolean moveToStarted() throws IllegalStateException {
        if (this.canMoveToStarted()) {
            this.state = State.STARTED;
            return true;
        }
        return false;
    }

    public boolean canMoveToStopped() throws IllegalStateException {
        return switch (this.state) {
            default -> throw new IncompatibleClassChangeError();
            case State.INITIALIZED -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"INITIALIZED -> STOPPED");
                }
                throw new IllegalStateException("Can't move to stopped state when not started");
            }
            case State.STARTED -> true;
            case State.STOPPED -> false;
            case State.CLOSED -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"CLOSED -> STOPPED");
                }
                throw new IllegalStateException("Can't move to stopped state when closed");
            }
        };
    }

    public synchronized boolean moveToStopped() throws IllegalStateException {
        if (this.canMoveToStopped()) {
            this.state = State.STOPPED;
            return true;
        }
        return false;
    }

    public boolean canMoveToClosed() throws IllegalStateException {
        return switch (this.state) {
            default -> throw new IncompatibleClassChangeError();
            case State.INITIALIZED -> true;
            case State.STARTED -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"STARTED -> CLOSED");
                }
                throw new IllegalStateException("Can't move directly from STARTED to CLOSED, must move to STOPPED first");
            }
            case State.STOPPED -> true;
            case State.CLOSED -> false;
        };
    }

    public synchronized boolean moveToClosed() throws IllegalStateException {
        if (this.canMoveToClosed()) {
            this.state = State.CLOSED;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.state.toString();
    }

    public static enum State {
        INITIALIZED,
        STOPPED,
        STARTED,
        CLOSED;

    }
}

