/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.ByteBufferStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;

class BytesReferenceStreamInput
extends StreamInput {
    private static final ByteBuffer EMPTY = ByteBuffer.wrap(new byte[0]);
    protected final BytesReference bytesReference;
    private BytesRefIterator iterator;
    private ByteBuffer slice;
    private int totalOffset;
    private int mark = 0;

    BytesReferenceStreamInput(BytesReference bytesReference) throws IOException {
        this.bytesReference = bytesReference;
        this.iterator = bytesReference.iterator();
        this.slice = BytesReferenceStreamInput.convertToByteBuffer(this.iterator.next());
        this.totalOffset = 0;
    }

    static ByteBuffer convertToByteBuffer(BytesRef bytesRef) {
        if (bytesRef == null) {
            return EMPTY;
        }
        return ByteBuffer.wrap(bytesRef.bytes, bytesRef.offset, bytesRef.length).slice();
    }

    @Override
    public byte readByte() throws IOException {
        this.maybeNextSlice();
        return this.slice.get();
    }

    @Override
    public short readShort() throws IOException {
        if (this.slice.remaining() >= 2) {
            return this.slice.getShort();
        }
        return super.readShort();
    }

    @Override
    public int readInt() throws IOException {
        if (this.slice.remaining() >= 4) {
            return this.slice.getInt();
        }
        return super.readInt();
    }

    @Override
    public long readLong() throws IOException {
        if (this.slice.remaining() >= 8) {
            return this.slice.getLong();
        }
        return super.readLong();
    }

    @Override
    public String readString() throws IOException {
        String string;
        int chars = this.readArraySize();
        if (this.slice.hasArray() && (string = this.tryReadStringFromBytes(this.slice.array(), this.slice.position() + this.slice.arrayOffset(), this.slice.limit() + this.slice.arrayOffset(), chars)) != null) {
            return string;
        }
        return this.doReadString(chars);
    }

    @Override
    public int readVInt() throws IOException {
        if (this.slice.remaining() >= 5) {
            return ByteBufferStreamInput.readVInt(this.slice);
        }
        return super.readVInt();
    }

    @Override
    public long readVLong() throws IOException {
        if (this.slice.remaining() >= 10) {
            return ByteBufferStreamInput.readVLong(this.slice);
        }
        return super.readVLong();
    }

    protected int offset() {
        return this.totalOffset + this.slice.position();
    }

    private void maybeNextSlice() throws IOException {
        if (!this.slice.hasRemaining()) {
            this.moveToNextSlice();
        }
    }

    private void moveToNextSlice() throws IOException {
        this.totalOffset += this.slice.limit();
        BytesRef bytesRef = this.iterator.next();
        while (bytesRef != null && bytesRef.length == 0) {
            bytesRef = this.iterator.next();
        }
        if (bytesRef == null) {
            throw new EOFException();
        }
        this.slice = BytesReferenceStreamInput.convertToByteBuffer(bytesRef);
        assert (this.slice.position() == 0);
    }

    @Override
    public void readBytes(byte[] b, int bOffset, int len) throws IOException {
        Objects.checkFromIndexSize(this.offset(), len, this.bytesReference.length());
        int bytesRead = this.read(b, bOffset, len);
        assert (bytesRead == len) : bytesRead + " vs " + len;
    }

    @Override
    public int read() throws IOException {
        if (this.offset() >= this.bytesReference.length()) {
            return -1;
        }
        return Byte.toUnsignedInt(this.readByte());
    }

    @Override
    public int read(byte[] b, int bOffset, int len) throws IOException {
        if (this.slice.remaining() >= len) {
            this.slice.get(b, bOffset, len);
            return len;
        }
        return this.readFromMultipleSlices(b, bOffset, len);
    }

    private int readFromMultipleSlices(byte[] b, int bOffset, int len) throws IOException {
        int numBytesToCopy;
        int length = this.bytesReference.length();
        int offset = this.offset();
        if (offset >= length) {
            return -1;
        }
        int remaining = numBytesToCopy = Math.min(len, length - offset);
        int destOffset = bOffset;
        while (remaining > 0) {
            this.maybeNextSlice();
            int currentLen = Math.min(remaining, this.slice.remaining());
            assert (currentLen > 0) : "length has to be > 0 to make progress but was: " + currentLen;
            this.slice.get(b, destOffset, currentLen);
            destOffset += currentLen;
            assert ((remaining -= currentLen) >= 0) : "remaining: " + remaining;
        }
        return numBytesToCopy;
    }

    @Override
    public void close() {
    }

    @Override
    public int available() {
        return this.bytesReference.length() - this.offset();
    }

    @Override
    protected void ensureCanReadBytes(int bytesToRead) throws EOFException {
        int bytesAvailable = this.bytesReference.length() - this.offset();
        if (bytesAvailable < bytesToRead) {
            BytesReferenceStreamInput.throwEOF(bytesToRead, bytesAvailable);
        }
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        if (n <= (long)this.slice.remaining()) {
            this.slice.position(this.slice.position() + (int)n);
            return n;
        }
        return this.skipMultiple(n);
    }

    private int skipMultiple(long n) throws IOException {
        int numBytesSkipped;
        assert (this.offset() <= this.bytesReference.length()) : this.offset() + " vs " + this.bytesReference.length();
        int remaining = numBytesSkipped = (int)Math.min(n, (long)(this.bytesReference.length() - this.offset()));
        while (remaining > 0) {
            this.maybeNextSlice();
            int currentLen = Math.min(remaining, this.slice.remaining());
            this.slice.position(this.slice.position() + currentLen);
            assert ((remaining -= currentLen) >= 0) : "remaining: " + remaining;
        }
        return numBytesSkipped;
    }

    @Override
    public void reset() throws IOException {
        if (this.totalOffset <= this.mark) {
            this.slice.position(this.mark - this.totalOffset);
        } else {
            this.iterator = this.bytesReference.iterator();
            this.slice = BytesReferenceStreamInput.convertToByteBuffer(this.iterator.next());
            this.totalOffset = 0;
            long skipped = this.skip(this.mark);
            assert (skipped == (long)this.mark) : skipped + " vs " + this.mark;
        }
    }

    @Override
    public BytesReference readSlicedBytesReference() throws IOException {
        int len = this.readVInt();
        int pos = this.offset();
        if ((long)len != this.skip(len)) {
            throw new EOFException();
        }
        return this.bytesReference.slice(pos, len);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readLimit) {
        this.mark = this.offset();
    }
}

