/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.fs;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.common.blobstore.fs.FsBlobContainer;
import org.elasticsearch.core.IOUtils;

public class FsBlobStore
implements BlobStore {
    private final Path path;
    private final int bufferSizeInBytes;
    private final boolean readOnly;

    public FsBlobStore(int bufferSizeInBytes, Path path, boolean readonly) throws IOException {
        this.path = path;
        this.readOnly = readonly;
        if (!this.readOnly) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        this.bufferSizeInBytes = bufferSizeInBytes;
    }

    public String toString() {
        return this.path.toString();
    }

    public Path path() {
        return this.path;
    }

    public int bufferSizeInBytes() {
        return this.bufferSizeInBytes;
    }

    @Override
    public BlobContainer blobContainer(BlobPath path) {
        Path f = this.buildPath(path);
        if (!this.readOnly) {
            try {
                Files.createDirectories(f, new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new ElasticsearchException("failed to create blob container", (Throwable)ex, new Object[0]);
            }
        }
        return new FsBlobContainer(this, path, f);
    }

    @Override
    public void deleteBlobsIgnoringIfNotExists(OperationPurpose purpose, Iterator<String> blobNames) throws IOException {
        IOException ioe = null;
        long suppressedExceptions = 0L;
        while (blobNames.hasNext()) {
            try {
                Path resolve = this.path.resolve(blobNames.next());
                IOUtils.rm((Path[])new Path[]{resolve});
            }
            catch (IOException e) {
                if (e.getMessage().contains("NoSuchFileException")) continue;
                if (ioe == null) {
                    ioe = e;
                    continue;
                }
                if (ioe.getSuppressed().length < 10) {
                    ioe.addSuppressed(e);
                    continue;
                }
                ++suppressedExceptions;
            }
        }
        if (ioe != null) {
            if (suppressedExceptions > 0L) {
                ioe.addSuppressed(new IOException("Failed to delete files, suppressed [" + suppressedExceptions + "] failures"));
            }
            throw ioe;
        }
    }

    @Override
    public void close() {
    }

    private Path buildPath(BlobPath path) {
        List<String> paths = path.parts();
        if (paths.isEmpty()) {
            return this.path();
        }
        Path blobPath = this.path.resolve(paths.get(0));
        for (int i = 1; i < paths.size(); ++i) {
            blobPath = blobPath.resolve(paths.get(i));
        }
        return blobPath;
    }
}

