/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingChangesObserver;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.index.Index;

public class ResizeSourceIndexSettingsUpdater
implements RoutingChangesObserver {
    private final Set<Index> changes = new HashSet<Index>();

    @Override
    public void shardStarted(ShardRouting initializingShard, ShardRouting startedShard) {
        if (startedShard.primary() && initializingShard.recoverySource().getType() == RecoverySource.Type.LOCAL_SHARDS) {
            assert (startedShard.recoverySource() == null) : "recovery source should have been removed once shard is started";
            this.changes.add(startedShard.shardId().getIndex());
        }
    }

    public Metadata applyChanges(Metadata metadata, RoutingTable routingTable) {
        if (!this.changes.isEmpty()) {
            Map<Index, Settings> updates = Maps.newHashMapWithExpectedSize(this.changes.size());
            for (Index index : this.changes) {
                IndexMetadata indexMetadata = metadata.getIndexSafe(index);
                if (!routingTable.index(index).allPrimaryShardsActive()) continue;
                assert (indexMetadata.getResizeSourceIndex() != null) : "no resize source index for " + index;
                Settings.Builder builder = Settings.builder().put(indexMetadata.getSettings());
                builder.remove(IndexMetadata.INDEX_SHRINK_INITIAL_RECOVERY_KEY);
                builder.remove("index.resize.source.uuid");
                if (Strings.isNullOrEmpty(indexMetadata.getLifecyclePolicyName())) {
                    builder.remove("index.resize.source.name");
                }
                updates.put(index, builder.build());
            }
            return metadata.withIndexSettingsUpdates(updates);
        }
        return metadata;
    }
}

