/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.Map;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationStats;
import org.elasticsearch.cluster.routing.allocation.WriteLoadForecaster;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalance;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardAssignment;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.Maps;

public class AllocationStatsService {
    private final ClusterService clusterService;
    private final ClusterInfoService clusterInfoService;
    private final DesiredBalanceShardsAllocator desiredBalanceShardsAllocator;
    private final WriteLoadForecaster writeLoadForecaster;

    public AllocationStatsService(ClusterService clusterService, ClusterInfoService clusterInfoService, ShardsAllocator shardsAllocator, WriteLoadForecaster writeLoadForecaster) {
        DesiredBalanceShardsAllocator allocator;
        this.clusterService = clusterService;
        this.clusterInfoService = clusterInfoService;
        this.desiredBalanceShardsAllocator = shardsAllocator instanceof DesiredBalanceShardsAllocator ? (allocator = (DesiredBalanceShardsAllocator)shardsAllocator) : null;
        this.writeLoadForecaster = writeLoadForecaster;
    }

    public Map<String, NodeAllocationStats> stats() {
        ClusterState state = this.clusterService.state();
        ClusterInfo info = this.clusterInfoService.getClusterInfo();
        DesiredBalance desiredBalance = this.desiredBalanceShardsAllocator != null ? this.desiredBalanceShardsAllocator.getDesiredBalance() : null;
        Map<String, NodeAllocationStats> stats = Maps.newMapWithExpectedSize(state.getRoutingNodes().size());
        for (RoutingNode node : state.getRoutingNodes()) {
            int shards = 0;
            int undesiredShards = 0;
            double forecastedWriteLoad = 0.0;
            long forecastedDiskUsage = 0L;
            long currentDiskUsage = 0L;
            for (ShardRouting shardRouting : node) {
                if (shardRouting.relocating()) continue;
                ++shards;
                IndexMetadata indexMetadata = state.metadata().getIndexSafe(shardRouting.index());
                if (!AllocationStatsService.isDesiredAllocation(desiredBalance, shardRouting)) {
                    ++undesiredShards;
                }
                long shardSize = info.getShardSize(shardRouting.shardId(), shardRouting.primary(), 0L);
                forecastedWriteLoad += this.writeLoadForecaster.getForecastedWriteLoad(indexMetadata).orElse(0.0);
                forecastedDiskUsage += Math.max(indexMetadata.getForecastedShardSizeInBytes().orElse(0L), shardSize);
                currentDiskUsage += shardSize;
            }
            stats.put(node.nodeId(), new NodeAllocationStats(shards, this.desiredBalanceShardsAllocator != null ? undesiredShards : -1, forecastedWriteLoad, forecastedDiskUsage, currentDiskUsage));
        }
        return stats;
    }

    private static boolean isDesiredAllocation(DesiredBalance desiredBalance, ShardRouting shardRouting) {
        if (desiredBalance == null) {
            return true;
        }
        ShardAssignment assignment = desiredBalance.getAssignment(shardRouting.shardId());
        if (assignment == null) {
            return false;
        }
        return assignment.nodeIds().contains(shardRouting.currentNodeId());
    }
}

