/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.IndexRouting;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.Murmur3HashFunction;
import org.elasticsearch.cluster.routing.PlainShardIterator;
import org.elasticsearch.cluster.routing.Preference;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.node.ResponseCollectorService;

public class OperationRouting {
    public static final Setting<Boolean> USE_ADAPTIVE_REPLICA_SELECTION_SETTING = Setting.boolSetting("cluster.routing.use_adaptive_replica_selection", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private boolean useAdaptiveReplicaSelection;
    private final boolean isStateless;

    public OperationRouting(Settings settings, ClusterSettings clusterSettings) {
        this.isStateless = DiscoveryNode.isStateless(settings);
        this.useAdaptiveReplicaSelection = USE_ADAPTIVE_REPLICA_SELECTION_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(USE_ADAPTIVE_REPLICA_SELECTION_SETTING, this::setUseAdaptiveReplicaSelection);
    }

    void setUseAdaptiveReplicaSelection(boolean useAdaptiveReplicaSelection) {
        this.useAdaptiveReplicaSelection = useAdaptiveReplicaSelection;
    }

    public ShardIterator getShards(ClusterState clusterState, String index, String id, @Nullable String routing, @Nullable String preference) {
        IndexRouting indexRouting = IndexRouting.fromIndexMetadata(OperationRouting.indexMetadata(clusterState, index));
        IndexShardRoutingTable shards = clusterState.getRoutingTable().shardRoutingTable(index, indexRouting.getShard(id, routing));
        return this.preferenceActiveShardIterator(shards, clusterState.nodes().getLocalNodeId(), clusterState.nodes(), preference, null, null);
    }

    public ShardIterator getShards(ClusterState clusterState, String index, int shardId, @Nullable String preference) {
        IndexShardRoutingTable indexShard = clusterState.getRoutingTable().shardRoutingTable(index, shardId);
        return this.preferenceActiveShardIterator(indexShard, clusterState.nodes().getLocalNodeId(), clusterState.nodes(), preference, null, null);
    }

    public ShardIterator useOnlyPromotableShardsForStateless(ShardIterator shards) {
        if (this.isStateless && shards != null) {
            return new PlainShardIterator(shards.shardId(), shards.getShardRoutings().stream().filter(ShardRouting::isPromotableToPrimary).collect(Collectors.toList()));
        }
        return shards;
    }

    public GroupShardsIterator<ShardIterator> searchShards(ClusterState clusterState, String[] concreteIndices, @Nullable Map<String, Set<String>> routing, @Nullable String preference) {
        return this.searchShards(clusterState, concreteIndices, routing, preference, null, null);
    }

    public GroupShardsIterator<ShardIterator> searchShards(ClusterState clusterState, String[] concreteIndices, @Nullable Map<String, Set<String>> routing, @Nullable String preference, @Nullable ResponseCollectorService collectorService, @Nullable Map<String, Long> nodeCounts) {
        Set<IndexShardRoutingTable> shards = OperationRouting.computeTargetedShards(clusterState, concreteIndices, routing);
        HashSet<PlainShardIterator> set = Sets.newHashSetWithExpectedSize(shards.size());
        for (IndexShardRoutingTable shard : shards) {
            ShardIterator iterator = this.preferenceActiveShardIterator(shard, clusterState.nodes().getLocalNodeId(), clusterState.nodes(), preference, collectorService, nodeCounts);
            if (iterator == null) continue;
            List<ShardRouting> shardsThatCanHandleSearches = this.isStateless ? OperationRouting.statelessShardsThatHandleSearches(clusterState, iterator) : OperationRouting.statefulShardsThatHandleSearches(iterator);
            set.add(new PlainShardIterator(iterator.shardId(), shardsThatCanHandleSearches));
        }
        return GroupShardsIterator.sortAndCreate(new ArrayList(set));
    }

    private static List<ShardRouting> statefulShardsThatHandleSearches(ShardIterator iterator) {
        ArrayList<ShardRouting> shardsThatCanHandleSearches = new ArrayList<ShardRouting>(iterator.size());
        for (ShardRouting shardRouting : iterator) {
            if (!shardRouting.isSearchable()) continue;
            shardsThatCanHandleSearches.add(shardRouting);
        }
        return shardsThatCanHandleSearches;
    }

    private static List<ShardRouting> statelessShardsThatHandleSearches(ClusterState clusterState, ShardIterator iterator) {
        return iterator.getShardRoutings().stream().filter(shardRouting -> OperationRouting.canSearchShard(shardRouting, clusterState)).toList();
    }

    public static ShardIterator getShards(ClusterState clusterState, ShardId shardId) {
        IndexShardRoutingTable shard = clusterState.routingTable().shardRoutingTable(shardId);
        return shard.activeInitializingShardsRandomIt();
    }

    private static Set<IndexShardRoutingTable> computeTargetedShards(ClusterState clusterState, String[] concreteIndices, @Nullable Map<String, Set<String>> routing) {
        HashSet<IndexShardRoutingTable> set = new HashSet<IndexShardRoutingTable>();
        if (routing == null || routing.isEmpty()) {
            OperationRouting.collectTargetShardsNoRouting(clusterState, concreteIndices, set);
        } else {
            OperationRouting.collectTargetShardsWithRouting(clusterState, concreteIndices, routing, set);
        }
        return set;
    }

    private static void collectTargetShardsWithRouting(ClusterState clusterState, String[] concreteIndices, Map<String, Set<String>> routing, Set<IndexShardRoutingTable> set) {
        for (String index : concreteIndices) {
            IndexRoutingTable indexRoutingTable = OperationRouting.indexRoutingTable(clusterState, index);
            Set<String> indexSearchRouting = routing.get(index);
            if (indexSearchRouting != null) {
                IndexRouting indexRouting = IndexRouting.fromIndexMetadata(OperationRouting.indexMetadata(clusterState, index));
                for (String r : indexSearchRouting) {
                    indexRouting.collectSearchShards(r, s -> set.add(RoutingTable.shardRoutingTable(indexRoutingTable, s)));
                }
                continue;
            }
            for (int i = 0; i < indexRoutingTable.size(); ++i) {
                set.add(indexRoutingTable.shard(i));
            }
        }
    }

    private static void collectTargetShardsNoRouting(ClusterState clusterState, String[] concreteIndices, Set<IndexShardRoutingTable> set) {
        for (String index : concreteIndices) {
            IndexRoutingTable indexRoutingTable = OperationRouting.indexRoutingTable(clusterState, index);
            for (int i = 0; i < indexRoutingTable.size(); ++i) {
                set.add(indexRoutingTable.shard(i));
            }
        }
    }

    private ShardIterator preferenceActiveShardIterator(IndexShardRoutingTable indexShard, String localNodeId, DiscoveryNodes nodes, @Nullable String preference, @Nullable ResponseCollectorService collectorService, @Nullable Map<String, Long> nodeCounts) {
        if (preference == null || preference.isEmpty()) {
            return this.shardRoutings(indexShard, collectorService, nodeCounts);
        }
        if (preference.charAt(0) == '_') {
            Preference preferenceType = Preference.parse(preference);
            if (preferenceType == Preference.SHARDS) {
                int index = preference.indexOf(124);
                String shards = index == -1 ? preference.substring(Preference.SHARDS.type().length() + 1) : preference.substring(Preference.SHARDS.type().length() + 1, index);
                String[] ids = Strings.splitStringByCommaToArray(shards);
                boolean found = false;
                for (String id : ids) {
                    if (Integer.parseInt(id) != indexShard.shardId().id()) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return null;
                }
                if (index == -1 || index == preference.length() - 1) {
                    return this.shardRoutings(indexShard, collectorService, nodeCounts);
                }
                preference = preference.substring(index + 1);
            }
            if (preference.charAt(0) == '_') {
                preferenceType = Preference.parse(preference);
                switch (preferenceType) {
                    case PREFER_NODES: {
                        Set<String> nodesIds = Arrays.stream(preference.substring(Preference.PREFER_NODES.type().length() + 1).split(",")).collect(Collectors.toSet());
                        return indexShard.preferNodeActiveInitializingShardsIt(nodesIds);
                    }
                    case LOCAL: {
                        return indexShard.preferNodeActiveInitializingShardsIt(Collections.singleton(localNodeId));
                    }
                    case ONLY_LOCAL: {
                        return indexShard.onlyNodeActiveInitializingShardsIt(localNodeId);
                    }
                    case ONLY_NODES: {
                        String nodeAttributes = preference.substring(Preference.ONLY_NODES.type().length() + 1);
                        return indexShard.onlyNodeSelectorActiveInitializingShardsIt(nodeAttributes.split(","), nodes);
                    }
                }
                throw new IllegalArgumentException("unknown preference [" + preferenceType + "]");
            }
        }
        int routingHash = 31 * Murmur3HashFunction.hash(preference) + indexShard.shardId.hashCode();
        return indexShard.activeInitializingShardsIt(routingHash);
    }

    private ShardIterator shardRoutings(IndexShardRoutingTable indexShard, @Nullable ResponseCollectorService collectorService, @Nullable Map<String, Long> nodeCounts) {
        if (this.useAdaptiveReplicaSelection) {
            return indexShard.activeInitializingShardsRankedIt(collectorService, nodeCounts);
        }
        return indexShard.activeInitializingShardsRandomIt();
    }

    protected static IndexRoutingTable indexRoutingTable(ClusterState clusterState, String index) {
        IndexRoutingTable indexRouting = clusterState.routingTable().index(index);
        if (indexRouting == null) {
            throw new IndexNotFoundException(index);
        }
        return indexRouting;
    }

    private static IndexMetadata indexMetadata(ClusterState clusterState, String index) {
        IndexMetadata indexMetadata = clusterState.metadata().index(index);
        if (indexMetadata == null) {
            throw new IndexNotFoundException(index);
        }
        return indexMetadata;
    }

    public ShardId shardId(ClusterState clusterState, String index, String id, @Nullable String routing) {
        IndexMetadata indexMetadata = OperationRouting.indexMetadata(clusterState, index);
        return new ShardId(indexMetadata.getIndex(), IndexRouting.fromIndexMetadata(indexMetadata).getShard(id, routing));
    }

    public static boolean canSearchShard(ShardRouting shardRouting, ClusterState clusterState) {
        if (IndexSettings.INDEX_FAST_REFRESH_SETTING.get(clusterState.metadata().index(shardRouting.index()).getSettings()).booleanValue()) {
            return shardRouting.isPromotableToPrimary();
        }
        return shardRouting.isSearchable();
    }
}

