/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;

public class MasterHistory
implements ClusterStateListener {
    private final TimeValue maxHistoryAge;
    private final ClusterService clusterService;
    private volatile List<TimeAndMaster> masterHistory = new ArrayList<TimeAndMaster>();
    private final LongSupplier currentTimeMillisSupplier = threadPool::relativeTimeInMillis;
    public static final int MAX_HISTORY_SIZE = 50;
    private static final TimeValue DEFAULT_MAX_HISTORY_AGE = new TimeValue(30L, TimeUnit.MINUTES);
    private static final TimeValue SMALLEST_ALLOWED_MAX_HISTORY_AGE = new TimeValue(1L, TimeUnit.MINUTES);
    public static final Setting<TimeValue> MAX_HISTORY_AGE_SETTING = Setting.timeSetting("master_history.max_age", DEFAULT_MAX_HISTORY_AGE, SMALLEST_ALLOWED_MAX_HISTORY_AGE, Setting.Property.NodeScope);

    public MasterHistory(ThreadPool threadPool, ClusterService clusterService) {
        this.maxHistoryAge = MAX_HISTORY_AGE_SETTING.get(clusterService.getSettings());
        this.clusterService = clusterService;
        clusterService.addListener(this);
    }

    public TimeValue getMaxHistoryAge() {
        return this.maxHistoryAge;
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        DiscoveryNode currentMaster = event.state().nodes().getMasterNode();
        DiscoveryNode previousMaster = event.previousState().nodes().getMasterNode();
        if (currentMaster == null || !currentMaster.equals(previousMaster) || this.masterHistory.isEmpty()) {
            int startIndex;
            long now = this.currentTimeMillisSupplier.getAsLong();
            long oldestRelevantHistoryTime = now - this.maxHistoryAge.getMillis();
            ArrayList<TimeAndMaster> newMasterHistory = new ArrayList<TimeAndMaster>();
            int sizeAfterAddingNewMaster = this.masterHistory.size() + 1;
            for (int i = startIndex = Math.max(0, sizeAfterAddingNewMaster - 50); i < this.masterHistory.size(); ++i) {
                TimeAndMaster timeAndMaster = this.masterHistory.get(i);
                long currentMasterEndTime = i < this.masterHistory.size() - 1 ? this.masterHistory.get((int)(i + 1)).startTimeMillis : Long.MAX_VALUE;
                if (currentMasterEndTime < oldestRelevantHistoryTime) continue;
                newMasterHistory.add(timeAndMaster);
            }
            newMasterHistory.add(new TimeAndMaster(this.currentTimeMillisSupplier.getAsLong(), currentMaster));
            this.masterHistory = Collections.unmodifiableList(newMasterHistory);
        }
    }

    @Nullable
    public DiscoveryNode getMostRecentMaster() {
        List<TimeAndMaster> masterHistoryCopy = this.getRecentMasterHistory(this.masterHistory);
        return masterHistoryCopy.isEmpty() ? null : masterHistoryCopy.get((int)(masterHistoryCopy.size() - 1)).master;
    }

    @Nullable
    public DiscoveryNode getMostRecentNonNullMaster() {
        List<TimeAndMaster> masterHistoryCopy = this.getRecentMasterHistory(this.masterHistory);
        Collections.reverse(masterHistoryCopy);
        for (TimeAndMaster timeAndMaster : masterHistoryCopy) {
            if (timeAndMaster.master == null) continue;
            return timeAndMaster.master;
        }
        return null;
    }

    public boolean hasMasterGoneNullAtLeastNTimes(int n) {
        return MasterHistory.hasMasterGoneNullAtLeastNTimes(this.getNodes(), n);
    }

    public static boolean hasMasterGoneNullAtLeastNTimes(List<DiscoveryNode> masters, int n) {
        int timesMasterHasGoneNull = 0;
        boolean previousNull = true;
        for (DiscoveryNode master : masters) {
            if (master == null) {
                if (!previousNull) {
                    ++timesMasterHasGoneNull;
                }
                previousNull = true;
                continue;
            }
            previousNull = false;
        }
        return timesMasterHasGoneNull >= n;
    }

    public static int getNumberOfMasterIdentityChanges(List<DiscoveryNode> masterHistory) {
        int identityChanges = 0;
        List<DiscoveryNode> nonNullHistory = masterHistory.stream().filter(Objects::nonNull).toList();
        DiscoveryNode previousNode = null;
        for (DiscoveryNode node : nonNullHistory) {
            if (previousNode != null && !previousNode.equals(node)) {
                ++identityChanges;
            }
            previousNode = node;
        }
        return identityChanges;
    }

    public boolean hasSeenMasterInLastNSeconds(int nSeconds) {
        if (this.getMostRecentMaster() != null) {
            return true;
        }
        List<TimeAndMaster> masterHistoryCopy = this.getRecentMasterHistory(this.masterHistory);
        long now = this.currentTimeMillisSupplier.getAsLong();
        TimeValue nSecondsTimeValue = new TimeValue((long)nSeconds, TimeUnit.SECONDS);
        long nSecondsAgo = now - nSecondsTimeValue.getMillis();
        for (int i = masterHistoryCopy.size() - 1; i >= 0; --i) {
            TimeAndMaster timeAndMaster = masterHistoryCopy.get(i);
            if (timeAndMaster.master != null) {
                return true;
            }
            if (timeAndMaster.startTimeMillis < nSecondsAgo) break;
        }
        return false;
    }

    private List<TimeAndMaster> getRecentMasterHistory(List<TimeAndMaster> history) {
        if (history.size() < 2) {
            return history;
        }
        long now = this.currentTimeMillisSupplier.getAsLong();
        long oldestRelevantHistoryTime = now - this.maxHistoryAge.getMillis();
        ArrayList<TimeAndMaster> filteredHistory = new ArrayList<TimeAndMaster>();
        for (int i = 0; i < history.size(); ++i) {
            TimeAndMaster timeAndMaster = history.get(i);
            long endTime = i < history.size() - 1 ? history.get((int)(i + 1)).startTimeMillis : Long.MAX_VALUE;
            if (endTime < oldestRelevantHistoryTime) continue;
            filteredHistory.add(timeAndMaster);
        }
        return filteredHistory;
    }

    public List<DiscoveryNode> getRawNodes() {
        List<TimeAndMaster> masterHistoryCopy = this.getRecentMasterHistory(this.masterHistory);
        return masterHistoryCopy.stream().map(TimeAndMaster::master).toList();
    }

    public List<DiscoveryNode> getNodes() {
        List<DiscoveryNode> nodes = this.getRawNodes();
        if (nodes == null || nodes.isEmpty()) {
            return nodes;
        }
        Set ephemeralIdsCurrentlyInCluster = this.clusterService.state().nodes().stream().map(DiscoveryNode::getEphemeralId).collect(Collectors.toSet());
        return nodes.stream().filter(node -> node == null || ephemeralIdsCurrentlyInCluster.contains(node.getEphemeralId())).collect(Collectors.toList());
    }

    private record TimeAndMaster(long startTimeMillis, DiscoveryNode master) {
    }
}

