/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.SortedSetSortField;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.search.CountOnlyQueryPhaseResultConsumer;
import org.elasticsearch.action.search.QueryPhaseResultConsumer;
import org.elasticsearch.action.search.SearchPhaseResults;
import org.elasticsearch.action.search.SearchProgressListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponseSections;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.io.stream.DelayableWriteable;
import org.elasticsearch.common.lucene.search.TopDocsAndMaxScore;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.lucene.grouping.TopFieldGroups;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.dfs.DfsKnnResults;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.profile.SearchProfileQueryPhaseResult;
import org.elasticsearch.search.profile.SearchProfileResults;
import org.elasticsearch.search.profile.SearchProfileResultsBuilder;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.rank.RankCoordinatorContext;
import org.elasticsearch.search.rank.RankDoc;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.completion.CompletionSuggestion;

public final class SearchPhaseController {
    private static final ScoreDoc[] EMPTY_DOCS = new ScoreDoc[0];
    private final BiFunction<Supplier<Boolean>, AggregatorFactories.Builder, AggregationReduceContext.Builder> requestToAggReduceContextBuilder;

    public SearchPhaseController(BiFunction<Supplier<Boolean>, AggregatorFactories.Builder, AggregationReduceContext.Builder> requestToAggReduceContextBuilder) {
        this.requestToAggReduceContextBuilder = requestToAggReduceContextBuilder;
    }

    public static AggregatedDfs aggregateDfs(Collection<DfsSearchResult> results) {
        HashMap<Term, TermStatistics> termStatistics = new HashMap<Term, TermStatistics>();
        HashMap<String, CollectionStatistics> fieldStatistics = new HashMap<String, CollectionStatistics>();
        long aggMaxDoc = 0L;
        for (DfsSearchResult lEntry : results) {
            Term[] terms = lEntry.terms();
            TermStatistics[] stats = lEntry.termStatistics();
            assert (terms.length == stats.length);
            for (int i = 0; i < terms.length; ++i) {
                assert (terms[i] != null);
                if (stats[i] == null) continue;
                TermStatistics existing = (TermStatistics)termStatistics.get(terms[i]);
                if (existing != null) {
                    assert (terms[i].bytes().equals((Object)existing.term()));
                    termStatistics.put(terms[i], new TermStatistics(existing.term(), existing.docFreq() + stats[i].docFreq(), existing.totalTermFreq() + stats[i].totalTermFreq()));
                    continue;
                }
                termStatistics.put(terms[i], stats[i]);
            }
            assert (!lEntry.fieldStatistics().containsKey(null));
            for (Map.Entry<String, CollectionStatistics> entry : lEntry.fieldStatistics().entrySet()) {
                String key = entry.getKey();
                CollectionStatistics value = entry.getValue();
                if (value == null) continue;
                assert (key != null);
                CollectionStatistics existing = (CollectionStatistics)fieldStatistics.get(key);
                if (existing != null) {
                    CollectionStatistics merged = new CollectionStatistics(key, existing.maxDoc() + value.maxDoc(), existing.docCount() + value.docCount(), existing.sumTotalTermFreq() + value.sumTotalTermFreq(), existing.sumDocFreq() + value.sumDocFreq());
                    fieldStatistics.put(key, merged);
                    continue;
                }
                fieldStatistics.put(key, value);
            }
            aggMaxDoc += (long)lEntry.maxDoc();
        }
        return new AggregatedDfs(termStatistics, fieldStatistics, aggMaxDoc);
    }

    public static List<DfsKnnResults> mergeKnnResults(SearchRequest request, List<DfsSearchResult> dfsSearchResults) {
        if (!request.hasKnnSearch()) {
            return null;
        }
        SearchSourceBuilder source = request.source();
        ArrayList topDocsLists = new ArrayList(source.knnSearch().size());
        ArrayList<SetOnce> nestedPath = new ArrayList<SetOnce>(source.knnSearch().size());
        for (int i = 0; i < source.knnSearch().size(); ++i) {
            topDocsLists.add(new ArrayList());
            nestedPath.add(new SetOnce());
        }
        for (DfsSearchResult dfsSearchResult : dfsSearchResults) {
            if (dfsSearchResult.knnResults() == null) continue;
            for (int i = 0; i < dfsSearchResult.knnResults().size(); ++i) {
                DfsKnnResults knnResults = dfsSearchResult.knnResults().get(i);
                ScoreDoc[] scoreDocs = knnResults.scoreDocs();
                TotalHits totalHits = new TotalHits((long)scoreDocs.length, TotalHits.Relation.EQUAL_TO);
                TopDocs shardTopDocs = new TopDocs(totalHits, scoreDocs);
                SearchPhaseController.setShardIndex(shardTopDocs, dfsSearchResult.getShardIndex());
                ((List)topDocsLists.get(i)).add(shardTopDocs);
                ((SetOnce)nestedPath.get(i)).trySet((Object)knnResults.getNestedPath());
            }
        }
        ArrayList<DfsKnnResults> mergedResults = new ArrayList<DfsKnnResults>(source.knnSearch().size());
        for (int i = 0; i < source.knnSearch().size(); ++i) {
            TopDocs mergedTopDocs = TopDocs.merge((int)source.knnSearch().get(i).k(), (TopDocs[])((List)topDocsLists.get(i)).toArray(new TopDocs[0]));
            mergedResults.add(new DfsKnnResults((String)((SetOnce)nestedPath.get(i)).get(), mergedTopDocs.scoreDocs));
        }
        return mergedResults;
    }

    /*
     * WARNING - void declaration
     */
    static SortedTopDocs sortDocs(boolean ignoreFrom, Collection<TopDocs> topDocs, int from, int size, List<CompletionSuggestion> reducedCompletionSuggestions) {
        void var10_15;
        ScoreDoc[] mergedScoreDocs;
        if (topDocs.isEmpty() && reducedCompletionSuggestions.isEmpty()) {
            return SortedTopDocs.EMPTY;
        }
        TopDocs mergedTopDocs = SearchPhaseController.mergeTopDocs(topDocs, size, ignoreFrom ? 0 : from);
        ScoreDoc[] scoreDocs = mergedScoreDocs = mergedTopDocs == null ? EMPTY_DOCS : mergedTopDocs.scoreDocs;
        int numSuggestDocs = 0;
        if (!reducedCompletionSuggestions.isEmpty()) {
            for (CompletionSuggestion completionSuggestion : reducedCompletionSuggestions) {
                assert (completionSuggestion != null);
                numSuggestDocs += completionSuggestion.getOptions().size();
            }
            scoreDocs = new ScoreDoc[mergedScoreDocs.length + numSuggestDocs];
            System.arraycopy(mergedScoreDocs, 0, scoreDocs, 0, mergedScoreDocs.length);
            int offset = mergedScoreDocs.length;
            for (CompletionSuggestion completionSuggestion : reducedCompletionSuggestions) {
                for (CompletionSuggestion.Entry.Option option : completionSuggestion.getOptions()) {
                    scoreDocs[offset++] = option.getDoc();
                }
            }
        }
        boolean isSortedByField = false;
        Object var10_13 = null;
        String groupField = null;
        Object[] groupValues = null;
        if (mergedTopDocs instanceof TopFieldDocs) {
            TopFieldDocs fieldDocs = (TopFieldDocs)mergedTopDocs;
            SortField[] sortFieldArray = fieldDocs.fields;
            if (fieldDocs instanceof TopFieldGroups) {
                TopFieldGroups topFieldGroups = (TopFieldGroups)fieldDocs;
                isSortedByField = !(fieldDocs.fields.length == 1 && fieldDocs.fields[0].getType() == SortField.Type.SCORE);
                groupField = topFieldGroups.field;
                groupValues = topFieldGroups.groupValues;
            } else {
                isSortedByField = true;
            }
        }
        return new SortedTopDocs(scoreDocs, isSortedByField, (SortField[])var10_15, groupField, groupValues, numSuggestDocs);
    }

    static TopDocs mergeTopDocs(Collection<TopDocs> results, int topN, int from) {
        Object mergedTopDocs;
        if (results.isEmpty()) {
            return null;
        }
        TopDocs topDocs = results.stream().findFirst().get();
        int numShards = results.size();
        if (numShards == 1 && from == 0) {
            return topDocs;
        }
        if (topDocs instanceof TopFieldGroups) {
            TopFieldGroups firstTopDocs = (TopFieldGroups)topDocs;
            Sort sort = new Sort(firstTopDocs.fields);
            TopFieldGroups[] shardTopDocs = results.toArray(new TopFieldGroups[numShards]);
            mergedTopDocs = TopFieldGroups.merge(sort, from, topN, shardTopDocs, false);
        } else if (topDocs instanceof TopFieldDocs) {
            TopFieldDocs firstTopDocs = (TopFieldDocs)topDocs;
            Sort sort = SearchPhaseController.checkSameSortTypes(results, firstTopDocs.fields);
            TopFieldDocs[] shardTopDocs = results.toArray(new TopFieldDocs[numShards]);
            mergedTopDocs = TopDocs.merge((Sort)sort, (int)from, (int)topN, (TopFieldDocs[])shardTopDocs);
        } else {
            TopDocs[] shardTopDocs = results.toArray(new TopDocs[numShards]);
            mergedTopDocs = TopDocs.merge((int)from, (int)topN, (TopDocs[])shardTopDocs);
        }
        return mergedTopDocs;
    }

    private static Sort checkSameSortTypes(Collection<TopDocs> results, SortField[] firstSortFields) {
        Sort sort = new Sort(firstSortFields);
        if (results.size() < 2) {
            return sort;
        }
        SortField.Type[] firstTypes = null;
        boolean isFirstResult = true;
        for (TopDocs topDocs : results) {
            int i;
            if (topDocs.scoreDocs == null || topDocs.scoreDocs.length == 0) continue;
            SortField[] curSortFields = ((TopFieldDocs)topDocs).fields;
            if (isFirstResult) {
                sort = new Sort(curSortFields);
                firstTypes = new SortField.Type[curSortFields.length];
                for (i = 0; i < curSortFields.length; ++i) {
                    firstTypes[i] = SearchPhaseController.getType(curSortFields[i]);
                    if (firstTypes[i] != SortField.Type.CUSTOM) continue;
                    return sort;
                }
                isFirstResult = false;
                continue;
            }
            for (i = 0; i < curSortFields.length; ++i) {
                SortField.Type curType = SearchPhaseController.getType(curSortFields[i]);
                if (curType == firstTypes[i]) continue;
                if (curType == SortField.Type.CUSTOM) {
                    return sort;
                }
                throw new IllegalArgumentException("Can't sort on field [" + curSortFields[i].getField() + "]; the field has incompatible sort types: [" + firstTypes[i] + "] and [" + curType + "] across shards!");
            }
        }
        return sort;
    }

    private static SortField.Type getType(SortField sortField) {
        if (sortField instanceof SortedNumericSortField) {
            return ((SortedNumericSortField)sortField).getNumericType();
        }
        if (sortField instanceof SortedSetSortField) {
            return SortField.Type.STRING;
        }
        return sortField.getType();
    }

    static void setShardIndex(TopDocs topDocs, int shardIndex) {
        assert (topDocs.scoreDocs.length == 0 || topDocs.scoreDocs[0].shardIndex == -1) : "shardIndex is already set";
        for (ScoreDoc doc : topDocs.scoreDocs) {
            doc.shardIndex = shardIndex;
        }
    }

    public static ScoreDoc[] getLastEmittedDocPerShard(ReducedQueryPhase reducedQueryPhase, int numShards) {
        ScoreDoc[] lastEmittedDocPerShard = new ScoreDoc[numShards];
        if (!reducedQueryPhase.isEmptyResult) {
            ScoreDoc[] sortedScoreDocs = reducedQueryPhase.sortedTopDocs.scoreDocs;
            long size = Math.min(reducedQueryPhase.fetchHits, (long)reducedQueryPhase.size);
            size = Math.min((long)sortedScoreDocs.length, size);
            int sortedDocsIndex = 0;
            while ((long)sortedDocsIndex < size) {
                ScoreDoc scoreDoc;
                lastEmittedDocPerShard[scoreDoc.shardIndex] = scoreDoc = sortedScoreDocs[sortedDocsIndex];
                ++sortedDocsIndex;
            }
        }
        return lastEmittedDocPerShard;
    }

    public static List<Integer>[] fillDocIdsToLoad(int numShards, ScoreDoc[] shardDocs) {
        List[] docIdsToLoad = new ArrayList[numShards];
        for (ScoreDoc shardDoc : shardDocs) {
            ArrayList<Integer> shardDocIdsToLoad = docIdsToLoad[shardDoc.shardIndex];
            if (shardDocIdsToLoad == null) {
                shardDocIdsToLoad = docIdsToLoad[shardDoc.shardIndex] = new ArrayList<Integer>();
            }
            shardDocIdsToLoad.add(shardDoc.doc);
        }
        return docIdsToLoad;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SearchResponseSections merge(boolean ignoreFrom, ReducedQueryPhase reducedQueryPhase, AtomicArray<? extends SearchPhaseResult> fetchResultsArray) {
        if (reducedQueryPhase.isEmptyResult) {
            return SearchResponseSections.EMPTY_WITH_TOTAL_HITS;
        }
        ScoreDoc[] sortedDocs = reducedQueryPhase.sortedTopDocs.scoreDocs;
        List<? extends SearchPhaseResult> fetchResults = fetchResultsArray.asList();
        SearchHits hits = SearchPhaseController.getHits(reducedQueryPhase, ignoreFrom, fetchResultsArray);
        try {
            if (reducedQueryPhase.suggest != null && !fetchResults.isEmpty()) {
                SearchPhaseController.mergeSuggest(reducedQueryPhase, fetchResultsArray, hits, sortedDocs);
            }
            SearchResponseSections searchResponseSections = reducedQueryPhase.buildResponse(hits, fetchResults);
            return searchResponseSections;
        }
        finally {
            hits.decRef();
        }
    }

    private static void mergeSuggest(ReducedQueryPhase reducedQueryPhase, AtomicArray<? extends SearchPhaseResult> fetchResultsArray, SearchHits hits, ScoreDoc[] sortedDocs) {
        int currentOffset = hits.getHits().length;
        for (CompletionSuggestion suggestion : reducedQueryPhase.suggest.filter(CompletionSuggestion.class)) {
            List<CompletionSuggestion.Entry.Option> suggestionOptions = suggestion.getOptions();
            for (int scoreDocIndex = currentOffset; scoreDocIndex < currentOffset + suggestionOptions.size(); ++scoreDocIndex) {
                ScoreDoc shardDoc = sortedDocs[scoreDocIndex];
                SearchPhaseResult searchResultProvider = fetchResultsArray.get(shardDoc.shardIndex);
                if (searchResultProvider == null) continue;
                FetchSearchResult fetchResult = searchResultProvider.fetchResult();
                int index = fetchResult.counterGetAndIncrement();
                assert (index < fetchResult.hits().getHits().length) : "not enough hits fetched. index [" + index + "] length: " + fetchResult.hits().getHits().length;
                SearchHit hit = fetchResult.hits().getHits()[index];
                CompletionSuggestion.Entry.Option suggestOption = suggestionOptions.get(scoreDocIndex - currentOffset);
                hit.score(shardDoc.score);
                hit.shard(fetchResult.getSearchShardTarget());
                suggestOption.setHit(hit);
            }
            currentOffset += suggestionOptions.size();
        }
        assert (currentOffset == sortedDocs.length) : "expected no more score doc slices";
    }

    private static SearchHits getHits(ReducedQueryPhase reducedQueryPhase, boolean ignoreFrom, AtomicArray<? extends SearchPhaseResult> fetchResultsArray) {
        SortedTopDocs sortedTopDocs = reducedQueryPhase.sortedTopDocs;
        int sortScoreIndex = -1;
        if (sortedTopDocs.isSortedByField) {
            SortField[] sortFields = sortedTopDocs.sortFields;
            for (int i = 0; i < sortFields.length; ++i) {
                if (sortFields[i].getType() != SortField.Type.SCORE) continue;
                sortScoreIndex = i;
            }
        }
        List<? extends SearchPhaseResult> fetchResults = fetchResultsArray.asList();
        for (SearchPhaseResult searchPhaseResult : fetchResults) {
            searchPhaseResult.fetchResult().initCounter();
        }
        int from = ignoreFrom ? 0 : reducedQueryPhase.from;
        int n2 = (int)Math.min(reducedQueryPhase.fetchHits - (long)from, (long)reducedQueryPhase.size);
        n2 = Math.min(sortedTopDocs.scoreDocs.length - sortedTopDocs.numberOfCompletionsSuggestions, n2);
        ArrayList<SearchHit> hits = new ArrayList<SearchHit>();
        if (!fetchResults.isEmpty()) {
            for (int i = 0; i < n2; ++i) {
                ScoreDoc shardDoc = sortedTopDocs.scoreDocs[i];
                SearchPhaseResult fetchResultProvider = fetchResultsArray.get(shardDoc.shardIndex);
                if (fetchResultProvider == null) continue;
                FetchSearchResult fetchResult = fetchResultProvider.fetchResult();
                int index = fetchResult.counterGetAndIncrement();
                assert (index < fetchResult.hits().getHits().length) : "not enough hits fetched. index [" + index + "] length: " + fetchResult.hits().getHits().length;
                SearchHit searchHit = fetchResult.hits().getHits()[index];
                searchHit.shard(fetchResult.getSearchShardTarget());
                if (reducedQueryPhase.rankCoordinatorContext != null) {
                    assert (shardDoc instanceof RankDoc);
                    searchHit.setRank(((RankDoc)shardDoc).rank);
                } else if (sortedTopDocs.isSortedByField) {
                    FieldDoc fieldDoc = (FieldDoc)shardDoc;
                    searchHit.sortValues(fieldDoc.fields, reducedQueryPhase.sortValueFormats);
                    if (sortScoreIndex != -1) {
                        searchHit.score(((Number)fieldDoc.fields[sortScoreIndex]).floatValue());
                    }
                } else {
                    searchHit.score(shardDoc.score);
                }
                hits.add(searchHit);
                searchHit.incRef();
            }
        }
        return new SearchHits(hits.toArray(SearchHits.EMPTY), reducedQueryPhase.totalHits, reducedQueryPhase.maxScore, sortedTopDocs.sortFields, sortedTopDocs.collapseField, sortedTopDocs.collapseValues);
    }

    static ReducedQueryPhase reducedScrollQueryPhase(Collection<? extends SearchPhaseResult> queryResults) {
        AggregationReduceContext.Builder aggReduceContextBuilder = new AggregationReduceContext.Builder(){

            @Override
            public AggregationReduceContext forPartialReduction() {
                throw new UnsupportedOperationException("Scroll requests don't have aggs");
            }

            @Override
            public AggregationReduceContext forFinalReduction() {
                throw new UnsupportedOperationException("Scroll requests don't have aggs");
            }
        };
        TopDocsStats topDocsStats = new TopDocsStats(Integer.MAX_VALUE);
        ArrayList<TopDocs> topDocs = new ArrayList<TopDocs>();
        for (SearchPhaseResult searchPhaseResult : queryResults) {
            QuerySearchResult queryResult = searchPhaseResult.queryResult();
            TopDocsAndMaxScore td = queryResult.consumeTopDocs();
            assert (td != null);
            topDocsStats.add(td, queryResult.searchTimedOut(), queryResult.terminatedEarly());
            if (td.topDocs.scoreDocs.length <= 0) continue;
            SearchPhaseController.setShardIndex(td.topDocs, queryResult.getShardIndex());
            topDocs.add(td.topDocs);
        }
        return SearchPhaseController.reducedQueryPhase(queryResults, Collections.emptyList(), topDocs, topDocsStats, 0, true, aggReduceContextBuilder, null, true);
    }

    /*
     * WARNING - void declaration
     */
    static ReducedQueryPhase reducedQueryPhase(Collection<? extends SearchPhaseResult> queryResults, List<DelayableWriteable<InternalAggregations>> bufferedAggs, List<TopDocs> bufferedTopDocs, TopDocsStats topDocsStats, int numReducePhases, boolean isScrollRequest, AggregationReduceContext.Builder aggReduceContextBuilder, RankCoordinatorContext rankCoordinatorContext, boolean performFinalReduce) {
        void var19_25;
        SortedTopDocs sortedTopDocs;
        Suggest reducedSuggest;
        assert (numReducePhases >= 0) : "num reduce phases must be >= 0 but was: " + numReducePhases;
        ++numReducePhases;
        if (queryResults.isEmpty()) {
            TotalHits totalHits = topDocsStats.getTotalHits();
            return new ReducedQueryPhase(totalHits, topDocsStats.fetchHits, topDocsStats.getMaxScore(), false, null, null, null, null, SortedTopDocs.EMPTY, null, null, numReducePhases, 0, 0, true);
        }
        int total = queryResults.size();
        ArrayList<? extends SearchPhaseResult> nonNullResults = new ArrayList<SearchPhaseResult>();
        boolean hasSuggest = false;
        boolean hasProfileResults = false;
        for (SearchPhaseResult searchPhaseResult : queryResults) {
            QuerySearchResult res = searchPhaseResult.queryResult();
            if (res.isNull()) continue;
            hasSuggest |= res.suggest() != null;
            hasProfileResults |= res.hasProfileResults();
            nonNullResults.add(searchPhaseResult);
        }
        queryResults = nonNullResults;
        SearchPhaseController.validateMergeSortValueFormats(queryResults);
        if (queryResults.isEmpty()) {
            IllegalStateException ex = new IllegalStateException("must have at least one non-empty search result, got 0 out of " + total);
            assert (false) : ex;
            throw ex;
        }
        HashMap groupedSuggestions = hasSuggest ? new HashMap() : Collections.emptyMap();
        Map<String, SearchProfileQueryPhaseResult> map = hasProfileResults ? Maps.newMapWithExpectedSize(queryResults.size()) : Collections.emptyMap();
        int from = 0;
        int size = 0;
        DocValueFormat[] sortValueFormats = null;
        for (SearchPhaseResult searchPhaseResult : queryResults) {
            QuerySearchResult result = searchPhaseResult.queryResult();
            from = result.from();
            size = Math.max(result.size(), size);
            if (result.sortValueFormats() != null) {
                sortValueFormats = result.sortValueFormats();
            }
            if (hasSuggest) {
                assert (result.suggest() != null);
                for (Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> suggestion : result.suggest()) {
                    List suggestionList = groupedSuggestions.computeIfAbsent(suggestion.getName(), s -> new ArrayList());
                    suggestionList.add(suggestion);
                    if (!(suggestion instanceof CompletionSuggestion)) continue;
                    CompletionSuggestion completionSuggestion = (CompletionSuggestion)suggestion;
                    completionSuggestion.setShardIndex(result.getShardIndex());
                }
            }
            assert (bufferedTopDocs.isEmpty() || result.hasConsumedTopDocs()) : "firstResult has no aggs but we got non null buffered aggs?";
            if (!hasProfileResults) continue;
            String key = result.getSearchShardTarget().toString();
            map.put(key, result.consumeProfileResult());
        }
        if (groupedSuggestions.isEmpty()) {
            reducedSuggest = null;
            List list = Collections.emptyList();
        } else {
            reducedSuggest = new Suggest(Suggest.reduce(groupedSuggestions));
            List<CompletionSuggestion> list = reducedSuggest.filter(CompletionSuggestion.class);
        }
        InternalAggregations aggregations = SearchPhaseController.reduceAggs(aggReduceContextBuilder, performFinalReduce, bufferedAggs);
        SearchProfileResultsBuilder profileBuilder = map.isEmpty() ? null : new SearchProfileResultsBuilder(map);
        SortedTopDocs sortedTopDocs2 = sortedTopDocs = rankCoordinatorContext == null ? SearchPhaseController.sortDocs(isScrollRequest, bufferedTopDocs, from, size, (List<CompletionSuggestion>)var19_25) : rankCoordinatorContext.rank(queryResults.stream().map(SearchPhaseResult::queryResult).toList(), topDocsStats);
        if (rankCoordinatorContext != null) {
            size = sortedTopDocs.scoreDocs.length;
        }
        TotalHits totalHits = topDocsStats.getTotalHits();
        return new ReducedQueryPhase(totalHits, topDocsStats.fetchHits, topDocsStats.getMaxScore(), topDocsStats.timedOut, topDocsStats.terminatedEarly, reducedSuggest, aggregations, profileBuilder, sortedTopDocs, sortValueFormats, rankCoordinatorContext, numReducePhases, size, from, false);
    }

    private static InternalAggregations reduceAggs(AggregationReduceContext.Builder aggReduceContextBuilder, boolean performFinalReduce, List<DelayableWriteable<InternalAggregations>> toReduce) {
        return toReduce.isEmpty() ? null : InternalAggregations.topLevelReduceDelayable(toReduce, performFinalReduce ? aggReduceContextBuilder.forFinalReduction() : aggReduceContextBuilder.forPartialReduction());
    }

    private static void validateMergeSortValueFormats(Collection<? extends SearchPhaseResult> queryResults) {
        boolean[] ulFormats = null;
        boolean firstResult = true;
        for (SearchPhaseResult searchPhaseResult : queryResults) {
            int i;
            DocValueFormat[] formats = searchPhaseResult.queryResult().sortValueFormats();
            if (formats == null) {
                return;
            }
            if (firstResult) {
                firstResult = false;
                ulFormats = new boolean[formats.length];
                for (i = 0; i < formats.length; ++i) {
                    ulFormats[i] = formats[i] == DocValueFormat.UNSIGNED_LONG_SHIFTED;
                }
                continue;
            }
            for (i = 0; i < formats.length; ++i) {
                if (!(ulFormats[i] ^ formats[i] == DocValueFormat.UNSIGNED_LONG_SHIFTED)) continue;
                throw new IllegalArgumentException("Can't do sort across indices, as a field has [unsigned_long] type in one index, and different type in another index!");
            }
        }
    }

    static int getTopDocsSize(SearchRequest request) {
        if (request.source() == null) {
            return 10;
        }
        SearchSourceBuilder source = request.source();
        return (source.size() == -1 ? 10 : source.size()) + (source.from() == -1 ? 0 : source.from());
    }

    AggregationReduceContext.Builder getReduceContext(Supplier<Boolean> isCanceled, AggregatorFactories.Builder aggs) {
        return this.requestToAggReduceContextBuilder.apply(isCanceled, aggs);
    }

    SearchPhaseResults<SearchPhaseResult> newSearchPhaseResults(Executor executor, CircuitBreaker circuitBreaker, Supplier<Boolean> isCanceled, SearchProgressListener listener, SearchRequest request, int numShards, Consumer<Exception> onPartialMergeFailure) {
        int size;
        int n = size = request.source() == null || request.source().size() == -1 ? 10 : request.source().size();
        if (size == 0 && (request.source() == null || request.source().aggregations() == null && request.source().suggest() == null && request.source().rankBuilder() == null && request.source().knnSearch().isEmpty() && !request.source().profile()) && request.resolveTrackTotalHitsUpTo() == Integer.MAX_VALUE) {
            return new CountOnlyQueryPhaseResultConsumer(listener, numShards);
        }
        return new QueryPhaseResultConsumer(request, executor, circuitBreaker, this, isCanceled, listener, numShards, onPartialMergeFailure);
    }

    public record SortedTopDocs(ScoreDoc[] scoreDocs, boolean isSortedByField, SortField[] sortFields, String collapseField, Object[] collapseValues, int numberOfCompletionsSuggestions) {
        public static final SortedTopDocs EMPTY = new SortedTopDocs(EMPTY_DOCS, false, null, null, null, 0);
    }

    public record ReducedQueryPhase(TotalHits totalHits, long fetchHits, float maxScore, boolean timedOut, Boolean terminatedEarly, Suggest suggest, InternalAggregations aggregations, SearchProfileResultsBuilder profileBuilder, SortedTopDocs sortedTopDocs, DocValueFormat[] sortValueFormats, RankCoordinatorContext rankCoordinatorContext, int numReducePhases, int size, int from, boolean isEmptyResult) {
        public ReducedQueryPhase {
            if (numReducePhases <= 0) {
                throw new IllegalArgumentException("at least one reduce phase must have been applied but was: " + numReducePhases);
            }
        }

        public SearchResponseSections buildResponse(SearchHits hits, Collection<? extends SearchPhaseResult> fetchResults) {
            return new SearchResponseSections(hits, this.aggregations, this.suggest, this.timedOut, this.terminatedEarly, this.buildSearchProfileResults(fetchResults), this.numReducePhases);
        }

        private SearchProfileResults buildSearchProfileResults(Collection<? extends SearchPhaseResult> fetchResults) {
            if (this.profileBuilder == null) {
                assert (fetchResults.stream().map(SearchPhaseResult::fetchResult).allMatch(r -> r == null || r.profileResult() == null)) : "found fetch profile without search profile";
                return null;
            }
            return this.profileBuilder.build(fetchResults);
        }
    }

    public static final class TopDocsStats {
        final int trackTotalHitsUpTo;
        long totalHits;
        private TotalHits.Relation totalHitsRelation;
        public long fetchHits;
        private float maxScore = Float.NEGATIVE_INFINITY;
        public boolean timedOut;
        public Boolean terminatedEarly;

        public TopDocsStats(int trackTotalHitsUpTo) {
            this.trackTotalHitsUpTo = trackTotalHitsUpTo;
            this.totalHits = 0L;
            this.totalHitsRelation = TotalHits.Relation.EQUAL_TO;
        }

        float getMaxScore() {
            return Float.isInfinite(this.maxScore) ? Float.NaN : this.maxScore;
        }

        TotalHits getTotalHits() {
            if (this.trackTotalHitsUpTo == -1) {
                return null;
            }
            if (this.trackTotalHitsUpTo == Integer.MAX_VALUE) {
                assert (this.totalHitsRelation == TotalHits.Relation.EQUAL_TO);
                return new TotalHits(this.totalHits, this.totalHitsRelation);
            }
            if (this.totalHits <= (long)this.trackTotalHitsUpTo) {
                return new TotalHits(this.totalHits, this.totalHitsRelation);
            }
            return new TotalHits((long)this.trackTotalHitsUpTo, TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO);
        }

        void add(TopDocsAndMaxScore topDocs, boolean timedOut, Boolean terminatedEarly) {
            if (this.trackTotalHitsUpTo != -1) {
                this.totalHits += topDocs.topDocs.totalHits.value;
                if (topDocs.topDocs.totalHits.relation == TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO) {
                    this.totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
                }
            }
            this.fetchHits += (long)topDocs.topDocs.scoreDocs.length;
            if (!Float.isNaN(topDocs.maxScore)) {
                this.maxScore = Math.max(this.maxScore, topDocs.maxScore);
            }
            if (timedOut) {
                this.timedOut = true;
            }
            if (terminatedEarly != null) {
                if (this.terminatedEarly == null) {
                    this.terminatedEarly = terminatedEarly;
                } else if (terminatedEarly.booleanValue()) {
                    this.terminatedEarly = true;
                }
            }
        }
    }
}

