/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.util.Strings;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchPhase;
import org.elasticsearch.action.search.SearchPhaseContext;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponseSections;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.fetch.subphase.LookupField;

final class FetchLookupFieldsPhase
extends SearchPhase {
    private final SearchPhaseContext context;
    private final SearchResponseSections searchResponse;
    private final AtomicArray<SearchPhaseResult> queryResults;

    FetchLookupFieldsPhase(SearchPhaseContext context, SearchResponseSections searchResponse, AtomicArray<SearchPhaseResult> queryResults) {
        super("fetch_lookup_fields");
        this.context = context;
        this.searchResponse = searchResponse;
        this.queryResults = queryResults;
    }

    private static List<Cluster> groupLookupFieldsByClusterAlias(SearchHits searchHits) {
        HashMap<String, List> perClusters = new HashMap<String, List>();
        for (SearchHit hit : searchHits.getHits()) {
            String clusterAlias;
            String string = clusterAlias = hit.getClusterAlias() != null ? hit.getClusterAlias() : "";
            if (!hit.hasLookupFields()) continue;
            perClusters.computeIfAbsent(clusterAlias, k -> new ArrayList()).add(hit);
        }
        ArrayList<Cluster> clusters = new ArrayList<Cluster>(perClusters.size());
        for (Map.Entry e : perClusters.entrySet()) {
            List<LookupField> lookupFields = ((List)e.getValue()).stream().flatMap(h -> h.getDocumentFields().values().stream()).flatMap(doc -> doc.getLookupFields().stream()).distinct().toList();
            clusters.add(new Cluster((String)e.getKey(), (List)e.getValue(), lookupFields));
        }
        return clusters;
    }

    public void run() {
        List<Cluster> clusters = FetchLookupFieldsPhase.groupLookupFieldsByClusterAlias(this.searchResponse.hits);
        if (clusters.isEmpty()) {
            this.context.sendSearchResponse(this.searchResponse, this.queryResults);
            return;
        }
        this.doRun(clusters);
    }

    private void doRun(final List<Cluster> clusters) {
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        for (Cluster cluster : clusters) {
            String clusterAlias;
            String string = clusterAlias = this.context.getRequest().getLocalClusterAlias() == null ? cluster.clusterAlias : null;
            assert (Strings.isEmpty((CharSequence)clusterAlias) || !TransportSearchAction.shouldMinimizeRoundtrips(this.context.getRequest())) : "lookup across clusters only if [ccs_minimize_roundtrips] is disabled";
            for (LookupField lookupField : cluster.lookupFields) {
                SearchRequest searchRequest = lookupField.toSearchRequest(clusterAlias);
                searchRequest.setCcsMinimizeRoundtrips(this.context.getRequest().isCcsMinimizeRoundtrips());
                multiSearchRequest.add(searchRequest);
            }
        }
        this.context.getSearchTransport().sendExecuteMultiSearch(multiSearchRequest, this.context.getTask(), new ActionListener<MultiSearchResponse>(){

            @Override
            public void onResponse(MultiSearchResponse items) {
                Exception failure = null;
                int index = 0;
                for (Cluster cluster : clusters) {
                    Map<LookupField, List<Object>> lookupResults = Maps.newMapWithExpectedSize(cluster.lookupFields.size());
                    for (LookupField lookupField : cluster.lookupFields) {
                        MultiSearchResponse.Item item = items.getResponses()[index];
                        if (item.isFailure()) {
                            failure = ExceptionsHelper.useOrSuppress(failure, item.getFailure());
                        } else if (failure == null) {
                            ArrayList<Map<String, List>> fetchedValues = new ArrayList<Map<String, List>>();
                            for (SearchHit rightHit : item.getResponse().getHits()) {
                                Map<String, List> fetchedFields = rightHit.getDocumentFields().values().stream().collect(Collectors.toMap(DocumentField::getName, DocumentField::getValues));
                                if (fetchedFields.isEmpty()) continue;
                                fetchedValues.add(fetchedFields);
                            }
                            lookupResults.put(lookupField, fetchedValues);
                        }
                        ++index;
                    }
                    if (failure != null) continue;
                    for (SearchHit hit : cluster.hitsWithLookupFields) {
                        hit.resolveLookupFields(lookupResults);
                    }
                }
                if (failure != null) {
                    FetchLookupFieldsPhase.this.context.onPhaseFailure(FetchLookupFieldsPhase.this, "failed to fetch lookup fields", failure);
                } else {
                    FetchLookupFieldsPhase.this.context.sendSearchResponse(FetchLookupFieldsPhase.this.searchResponse, FetchLookupFieldsPhase.this.queryResults);
                }
            }

            @Override
            public void onFailure(Exception e) {
                FetchLookupFieldsPhase.this.context.onPhaseFailure(FetchLookupFieldsPhase.this, "failed to fetch lookup fields", e);
            }
        });
    }

    private record Cluster(String clusterAlias, List<SearchHit> hitsWithLookupFields, List<LookupField> lookupFields) {
    }
}

