/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.fieldcaps.IndexFieldCapabilities;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Nullable;

public final class FieldCapabilitiesIndexResponse
implements Writeable {
    private static final TransportVersion MAPPING_HASH_VERSION = TransportVersions.V_8_2_0;
    private final String indexName;
    @Nullable
    private final String indexMappingHash;
    private final Map<String, IndexFieldCapabilities> responseMap;
    private final boolean canMatch;
    private final transient TransportVersion originVersion;

    public FieldCapabilitiesIndexResponse(String indexName, @Nullable String indexMappingHash, Map<String, IndexFieldCapabilities> responseMap, boolean canMatch) {
        this.indexName = indexName;
        this.indexMappingHash = indexMappingHash;
        this.responseMap = responseMap;
        this.canMatch = canMatch;
        this.originVersion = TransportVersion.current();
    }

    FieldCapabilitiesIndexResponse(StreamInput in) throws IOException {
        this.indexName = in.readString();
        this.responseMap = in.readMap(IndexFieldCapabilities::readFrom);
        this.canMatch = in.readBoolean();
        this.originVersion = in.getTransportVersion();
        this.indexMappingHash = in.getTransportVersion().onOrAfter(MAPPING_HASH_VERSION) ? in.readOptionalString() : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.indexName);
        out.writeMap(this.responseMap, StreamOutput::writeWriteable);
        out.writeBoolean(this.canMatch);
        if (out.getTransportVersion().onOrAfter(MAPPING_HASH_VERSION)) {
            out.writeOptionalString(this.indexMappingHash);
        }
    }

    static List<FieldCapabilitiesIndexResponse> readList(StreamInput input) throws IOException {
        if (input.getTransportVersion().before(MAPPING_HASH_VERSION)) {
            return input.readCollectionAsList(FieldCapabilitiesIndexResponse::new);
        }
        int ungrouped = input.readVInt();
        ArrayList<FieldCapabilitiesIndexResponse> responses = new ArrayList<FieldCapabilitiesIndexResponse>(ungrouped);
        for (int i = 0; i < ungrouped; ++i) {
            responses.add(new FieldCapabilitiesIndexResponse(input));
        }
        int groups = input.readVInt();
        if (input.getTransportVersion().onOrAfter(TransportVersions.V_8_11_X)) {
            FieldCapabilitiesIndexResponse.collectCompressedResponses(input, groups, responses);
        } else {
            FieldCapabilitiesIndexResponse.collectResponsesLegacyFormat(input, groups, responses);
        }
        return responses;
    }

    private static void collectCompressedResponses(StreamInput input, int groups, ArrayList<FieldCapabilitiesIndexResponse> responses) throws IOException {
        CompressedGroup[] compressedGroups = new CompressedGroup[groups];
        for (int i = 0; i < groups; ++i) {
            String[] indices = input.readStringArray();
            String mappingHash = input.readString();
            compressedGroups[i] = new CompressedGroup(indices, mappingHash, input.readIntArray());
        }
        IndexFieldCapabilities[] ifcLookup = input.readArray(IndexFieldCapabilities::readFrom, IndexFieldCapabilities[]::new);
        for (CompressedGroup compressedGroup : compressedGroups) {
            Map<String, IndexFieldCapabilities> ifc = Maps.newMapWithExpectedSize(compressedGroup.fields.length);
            for (int i : compressedGroup.fields) {
                IndexFieldCapabilities val = ifcLookup[i];
                ifc.put(val.name(), val);
            }
            for (String index : compressedGroup.indices) {
                responses.add(new FieldCapabilitiesIndexResponse(index, compressedGroup.mappingHash, ifc, true));
            }
        }
    }

    private static void collectResponsesLegacyFormat(StreamInput input, int groups, ArrayList<FieldCapabilitiesIndexResponse> responses) throws IOException {
        for (int i = 0; i < groups; ++i) {
            List<String> indices = input.readStringCollectionAsList();
            String mappingHash = input.readString();
            Map<String, IndexFieldCapabilities> ifc = input.readMap(IndexFieldCapabilities::readFrom);
            for (String index : indices) {
                responses.add(new FieldCapabilitiesIndexResponse(index, mappingHash, ifc, true));
            }
        }
    }

    static void writeList(StreamOutput output, List<FieldCapabilitiesIndexResponse> responses) throws IOException {
        if (output.getTransportVersion().before(MAPPING_HASH_VERSION)) {
            output.writeCollection(responses);
            return;
        }
        HashMap<String, List<FieldCapabilitiesIndexResponse>> groupedResponsesMap = new HashMap<String, List<FieldCapabilitiesIndexResponse>>();
        ArrayList<FieldCapabilitiesIndexResponse> ungroupedResponses = new ArrayList<FieldCapabilitiesIndexResponse>();
        for (FieldCapabilitiesIndexResponse r : responses) {
            if (r.canMatch && r.indexMappingHash != null) {
                groupedResponsesMap.computeIfAbsent(r.indexMappingHash, k -> new ArrayList()).add(r);
                continue;
            }
            ungroupedResponses.add(r);
        }
        output.writeCollection(ungroupedResponses);
        if (output.getTransportVersion().onOrAfter(TransportVersions.V_8_11_X)) {
            FieldCapabilitiesIndexResponse.writeCompressedResponses(output, groupedResponsesMap);
        } else {
            FieldCapabilitiesIndexResponse.writeResponsesLegacyFormat(output, groupedResponsesMap);
        }
    }

    private static void writeResponsesLegacyFormat(StreamOutput output, Map<String, List<FieldCapabilitiesIndexResponse>> groupedResponsesMap) throws IOException {
        output.writeCollection(groupedResponsesMap.values(), (o, fieldCapabilitiesIndexResponses) -> {
            o.writeCollection(fieldCapabilitiesIndexResponses, (oo, r) -> oo.writeString(r.indexName));
            FieldCapabilitiesIndexResponse first = (FieldCapabilitiesIndexResponse)fieldCapabilitiesIndexResponses.get(0);
            o.writeString(first.indexMappingHash);
            o.writeMap(first.responseMap, StreamOutput::writeWriteable);
        });
    }

    private static void writeCompressedResponses(StreamOutput output, Map<String, List<FieldCapabilitiesIndexResponse>> groupedResponsesMap) throws IOException {
        LinkedHashMap fieldDedupMap = new LinkedHashMap();
        output.writeCollection(groupedResponsesMap.values(), (o, fieldCapabilitiesIndexResponses) -> {
            o.writeCollection(fieldCapabilitiesIndexResponses, (oo, r) -> oo.writeString(r.indexName));
            FieldCapabilitiesIndexResponse first = (FieldCapabilitiesIndexResponse)fieldCapabilitiesIndexResponses.get(0);
            o.writeString(first.indexMappingHash);
            o.writeVInt(first.responseMap.size());
            for (IndexFieldCapabilities ifc : first.responseMap.values()) {
                Integer offset;
                Integer found = fieldDedupMap.putIfAbsent(ifc, offset = Integer.valueOf(fieldDedupMap.size()));
                o.writeInt(found == null ? offset : found);
            }
        });
        output.writeCollection(fieldDedupMap.keySet());
    }

    public String getIndexName() {
        return this.indexName;
    }

    @Nullable
    public String getIndexMappingHash() {
        return this.indexMappingHash;
    }

    public boolean canMatch() {
        return this.canMatch;
    }

    public Map<String, IndexFieldCapabilities> get() {
        return this.responseMap;
    }

    TransportVersion getOriginVersion() {
        return this.originVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldCapabilitiesIndexResponse that = (FieldCapabilitiesIndexResponse)o;
        return this.canMatch == that.canMatch && Objects.equals(this.indexName, that.indexName) && Objects.equals(this.indexMappingHash, that.indexMappingHash) && Objects.equals(this.responseMap, that.responseMap);
    }

    public int hashCode() {
        return Objects.hash(this.indexName, this.indexMappingHash, this.responseMap, this.canMatch);
    }

    private record CompressedGroup(String[] indices, String mappingHash, int[] fields) {
    }
}

