/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.put;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public class PutIndexTemplateRequest
extends MasterNodeRequest<PutIndexTemplateRequest>
implements IndicesRequest {
    private String name;
    private String cause = "";
    private List<String> indexPatterns;
    private int order;
    private boolean create;
    private Settings settings = Settings.EMPTY;
    @Nullable
    private String mappings;
    private final Set<Alias> aliases = new HashSet<Alias>();
    private Integer version;

    public PutIndexTemplateRequest(StreamInput in) throws IOException {
        super(in);
        int i;
        this.cause = in.readString();
        this.name = in.readString();
        this.indexPatterns = in.readStringCollectionAsList();
        this.order = in.readInt();
        this.create = in.readBoolean();
        this.settings = Settings.readSettingsFromStream(in);
        if (in.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            int size = in.readVInt();
            for (i = 0; i < size; ++i) {
                in.readString();
                this.mappings = in.readString();
            }
        } else {
            this.mappings = in.readOptionalString();
        }
        int aliasesSize = in.readVInt();
        for (i = 0; i < aliasesSize; ++i) {
            this.aliases.add(new Alias(in));
        }
        this.version = in.readOptionalVInt();
    }

    public PutIndexTemplateRequest() {
    }

    public PutIndexTemplateRequest(String name) {
        this.name = name;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.name == null) {
            validationException = ValidateActions.addValidationError("name is missing", validationException);
        }
        if (this.indexPatterns == null || this.indexPatterns.size() == 0) {
            validationException = ValidateActions.addValidationError("index patterns are missing", validationException);
        }
        return validationException;
    }

    public PutIndexTemplateRequest name(String name) {
        this.name = name;
        return this;
    }

    public String name() {
        return this.name;
    }

    public PutIndexTemplateRequest patterns(List<String> indexPatterns) {
        this.indexPatterns = indexPatterns;
        return this;
    }

    public List<String> patterns() {
        return this.indexPatterns;
    }

    public PutIndexTemplateRequest order(int order) {
        this.order = order;
        return this;
    }

    public int order() {
        return this.order;
    }

    public PutIndexTemplateRequest version(Integer version) {
        this.version = version;
        return this;
    }

    public Integer version() {
        return this.version;
    }

    public PutIndexTemplateRequest create(boolean create) {
        this.create = create;
        return this;
    }

    public boolean create() {
        return this.create;
    }

    public PutIndexTemplateRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public PutIndexTemplateRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public PutIndexTemplateRequest settings(String source, XContentType xContentType) {
        this.settings = Settings.builder().loadFromSource(source, xContentType).build();
        return this;
    }

    public PutIndexTemplateRequest settings(Map<String, Object> source) {
        this.settings = Settings.builder().loadFromMap(source).build();
        return this;
    }

    public Settings settings() {
        return this.settings;
    }

    public PutIndexTemplateRequest cause(String cause) {
        this.cause = cause;
        return this;
    }

    public String cause() {
        return this.cause;
    }

    public PutIndexTemplateRequest mapping(String source, XContentType xContentType) {
        return this.mapping(new BytesArray(source), xContentType);
    }

    public PutIndexTemplateRequest mapping(XContentBuilder source) {
        return this.mapping(BytesReference.bytes(source), source.contentType());
    }

    public PutIndexTemplateRequest mapping(BytesReference source, XContentType xContentType) {
        Objects.requireNonNull(xContentType);
        Map mappingAsMap = (Map)XContentHelper.convertToMap(source, false, xContentType).v2();
        return this.mapping(mappingAsMap);
    }

    public PutIndexTemplateRequest mapping(Map<String, Object> source) {
        if (source.size() != 1 || !source.containsKey("_doc")) {
            source = Map.of("_doc", source);
        }
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.map(source);
            this.mappings = Strings.toString(builder);
            return this;
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public PutIndexTemplateRequest mapping(String ... source) {
        this.mapping(PutMappingRequest.simpleMapping(source));
        return this;
    }

    public String mappings() {
        return this.mappings;
    }

    public PutIndexTemplateRequest source(XContentBuilder templateBuilder) {
        try {
            return this.source(BytesReference.bytes(templateBuilder), templateBuilder.contentType());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to build json for template request", e);
        }
    }

    public PutIndexTemplateRequest source(Map<String, Object> templateSource) {
        Map<String, Object> source = templateSource;
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String name = entry.getKey();
            if (name.equals("index_patterns")) {
                if (entry.getValue() instanceof String) {
                    this.patterns(Collections.singletonList((String)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    List<String> elements = ((List)entry.getValue()).stream().map(Object::toString).toList();
                    this.patterns(elements);
                    continue;
                }
                throw new IllegalArgumentException("Malformed [index_patterns] value, should be a string or a list of strings");
            }
            if (name.equals("order")) {
                this.order(XContentMapValues.nodeIntegerValue(entry.getValue(), this.order()));
                continue;
            }
            if ("version".equals(name)) {
                if (!(entry.getValue() instanceof Integer)) {
                    throw new IllegalArgumentException("Malformed [version] value, should be an integer");
                }
                this.version((Integer)entry.getValue());
                continue;
            }
            if (name.equals("settings")) {
                if (!(entry.getValue() instanceof Map)) {
                    throw new IllegalArgumentException("Malformed [settings] section, should include an inner object");
                }
                this.settings((Map)entry.getValue());
                continue;
            }
            if (name.equals("mappings")) {
                Map mappings = (Map)entry.getValue();
                for (Map.Entry entry1 : mappings.entrySet()) {
                    if (!(entry1.getValue() instanceof Map)) {
                        throw new IllegalArgumentException("Malformed [mappings] section for type [" + (String)entry1.getKey() + "], should include an inner object describing the mapping");
                    }
                    this.mapping((Map)entry1.getValue());
                }
                continue;
            }
            if (name.equals("aliases")) {
                this.aliases((Map)entry.getValue());
                continue;
            }
            throw new ElasticsearchParseException("unknown key [{}] in the template ", name);
        }
        return this;
    }

    public PutIndexTemplateRequest source(String templateSource, XContentType xContentType) {
        return this.source(XContentHelper.convertToMap(xContentType.xContent(), templateSource, true));
    }

    public PutIndexTemplateRequest source(byte[] source, XContentType xContentType) {
        return this.source(source, 0, source.length, xContentType);
    }

    public PutIndexTemplateRequest source(byte[] source, int offset, int length, XContentType xContentType) {
        return this.source(new BytesArray(source, offset, length), xContentType);
    }

    public PutIndexTemplateRequest source(BytesReference source, XContentType xContentType) {
        return this.source((Map)XContentHelper.convertToMap(source, true, xContentType).v2());
    }

    public Set<Alias> aliases() {
        return this.aliases;
    }

    public PutIndexTemplateRequest aliases(Map<String, ?> source) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.map(source);
            return this.aliases(BytesReference.bytes(builder));
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public PutIndexTemplateRequest aliases(XContentBuilder source) {
        return this.aliases(BytesReference.bytes(source));
    }

    public PutIndexTemplateRequest aliases(String source) {
        return this.aliases(new BytesArray(source));
    }

    public PutIndexTemplateRequest aliases(BytesReference source) {
        PutIndexTemplateRequest putIndexTemplateRequest;
        block9: {
            XContentParser parser = XContentHelper.createParser(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, source);
            try {
                parser.nextToken();
                while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    this.alias(Alias.fromXContent(parser));
                }
                putIndexTemplateRequest = this;
                if (parser == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse aliases", (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return putIndexTemplateRequest;
    }

    public PutIndexTemplateRequest alias(Alias alias) {
        this.aliases.add(alias);
        return this;
    }

    @Override
    public String[] indices() {
        return this.indexPatterns.toArray(new String[this.indexPatterns.size()]);
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictExpand();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.cause);
        out.writeString(this.name);
        out.writeStringCollection(this.indexPatterns);
        out.writeInt(this.order);
        out.writeBoolean(this.create);
        this.settings.writeTo(out);
        if (out.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            out.writeVInt(this.mappings == null ? 0 : 1);
            if (this.mappings != null) {
                out.writeString("_doc");
                out.writeString(this.mappings);
            }
        } else {
            out.writeOptionalString(this.mappings);
        }
        out.writeCollection(this.aliases);
        out.writeOptionalVInt(this.version);
    }
}

