/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.rollover;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.rollover.MetadataRolloverService;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverResponse;
import org.elasticsearch.action.admin.indices.rollover.TransportRolloverAction;
import org.elasticsearch.action.datastreams.autosharding.DataStreamAutoShardingService;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataDataStreamsService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public final class LazyRolloverAction
extends ActionType<RolloverResponse> {
    public static final NodeFeature DATA_STREAM_LAZY_ROLLOVER = new NodeFeature("data_stream.rollover.lazy");
    public static final LazyRolloverAction INSTANCE = new LazyRolloverAction();
    public static final String NAME = "indices:admin/data_stream/lazy_rollover";

    private LazyRolloverAction() {
        super(NAME);
    }

    @Override
    public String name() {
        return NAME;
    }

    public static final class TransportLazyRolloverAction
    extends TransportRolloverAction {
        @Inject
        public TransportLazyRolloverAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, MetadataRolloverService rolloverService, AllocationService allocationService, MetadataDataStreamsService metadataDataStreamsService, DataStreamAutoShardingService dataStreamAutoShardingService, Client client) {
            super(INSTANCE, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, rolloverService, client, allocationService, metadataDataStreamsService, dataStreamAutoShardingService);
        }

        @Override
        protected void masterOperation(Task task, RolloverRequest rolloverRequest, ClusterState clusterState, ActionListener<RolloverResponse> listener) throws Exception {
            assert (task instanceof CancellableTask);
            assert (!(rolloverRequest.getConditions().hasConditions() || rolloverRequest.isDryRun() || rolloverRequest.isLazy())) : "The auto rollover action does not expect any other parameters in the request apart from the data stream name";
            Metadata metadata = clusterState.metadata();
            MetadataRolloverService.NameResolution trialRolloverNames = MetadataRolloverService.resolveRolloverNames(clusterState, rolloverRequest.getRolloverTarget(), rolloverRequest.getNewIndexName(), rolloverRequest.getCreateIndexRequest(), false);
            String trialSourceIndexName = trialRolloverNames.sourceName();
            String trialRolloverIndexName = trialRolloverNames.rolloverName();
            MetadataRolloverService.validateIndexName(clusterState, trialRolloverIndexName);
            assert (metadata.dataStreams().containsKey(rolloverRequest.getRolloverTarget())) : "Auto-rollover applies only to data streams";
            RolloverResponse trialRolloverResponse = new RolloverResponse(trialSourceIndexName, trialRolloverIndexName, Map.of(), false, false, false, false, false);
            String source = "lazy_rollover source [" + trialRolloverIndexName + "] to target [" + trialRolloverIndexName + "]";
            TransportRolloverAction.RolloverTask rolloverTask = new TransportRolloverAction.RolloverTask(new RolloverRequest(rolloverRequest.getRolloverTarget(), null), null, trialRolloverResponse, null, listener);
            this.submitRolloverTask(rolloverRequest, source, rolloverTask);
        }
    }
}

