/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.state;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ClusterStateResponse
extends ActionResponse {
    private final ClusterName clusterName;
    private final ClusterState clusterState;
    private final boolean waitForTimedOut;

    public ClusterStateResponse(StreamInput in) throws IOException {
        super(in);
        this.clusterName = new ClusterName(in);
        this.clusterState = in.readOptionalWriteable(innerIn -> ClusterState.readFrom(innerIn, null));
        this.waitForTimedOut = in.readBoolean();
    }

    public ClusterStateResponse(ClusterName clusterName, ClusterState clusterState, boolean waitForTimedOut) {
        this.clusterName = clusterName;
        this.clusterState = clusterState;
        this.waitForTimedOut = waitForTimedOut;
    }

    public ClusterState getState() {
        return this.clusterState;
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public boolean isWaitForTimedOut() {
        return this.waitForTimedOut;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.clusterName.writeTo(out);
        out.writeOptionalWriteable(this.clusterState);
        out.writeBoolean(this.waitForTimedOut);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterStateResponse response = (ClusterStateResponse)o;
        return this.waitForTimedOut == response.waitForTimedOut && Objects.equals(this.clusterName, response.clusterName) && Objects.equals(ClusterStateResponse.getVersion(this.clusterState), ClusterStateResponse.getVersion(response.clusterState)) && Objects.equals(ClusterStateResponse.getMasterNodeId(this.clusterState), ClusterStateResponse.getMasterNodeId(response.clusterState));
    }

    public int hashCode() {
        return Objects.hash(this.clusterName, ClusterStateResponse.getVersion(this.clusterState), ClusterStateResponse.getMasterNodeId(this.clusterState), this.waitForTimedOut);
    }

    private static String getMasterNodeId(ClusterState clusterState) {
        if (clusterState == null) {
            return null;
        }
        DiscoveryNodes nodes = clusterState.getNodes();
        if (nodes != null) {
            return nodes.getMasterNodeId();
        }
        return null;
    }

    private static Long getVersion(ClusterState clusterState) {
        if (clusterState != null) {
            return clusterState.getVersion();
        }
        return null;
    }
}

