/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.hotthreads;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.monitor.jvm.HotThreads;

public class NodesHotThreadsRequest
extends BaseNodesRequest<NodesHotThreadsRequest> {
    int threads = 3;
    HotThreads.ReportType type = HotThreads.ReportType.CPU;
    HotThreads.SortOrder sortOrder = HotThreads.SortOrder.TOTAL;
    TimeValue interval = new TimeValue(500L, TimeUnit.MILLISECONDS);
    int snapshots = 10;
    boolean ignoreIdleThreads = true;

    public NodesHotThreadsRequest(StreamInput in) throws IOException {
        super(in);
        this.threads = in.readInt();
        this.ignoreIdleThreads = in.readBoolean();
        this.type = HotThreads.ReportType.of(in.readString());
        this.interval = in.readTimeValue();
        this.snapshots = in.readInt();
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_7_16_0)) {
            this.sortOrder = HotThreads.SortOrder.of(in.readString());
        }
    }

    public NodesHotThreadsRequest(String ... nodesIds) {
        super(nodesIds);
    }

    public NodesHotThreadsRequest(DiscoveryNode node) {
        super(node);
    }

    public int threads() {
        return this.threads;
    }

    public NodesHotThreadsRequest threads(int threads) {
        this.threads = threads;
        return this;
    }

    public boolean ignoreIdleThreads() {
        return this.ignoreIdleThreads;
    }

    public NodesHotThreadsRequest ignoreIdleThreads(boolean ignoreIdleThreads) {
        this.ignoreIdleThreads = ignoreIdleThreads;
        return this;
    }

    public NodesHotThreadsRequest type(HotThreads.ReportType type) {
        this.type = type;
        return this;
    }

    public HotThreads.ReportType type() {
        return this.type;
    }

    public NodesHotThreadsRequest sortOrder(HotThreads.SortOrder sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    public HotThreads.SortOrder sortOrder() {
        return this.sortOrder;
    }

    public NodesHotThreadsRequest interval(TimeValue interval) {
        this.interval = interval;
        return this;
    }

    public TimeValue interval() {
        return this.interval;
    }

    public int snapshots() {
        return this.snapshots;
    }

    public NodesHotThreadsRequest snapshots(int snapshots) {
        this.snapshots = snapshots;
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeInt(this.threads);
        out.writeBoolean(this.ignoreIdleThreads);
        out.writeString(this.type.getTypeValue());
        out.writeTimeValue(this.interval);
        out.writeInt(this.snapshots);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_7_16_0)) {
            out.writeString(this.sortOrder.getOrderValue());
        }
    }
}

