/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.desirednodes;

import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.desirednodes.GetDesiredNodesAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DesiredNodes;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetDesiredNodesAction
extends TransportMasterNodeReadAction<GetDesiredNodesAction.Request, GetDesiredNodesAction.Response> {
    @Inject
    public TransportGetDesiredNodesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/desired_nodes/get", transportService, clusterService, threadPool, actionFilters, GetDesiredNodesAction.Request::new, indexNameExpressionResolver, GetDesiredNodesAction.Response::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
    }

    @Override
    protected void masterOperation(Task task, GetDesiredNodesAction.Request request, ClusterState state, ActionListener<GetDesiredNodesAction.Response> listener) throws Exception {
        DesiredNodes latestDesiredNodes = DesiredNodes.latestFromClusterState(state);
        if (latestDesiredNodes == null) {
            listener.onFailure(new ResourceNotFoundException("Desired nodes not found", new Object[0]));
        } else {
            listener.onResponse(new GetDesiredNodesAction.Response(latestDesiredNodes));
        }
    }

    @Override
    protected ClusterBlockException checkBlock(GetDesiredNodesAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

