/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich.action;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.Preference;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fieldvisitor.FieldsVisitor;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParsedMediaType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public class EnrichShardMultiSearchAction
extends ActionType<MultiSearchResponse> {
    public static final EnrichShardMultiSearchAction INSTANCE = new EnrichShardMultiSearchAction();
    private static final String NAME = "indices:data/read/shard_multi_search";

    private EnrichShardMultiSearchAction() {
        super(NAME);
    }

    private static BytesReference filterSource(FetchSourceContext fetchSourceContext, BytesReference source) throws IOException {
        if (fetchSourceContext.includes().length == 0 && fetchSourceContext.excludes().length == 0) {
            return source;
        }
        Set<String> includes = Set.of(fetchSourceContext.includes());
        Set<String> excludes = Set.of(fetchSourceContext.excludes());
        XContentBuilder builder = new XContentBuilder(XContentType.SMILE.xContent(), (OutputStream)new BytesStreamOutput(source.length()), includes, excludes, ParsedMediaType.parseMediaType((XContentType)XContentType.SMILE, Collections.emptyMap()));
        XContentParser sourceParser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (BytesReference)source, (XContentType)XContentType.SMILE);
        builder.copyCurrentStructure(sourceParser);
        return BytesReference.bytes((XContentBuilder)builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SearchResponse createSearchResponse(TopDocs topDocs, SearchHit[] hits) {
        SearchHits searchHits = new SearchHits(hits, topDocs.totalHits, 0.0f);
        try {
            SearchResponse searchResponse = new SearchResponse(searchHits, null, null, false, null, null, 0, null, 1, 1, 0, 1L, ShardSearchFailure.EMPTY_ARRAY, SearchResponse.Clusters.EMPTY);
            return searchResponse;
        }
        finally {
            searchHits.decRef();
        }
    }

    public static class TransportAction
    extends TransportSingleShardAction<Request, MultiSearchResponse> {
        private final IndicesService indicesService;

        @Inject
        public TransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
            super(EnrichShardMultiSearchAction.NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, Request::new, (Executor)threadPool.executor("search"));
            this.indicesService = indicesService;
        }

        protected Writeable.Reader<MultiSearchResponse> getResponseReader() {
            return MultiSearchResponse::new;
        }

        protected boolean resolveIndex(Request request) {
            return true;
        }

        protected ShardsIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
            String index = request.concreteIndex();
            IndexRoutingTable indexRouting = state.routingTable().index(index);
            int numShards = indexRouting.size();
            if (numShards != 1) {
                throw new IllegalStateException("index [" + index + "] should have 1 shard, but has " + numShards + " shards");
            }
            GroupShardsIterator result = this.clusterService.operationRouting().searchShards(state, new String[]{index}, null, Preference.LOCAL.type());
            return (ShardsIterator)result.get(0);
        }

        protected MultiSearchResponse shardOperation(Request request, ShardId shardId) throws IOException {
            IndexService indexService = this.indicesService.indexService(shardId.getIndex());
            IndexShard indexShard = (IndexShard)this.indicesService.getShardOrNull(shardId);
            try (Engine.Searcher searcher = indexShard.acquireSearcher("enrich_msearch");){
                FieldsVisitor visitor = new FieldsVisitor(true);
                Map runtimeFields = Collections.emptyMap();
                SearchExecutionContext context = indexService.newSearchExecutionContext(shardId.id(), 0, (IndexSearcher)searcher, () -> {
                    throw new UnsupportedOperationException();
                }, null, runtimeFields);
                MultiSearchResponse.Item[] items = new MultiSearchResponse.Item[request.multiSearchRequest.requests().size()];
                StoredFields storedFields = searcher.storedFields();
                for (int i = 0; i < request.multiSearchRequest.requests().size(); ++i) {
                    SearchSourceBuilder searchSourceBuilder = ((SearchRequest)request.multiSearchRequest.requests().get(i)).source();
                    QueryBuilder queryBuilder = searchSourceBuilder.query();
                    int from = searchSourceBuilder.from();
                    int size = searchSourceBuilder.size();
                    FetchSourceContext fetchSourceContext = searchSourceBuilder.fetchSource();
                    Query luceneQuery = queryBuilder.rewrite((QueryRewriteContext)context).toQuery(context);
                    int n = from + size;
                    TopFieldDocs topDocs = searcher.search(luceneQuery, n, new Sort(new SortField[]{SortField.FIELD_DOC}));
                    SearchHit[] hits = new SearchHit[topDocs.scoreDocs.length];
                    for (int j = 0; j < topDocs.scoreDocs.length; ++j) {
                        ScoreDoc scoreDoc = topDocs.scoreDocs[j];
                        visitor.reset();
                        storedFields.document(scoreDoc.doc, (StoredFieldVisitor)visitor);
                        visitor.postProcess(field -> {
                            if (!context.isFieldMapped(field)) {
                                throw new IllegalStateException("Field [" + field + "] exists in the index but not in mappings");
                            }
                            return context.getFieldType(field);
                        });
                        SearchHit hit = new SearchHit(scoreDoc.doc, visitor.id());
                        hit.sourceRef(EnrichShardMultiSearchAction.filterSource(fetchSourceContext, visitor.source()));
                        hits[j] = hit;
                    }
                    items[i] = new MultiSearchResponse.Item(EnrichShardMultiSearchAction.createSearchResponse((TopDocs)topDocs, hits), null);
                }
                MultiSearchResponse multiSearchResponse = new MultiSearchResponse(items, 1L);
                return multiSearchResponse;
            }
        }
    }

    public static class Request
    extends SingleShardRequest<Request> {
        private final MultiSearchRequest multiSearchRequest;
        private static final SearchSourceBuilder EMPTY_SOURCE = new SearchSourceBuilder().from(0).size(10);

        public Request(MultiSearchRequest multiSearchRequest) {
            super(((SearchRequest)multiSearchRequest.requests().get(0)).indices()[0]);
            this.multiSearchRequest = multiSearchRequest;
            assert (multiSearchRequest.requests().stream().map(SearchRequest::indices).flatMap(Arrays::stream).distinct().count() == 1L) : "action [indices:data/read/shard_multi_search] cannot handle msearch request pointing to multiple indices";
            assert (this.assertSearchSource());
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.multiSearchRequest = new MultiSearchRequest(in);
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = this.validateNonNullIndex();
            if (!this.index.startsWith(".enrich-")) {
                validationException = ValidateActions.addValidationError((String)("index [" + this.index + "] is not an enrich index"), (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.multiSearchRequest.writeTo(out);
        }

        MultiSearchRequest getMultiSearchRequest() {
            return this.multiSearchRequest;
        }

        private boolean assertSearchSource() {
            for (SearchRequest request : this.multiSearchRequest.requests()) {
                SearchSourceBuilder copy = Request.copy(request.source());
                copy.query(null);
                copy.from(0);
                copy.size(10);
                copy.fetchSource(null);
                assert (EMPTY_SOURCE.equals((Object)copy)) : "search request [" + Strings.toString((ToXContent)copy) + "] is using features that is not supported";
            }
            return true;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private static SearchSourceBuilder copy(SearchSourceBuilder source) {
            NamedWriteableRegistry registry = new NamedWriteableRegistry(new SearchModule(Settings.EMPTY, List.of()).getNamedWriteables());
            try (BytesStreamOutput output = new BytesStreamOutput();){
                SearchSourceBuilder searchSourceBuilder;
                source.writeTo((StreamOutput)output);
                try (NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(output.bytes().streamInput(), registry);){
                    searchSourceBuilder = new SearchSourceBuilder((StreamInput)in);
                }
                return searchSourceBuilder;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

