/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DelegatingActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.segments.IndexSegments;
import org.elasticsearch.action.admin.indices.segments.IndexShardSegments;
import org.elasticsearch.action.admin.indices.segments.IndicesSegmentResponse;
import org.elasticsearch.action.admin.indices.segments.IndicesSegmentsRequest;
import org.elasticsearch.action.admin.indices.segments.ShardSegments;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.FilterClient;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.index.reindex.ScrollableHitSource;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;
import org.elasticsearch.xpack.core.enrich.action.ExecuteEnrichPolicyStatus;
import org.elasticsearch.xpack.enrich.EnrichPolicyReindexPipeline;
import org.elasticsearch.xpack.enrich.ExecuteEnrichPolicyTask;
import org.elasticsearch.xpack.enrich.action.EnrichReindexAction;

public class EnrichPolicyRunner
implements Runnable {
    private static final Logger logger = LogManager.getLogger(EnrichPolicyRunner.class);
    static final String ENRICH_POLICY_NAME_FIELD_NAME = "enrich_policy_name";
    static final String ENRICH_POLICY_TYPE_FIELD_NAME = "enrich_policy_type";
    static final String ENRICH_MATCH_FIELD_NAME = "enrich_match_field";
    static final String ENRICH_README_FIELD_NAME = "enrich_readme";
    static final String ENRICH_INDEX_README_TEXT = "This index is managed by Elasticsearch and should not be modified in any way.";
    private final String policyName;
    private final EnrichPolicy policy;
    private final ExecuteEnrichPolicyTask task;
    private final ActionListener<ExecuteEnrichPolicyStatus> listener;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final Client client;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final String enrichIndexName;
    private final int fetchSize;
    private final int maxForceMergeAttempts;
    static final Set<String> RANGE_TYPES = Set.of("integer_range", "float_range", "long_range", "double_range", "ip_range", "date_range");

    EnrichPolicyRunner(String policyName, EnrichPolicy policy, ExecuteEnrichPolicyTask task, ActionListener<ExecuteEnrichPolicyStatus> listener, ClusterService clusterService, IndicesService indicesService, Client client, IndexNameExpressionResolver indexNameExpressionResolver, String enrichIndexName, int fetchSize, int maxForceMergeAttempts) {
        this.policyName = Objects.requireNonNull(policyName);
        this.policy = Objects.requireNonNull(policy);
        this.task = Objects.requireNonNull(task);
        this.listener = Objects.requireNonNull(listener);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.indicesService = indicesService;
        this.client = EnrichPolicyRunner.wrapClient(client, policyName, task, clusterService);
        this.indexNameExpressionResolver = Objects.requireNonNull(indexNameExpressionResolver);
        this.enrichIndexName = enrichIndexName;
        this.fetchSize = fetchSize;
        this.maxForceMergeAttempts = maxForceMergeAttempts;
    }

    @Override
    public void run() {
        try {
            logger.info("Policy [{}]: Running enrich policy", (Object)this.policyName);
            this.task.setStatus(new ExecuteEnrichPolicyStatus("RUNNING"));
            String[] sourceIndices = this.policy.getIndices().toArray(new String[0]);
            logger.debug("Policy [{}]: Checking source indices [{}]", (Object)this.policyName, (Object)sourceIndices);
            GetIndexRequest getIndexRequest = (GetIndexRequest)new GetIndexRequest().indices(sourceIndices);
            this.client.admin().indices().getIndex(getIndexRequest, this.listener.delegateFailureAndWrap((l, getIndexResponse) -> {
                this.validateMappings((GetIndexResponse)getIndexResponse);
                this.prepareAndCreateEnrichIndex(EnrichPolicyRunner.toMappings(getIndexResponse));
            }));
        }
        catch (Exception e) {
            this.listener.onFailure(e);
        }
    }

    private static List<Map<String, Object>> toMappings(GetIndexResponse response) {
        return response.mappings().values().stream().map(MappingMetadata::getSourceAsMap).collect(Collectors.toList());
    }

    private Map<String, Object> getMappings(GetIndexResponse getIndexResponse, String sourceIndexName) {
        Map mappings = getIndexResponse.mappings();
        MappingMetadata indexMapping = (MappingMetadata)mappings.get(sourceIndexName);
        if (indexMapping == MappingMetadata.EMPTY_MAPPINGS) {
            throw new ElasticsearchException("Enrich policy execution for [{}] failed. No mapping available on source [{}] included in [{}]", new Object[]{this.policyName, sourceIndexName, this.policy.getIndices()});
        }
        return indexMapping.sourceAsMap();
    }

    private void validateMappings(GetIndexResponse getIndexResponse) {
        String[] sourceIndices = getIndexResponse.getIndices();
        logger.debug("Policy [{}]: Validating [{}] source mappings", (Object)this.policyName, (Object)sourceIndices);
        for (String sourceIndex : sourceIndices) {
            Map<String, Object> mapping = this.getMappings(getIndexResponse, sourceIndex);
            EnrichPolicyRunner.validateMappings(this.policyName, this.policy, sourceIndex, mapping);
        }
    }

    static void validateMappings(String policyName, EnrichPolicy policy, String sourceIndex, Map<String, Object> mapping) {
        if (mapping.get("properties") == null) {
            throw new ElasticsearchException("Enrich policy execution for [{}] failed. Could not read mapping for source [{}] included by pattern [{}]", new Object[]{policyName, sourceIndex, policy.getIndices()});
        }
        try {
            EnrichPolicyRunner.validateAndGetMappingTypeAndFormat(mapping, policy.getMatchField(), true);
            for (String valueFieldName : policy.getEnrichFields()) {
                EnrichPolicyRunner.validateAndGetMappingTypeAndFormat(mapping, valueFieldName, false);
            }
        }
        catch (ElasticsearchException e) {
            throw new ElasticsearchException("Enrich policy execution for [{}] failed while validating field mappings for index [{}]", (Throwable)e, new Object[]{policyName, sourceIndex});
        }
    }

    private static MappingTypeAndFormat validateAndGetMappingTypeAndFormat(String fieldName, EnrichPolicy policy, boolean strictlyRequired, List<Map<String, Object>> sourceMappings) {
        List<MappingTypeAndFormat> fieldMappings = sourceMappings.stream().map(mapping -> EnrichPolicyRunner.validateAndGetMappingTypeAndFormat(mapping, fieldName, strictlyRequired)).filter(Objects::nonNull).toList();
        Set types = fieldMappings.stream().map(tf -> tf.type).collect(Collectors.toSet());
        if (types.size() > 1) {
            if (strictlyRequired) {
                throw new ElasticsearchException("Multiple distinct mapping types for field '{}' - indices({})  types({})", new Object[]{fieldName, org.elasticsearch.common.Strings.collectionToCommaDelimitedString((Iterable)policy.getIndices()), org.elasticsearch.common.Strings.collectionToCommaDelimitedString(types)});
            }
            return null;
        }
        if (types.isEmpty()) {
            return null;
        }
        Set formats = fieldMappings.stream().map(tf -> tf.format).filter(Objects::nonNull).collect(Collectors.toSet());
        if (formats.size() > 1) {
            if (strictlyRequired) {
                throw new ElasticsearchException("Multiple distinct formats specified for field '{}' - indices({})  format entries({})", new Object[]{policy.getMatchField(), org.elasticsearch.common.Strings.collectionToCommaDelimitedString((Iterable)policy.getIndices()), org.elasticsearch.common.Strings.collectionToCommaDelimitedString(formats)});
            }
            return null;
        }
        return new MappingTypeAndFormat((String)Iterables.get(types, (int)0), formats.isEmpty() ? null : (String)Iterables.get(formats, (int)0));
    }

    private static <T> T extractValues(Map<String, Object> properties, String path) {
        return (T)properties.get(path);
    }

    private static MappingTypeAndFormat validateAndGetMappingTypeAndFormat(Map<String, Object> properties, String fieldName, boolean fieldRequired) {
        assert (!org.elasticsearch.common.Strings.isEmpty((CharSequence)fieldName)) : "Field name cannot be null or empty";
        String[] fieldParts = fieldName.split("\\.");
        StringBuilder parent = new StringBuilder();
        Map currentField = properties;
        boolean onRoot = true;
        for (String fieldPart : fieldParts) {
            Object type = currentField.get("type");
            if (type != null && !"object".equals(type)) {
                throw new ElasticsearchException("Could not traverse mapping to field [{}]. The [{}] field must be regular object but was [{}].", new Object[]{fieldName, onRoot ? "root" : parent.toString(), type});
            }
            Map currentProperties = (Map)EnrichPolicyRunner.extractValues(currentField, "properties");
            if (currentProperties == null) {
                if (fieldRequired) {
                    throw new ElasticsearchException("Could not traverse mapping to field [{}]. Expected the [{}] field to have sub fields but none were configured.", new Object[]{fieldName, onRoot ? "root" : parent.toString()});
                }
                return null;
            }
            currentField = (Map)EnrichPolicyRunner.extractValues(currentProperties, fieldPart);
            if (currentField == null) {
                if (fieldRequired) {
                    throw new ElasticsearchException("Could not traverse mapping to field [{}]. Could not find the [{}] field under [{}]", new Object[]{fieldName, fieldPart, onRoot ? "root" : parent.toString()});
                }
                return null;
            }
            if (onRoot) {
                onRoot = false;
            } else {
                parent.append(".");
            }
            parent.append(fieldPart);
        }
        if (currentField == null) {
            return null;
        }
        String type = (String)currentField.getOrDefault("type", (Object)"object");
        String format = (String)currentField.get("format");
        return new MappingTypeAndFormat(type, format);
    }

    static Map<String, Object> mappingForMatchField(EnrichPolicy policy, List<Map<String, Object>> sourceMappings) {
        MappingTypeAndFormat typeAndFormat = EnrichPolicyRunner.validateAndGetMappingTypeAndFormat(policy.getMatchField(), policy, true, sourceMappings);
        if (typeAndFormat == null) {
            throw new ElasticsearchException("Match field '{}' doesn't have a correct mapping type for policy type '{}'", new Object[]{policy.getMatchField(), policy.getType()});
        }
        return switch (policy.getType()) {
            case "match" -> Map.of("type", "keyword", "doc_values", false);
            case "geo_match" -> Map.of("type", "geo_shape");
            case "range" -> {
                if (!RANGE_TYPES.contains(typeAndFormat.type)) {
                    throw new ElasticsearchException("Field '{}' has type [{}] which doesn't appear to be a range type", new Object[]{policy.getMatchField(), typeAndFormat.type});
                }
                Map mapping = Maps.newMapWithExpectedSize((int)3);
                mapping.put("type", typeAndFormat.type);
                mapping.put("doc_values", false);
                if (typeAndFormat.format != null) {
                    mapping.put("format", typeAndFormat.format);
                }
                yield mapping;
            }
            default -> throw new ElasticsearchException("Unrecognized enrich policy type [{}]", new Object[]{policy.getType()});
        };
    }

    private XContentBuilder createEnrichMapping(List<Map<String, Object>> sourceMappings) {
        HashMap<String, Map<String, Object>> fieldMappings = new HashMap<String, Map<String, Object>>();
        Map<String, Object> mappingForMatchField = EnrichPolicyRunner.mappingForMatchField(this.policy, sourceMappings);
        MapperService mapperService = EnrichPolicyRunner.createMapperServiceForValidation(this.indicesService, this.enrichIndexName);
        for (String enrichField : this.policy.getEnrichFields()) {
            if (enrichField.equals(this.policy.getMatchField())) {
                mappingForMatchField = new HashMap<String, Object>(mappingForMatchField);
                mappingForMatchField.remove("doc_values");
                continue;
            }
            MappingTypeAndFormat typeAndFormat = EnrichPolicyRunner.validateAndGetMappingTypeAndFormat(enrichField, this.policy, false, sourceMappings);
            if (typeAndFormat == null) continue;
            Map mapping = Maps.newMapWithExpectedSize((int)3);
            mapping.put("type", typeAndFormat.type);
            if (typeAndFormat.format != null) {
                mapping.put("format", typeAndFormat.format);
            }
            if (EnrichPolicyRunner.isIndexableField(mapperService, enrichField, typeAndFormat.type, mapping)) {
                mapping.put("index", false);
            }
            fieldMappings.put(enrichField, mapping);
        }
        fieldMappings.put(this.policy.getMatchField(), mappingForMatchField);
        try {
            XContentBuilder builder = JsonXContent.contentBuilder();
            builder.startObject();
            builder.startObject("_doc");
            builder.field("dynamic", false);
            builder.startObject("_source");
            builder.field("enabled", true);
            builder.endObject();
            builder.startObject("properties");
            builder.mapContents(fieldMappings);
            builder.endObject();
            builder.startObject("_meta");
            builder.field(ENRICH_README_FIELD_NAME, ENRICH_INDEX_README_TEXT);
            builder.field(ENRICH_POLICY_NAME_FIELD_NAME, this.policyName);
            builder.field(ENRICH_MATCH_FIELD_NAME, this.policy.getMatchField());
            builder.field(ENRICH_POLICY_TYPE_FIELD_NAME, this.policy.getType());
            builder.endObject();
            builder.endObject();
            builder.endObject();
            return builder;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Could not render enrich mapping", ioe);
        }
    }

    private static MapperService createMapperServiceForValidation(IndicesService indicesService, String index) {
        try {
            Settings idxSettings = Settings.builder().put("index.version.created", (VersionId)IndexVersion.current()).put("index.uuid", UUIDs.randomBase64UUID()).build();
            IndexMetadata indexMetadata = IndexMetadata.builder((String)index).settings(idxSettings).numberOfShards(1).numberOfReplicas(0).build();
            return indicesService.createIndexMapperServiceForValidation(indexMetadata);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static boolean isIndexableField(MapperService mapperService, String field, String type, Map<String, Object> properties) {
        HashMap<String, Object> withIndexParameter = new HashMap<String, Object>(properties);
        withIndexParameter.put("index", false);
        Mapper.TypeParser parser = mapperService.getMapperRegistry().getMapperParser(type, IndexVersion.current());
        try {
            parser.parse(field, withIndexParameter, mapperService.parserContext());
            return !withIndexParameter.containsKey("index");
        }
        catch (MapperParsingException e) {
            assert (e.getMessage().contains("unknown parameter [index]")) : e;
            return false;
        }
    }

    private void prepareAndCreateEnrichIndex(List<Map<String, Object>> mappings) {
        Settings enrichIndexSettings = Settings.builder().put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.refresh_interval", -1).put("index.warmer.enabled", false).build();
        CreateIndexRequest createEnrichIndexRequest = new CreateIndexRequest(this.enrichIndexName, enrichIndexSettings);
        createEnrichIndexRequest.mapping(this.createEnrichMapping(mappings));
        logger.debug("Policy [{}]: Creating new enrich index [{}]", (Object)this.policyName, (Object)this.enrichIndexName);
        this.enrichOriginClient().admin().indices().create(createEnrichIndexRequest, this.listener.delegateFailure((l, createIndexResponse) -> this.prepareReindexOperation(this.enrichIndexName)));
    }

    private void prepareReindexOperation(String destinationIndexName) {
        if (!EnrichPolicyReindexPipeline.exists(this.clusterService.state())) {
            EnrichPolicyReindexPipeline.create(this.enrichOriginClient(), (ActionListener<AcknowledgedResponse>)this.listener.delegateFailure((l, r) -> this.transferDataToEnrichIndex(destinationIndexName)));
        } else {
            this.transferDataToEnrichIndex(destinationIndexName);
        }
    }

    private void transferDataToEnrichIndex(final String destinationIndexName) {
        logger.debug("Policy [{}]: Transferring source data to new enrich index [{}]", (Object)this.policyName, (Object)destinationIndexName);
        HashSet<String> retainFields = new HashSet<String>();
        retainFields.add(this.policy.getMatchField());
        retainFields.addAll(this.policy.getEnrichFields());
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.size(this.fetchSize);
        searchSourceBuilder.fetchSource(retainFields.toArray(new String[0]), new String[0]);
        if (this.policy.getQuery() != null) {
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.wrapperQuery((BytesReference)this.policy.getQuery().getQuery()));
        }
        ReindexRequest reindexRequest = new ReindexRequest().setDestIndex(destinationIndexName).setSourceIndices(this.policy.getIndices().toArray(new String[0]));
        reindexRequest.getSearchRequest().source(searchSourceBuilder);
        reindexRequest.getDestination().source((BytesReference)new BytesArray(new byte[0]), XContentType.SMILE);
        reindexRequest.getDestination().routing("discard");
        reindexRequest.getDestination().setPipeline(EnrichPolicyReindexPipeline.pipelineName());
        this.client.execute((ActionType)EnrichReindexAction.INSTANCE, (ActionRequest)reindexRequest, (ActionListener)new DelegatingActionListener<BulkByScrollResponse, ExecuteEnrichPolicyStatus>(this.listener){

            public void onResponse(BulkByScrollResponse bulkByScrollResponse) {
                if (bulkByScrollResponse.getBulkFailures().size() > 0) {
                    logger.warn("Policy [{}]: encountered [{}] bulk failures. Turn on DEBUG logging for details.", (Object)EnrichPolicyRunner.this.policyName, (Object)bulkByScrollResponse.getBulkFailures().size());
                    if (logger.isDebugEnabled()) {
                        for (BulkItemResponse.Failure failure : bulkByScrollResponse.getBulkFailures()) {
                            logger.debug(() -> Strings.format((String)"Policy [%s]: bulk index failed for index [%s], id [%s]", (Object[])new Object[]{EnrichPolicyRunner.this.policyName, failure.getIndex(), failure.getId()}), (Throwable)failure.getCause());
                        }
                    }
                    this.delegate.onFailure((Exception)new ElasticsearchException("Encountered bulk failures during reindex process", new Object[0]));
                } else if (bulkByScrollResponse.getSearchFailures().size() > 0) {
                    logger.warn("Policy [{}]: encountered [{}] search failures. Turn on DEBUG logging for details.", (Object)EnrichPolicyRunner.this.policyName, (Object)bulkByScrollResponse.getSearchFailures().size());
                    if (logger.isDebugEnabled()) {
                        for (ScrollableHitSource.SearchFailure failure : bulkByScrollResponse.getSearchFailures()) {
                            logger.debug(() -> Strings.format((String)"Policy [%s]: search failed for index [%s], shard [%s] on node [%s]", (Object[])new Object[]{EnrichPolicyRunner.this.policyName, failure.getIndex(), failure.getShardId(), failure.getNodeId()}), failure.getReason());
                        }
                    }
                    this.delegate.onFailure((Exception)new ElasticsearchException("Encountered search failures during reindex process", new Object[0]));
                } else {
                    logger.info("Policy [{}]: Transferred [{}] documents to enrich index [{}]", (Object)EnrichPolicyRunner.this.policyName, (Object)bulkByScrollResponse.getCreated(), (Object)destinationIndexName);
                    EnrichPolicyRunner.this.forceMergeEnrichIndex(destinationIndexName, 1);
                }
            }
        });
    }

    private void forceMergeEnrichIndex(String destinationIndexName, int attempt) {
        logger.debug("Policy [{}]: Force merging newly created enrich index [{}] (Attempt {}/{})", (Object)this.policyName, (Object)destinationIndexName, (Object)attempt, (Object)this.maxForceMergeAttempts);
        this.enrichOriginClient().admin().indices().forceMerge(new ForceMergeRequest(new String[]{destinationIndexName}).maxNumSegments(1), this.listener.delegateFailure((l, r) -> this.refreshEnrichIndex(destinationIndexName, attempt)));
    }

    private void refreshEnrichIndex(String destinationIndexName, int attempt) {
        logger.debug("Policy [{}]: Refreshing enrich index [{}]", (Object)this.policyName, (Object)destinationIndexName);
        this.enrichOriginClient().admin().indices().refresh(new RefreshRequest(new String[]{destinationIndexName}), this.listener.delegateFailure((l, r) -> this.ensureSingleSegment(destinationIndexName, attempt)));
    }

    protected void ensureSingleSegment(final String destinationIndexName, final int attempt) {
        this.enrichOriginClient().admin().indices().segments(new IndicesSegmentsRequest(new String[]{destinationIndexName}), (ActionListener)new DelegatingActionListener<IndicesSegmentResponse, ExecuteEnrichPolicyStatus>(this.listener){

            public void onResponse(IndicesSegmentResponse indicesSegmentResponse) {
                IndexSegments indexSegments = (IndexSegments)indicesSegmentResponse.getIndices().get(destinationIndexName);
                if (indexSegments == null) {
                    throw new ElasticsearchException("Could not locate segment information for newly created index [{}]", new Object[]{destinationIndexName});
                }
                Map indexShards = indexSegments.getShards();
                assert (indexShards.size() == 1) : "Expected enrich index to contain only one shard";
                ShardSegments[] shardSegments = ((IndexShardSegments)indexShards.get(0)).shards();
                assert (shardSegments.length == 1) : "Expected enrich index to contain no replicas at this point";
                ShardSegments primarySegments = shardSegments[0];
                if (primarySegments.getSegments().size() > 1) {
                    int nextAttempt = attempt + 1;
                    if (nextAttempt > EnrichPolicyRunner.this.maxForceMergeAttempts) {
                        this.delegate.onFailure((Exception)new ElasticsearchException("Force merging index [{}] attempted [{}] times but did not result in one segment.", new Object[]{destinationIndexName, attempt, EnrichPolicyRunner.this.maxForceMergeAttempts}));
                    } else {
                        logger.debug("Policy [{}]: Force merge result contains more than one segment [{}], retrying (attempt {}/{})", (Object)EnrichPolicyRunner.this.policyName, (Object)primarySegments.getSegments().size(), (Object)nextAttempt, (Object)EnrichPolicyRunner.this.maxForceMergeAttempts);
                        EnrichPolicyRunner.this.forceMergeEnrichIndex(destinationIndexName, nextAttempt);
                    }
                } else {
                    EnrichPolicyRunner.this.setIndexReadOnly(destinationIndexName);
                }
            }
        });
    }

    private void setIndexReadOnly(String destinationIndexName) {
        logger.debug("Policy [{}]: Setting new enrich index [{}] to be read only", (Object)this.policyName, (Object)destinationIndexName);
        UpdateSettingsRequest request = new UpdateSettingsRequest(new String[]{destinationIndexName}).setPreserveExisting(true).settings(Settings.builder().put("index.auto_expand_replicas", "0-all").put("index.blocks.write", "true"));
        this.enrichOriginClient().admin().indices().updateSettings(request, this.listener.delegateFailure((l, r) -> this.waitForIndexGreen(destinationIndexName)));
    }

    private void waitForIndexGreen(String destinationIndexName) {
        ClusterHealthRequest request = new ClusterHealthRequest(new String[]{destinationIndexName}).waitForGreenStatus();
        this.enrichOriginClient().admin().cluster().health(request, this.listener.delegateFailureAndWrap((l, r) -> this.updateEnrichPolicyAlias(destinationIndexName)));
    }

    private void validateIndexBeforePromotion(String destinationIndexName, ClusterState clusterState) {
        IndexMetadata destinationIndex = clusterState.metadata().index(destinationIndexName);
        if (destinationIndex == null) {
            throw new IndexNotFoundException("was not able to promote it as part of executing enrich policy [" + this.policyName + "]", destinationIndexName);
        }
        MappingMetadata mapping = destinationIndex.mapping();
        if (mapping == null) {
            throw new ResourceNotFoundException("Could not locate mapping for enrich index [{}] while completing [{}] policy run", new Object[]{destinationIndexName, this.policyName});
        }
        Map mappingSource = mapping.sourceAsMap();
        Object meta = mappingSource.get("_meta");
        if (meta instanceof Map) {
            Map metaMap = (Map)meta;
            Object policyNameMetaField = metaMap.get(ENRICH_POLICY_NAME_FIELD_NAME);
            if (policyNameMetaField == null) {
                throw new ElasticsearchException("Could not verify enrich index [{}] metadata before completing [{}] policy run: policy name meta field missing", new Object[]{destinationIndexName, this.policyName});
            }
            if (!this.policyName.equals(policyNameMetaField)) {
                throw new ElasticsearchException("Could not verify enrich index [{}] metadata before completing [{}] policy run: policy name meta field does not match expected value of [{}], was [{}]", new Object[]{destinationIndexName, this.policyName, this.policyName, policyNameMetaField.toString()});
            }
        } else {
            throw new ElasticsearchException("Could not verify enrich index [{}] metadata before completing [{}] policy run: mapping meta field missing", new Object[]{destinationIndexName, this.policyName});
        }
    }

    private void updateEnrichPolicyAlias(String destinationIndexName) {
        String enrichIndexBase = EnrichPolicy.getBaseName((String)this.policyName);
        logger.debug("Policy [{}]: Promoting new enrich index [{}] to alias [{}]", (Object)this.policyName, (Object)destinationIndexName, (Object)enrichIndexBase);
        GetAliasesRequest aliasRequest = new GetAliasesRequest(new String[]{enrichIndexBase});
        ClusterState clusterState = this.clusterService.state();
        this.validateIndexBeforePromotion(destinationIndexName, clusterState);
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNamesWithSystemIndexAccess(clusterState, (IndicesRequest)aliasRequest);
        String[] aliases = aliasRequest.aliases();
        IndicesAliasesRequest aliasToggleRequest = new IndicesAliasesRequest();
        String[] indices = clusterState.metadata().findAliases(aliases, concreteIndices).keySet().toArray(new String[0]);
        if (indices.length > 0) {
            aliasToggleRequest.addAliasAction(IndicesAliasesRequest.AliasActions.remove().indices(indices).alias(enrichIndexBase));
        }
        aliasToggleRequest.addAliasAction(IndicesAliasesRequest.AliasActions.add().index(destinationIndexName).alias(enrichIndexBase));
        this.enrichOriginClient().admin().indices().aliases(aliasToggleRequest, this.listener.safeMap(r -> {
            logger.info("Policy [{}]: Policy execution complete", (Object)this.policyName);
            ExecuteEnrichPolicyStatus completeStatus = new ExecuteEnrichPolicyStatus("COMPLETE");
            this.task.setStatus(completeStatus);
            return completeStatus;
        }));
    }

    private Client enrichOriginClient() {
        return new OriginSettingClient(this.client, "enrich");
    }

    private static Client wrapClient(Client in, final String policyName, final ExecuteEnrichPolicyTask task, final ClusterService clusterService) {
        return new FilterClient(in){

            protected <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
                String requestStep = request.getClass().getSimpleName();
                task.setStep(requestStep);
                if (task.isCancelled()) {
                    String message = "cancelled policy execution [" + policyName + "], status [" + org.elasticsearch.common.Strings.toString((ToXContent)task.getStatus()) + "]";
                    listener.onFailure((Exception)new TaskCancelledException(message));
                    return;
                }
                request.setParentTask(clusterService.localNode().getId(), task.getId());
                super.doExecute(action, request, listener);
            }
        };
    }

    private record MappingTypeAndFormat(String type, String format) {
    }
}

