/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.enrich.EnrichMetadata;
import org.elasticsearch.xpack.core.enrich.action.DeleteEnrichPolicyAction;
import org.elasticsearch.xpack.core.enrich.action.EnrichStatsAction;
import org.elasticsearch.xpack.core.enrich.action.ExecuteEnrichPolicyAction;
import org.elasticsearch.xpack.core.enrich.action.GetEnrichPolicyAction;
import org.elasticsearch.xpack.core.enrich.action.PutEnrichPolicyAction;
import org.elasticsearch.xpack.enrich.EnrichCache;
import org.elasticsearch.xpack.enrich.EnrichPolicyExecutor;
import org.elasticsearch.xpack.enrich.EnrichPolicyLocks;
import org.elasticsearch.xpack.enrich.EnrichPolicyMaintenanceService;
import org.elasticsearch.xpack.enrich.EnrichProcessorFactory;
import org.elasticsearch.xpack.enrich.action.EnrichCoordinatorProxyAction;
import org.elasticsearch.xpack.enrich.action.EnrichCoordinatorStatsAction;
import org.elasticsearch.xpack.enrich.action.EnrichInfoTransportAction;
import org.elasticsearch.xpack.enrich.action.EnrichReindexAction;
import org.elasticsearch.xpack.enrich.action.EnrichShardMultiSearchAction;
import org.elasticsearch.xpack.enrich.action.EnrichUsageTransportAction;
import org.elasticsearch.xpack.enrich.action.InternalExecutePolicyAction;
import org.elasticsearch.xpack.enrich.action.TransportDeleteEnrichPolicyAction;
import org.elasticsearch.xpack.enrich.action.TransportEnrichReindexAction;
import org.elasticsearch.xpack.enrich.action.TransportEnrichStatsAction;
import org.elasticsearch.xpack.enrich.action.TransportExecuteEnrichPolicyAction;
import org.elasticsearch.xpack.enrich.action.TransportGetEnrichPolicyAction;
import org.elasticsearch.xpack.enrich.action.TransportPutEnrichPolicyAction;
import org.elasticsearch.xpack.enrich.rest.RestDeleteEnrichPolicyAction;
import org.elasticsearch.xpack.enrich.rest.RestEnrichStatsAction;
import org.elasticsearch.xpack.enrich.rest.RestExecuteEnrichPolicyAction;
import org.elasticsearch.xpack.enrich.rest.RestGetEnrichPolicyAction;
import org.elasticsearch.xpack.enrich.rest.RestPutEnrichPolicyAction;

public class EnrichPlugin
extends Plugin
implements SystemIndexPlugin,
IngestPlugin {
    static final Setting<Integer> ENRICH_FETCH_SIZE_SETTING = Setting.intSetting((String)"enrich.fetch_size", (int)10000, (int)1, (int)1000000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<Integer> ENRICH_MAX_CONCURRENT_POLICY_EXECUTIONS = Setting.intSetting((String)"enrich.max_concurrent_policy_executions", (int)50, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<TimeValue> ENRICH_CLEANUP_PERIOD = Setting.timeSetting((String)"enrich.cleanup_period", (TimeValue)new TimeValue(15L, TimeUnit.MINUTES), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Integer> COORDINATOR_PROXY_MAX_CONCURRENT_REQUESTS = Setting.intSetting((String)"enrich.coordinator_proxy.max_concurrent_requests", (int)8, (int)1, (int)10000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Integer> COORDINATOR_PROXY_MAX_LOOKUPS_PER_REQUEST = Setting.intSetting((String)"enrich.coordinator_proxy.max_lookups_per_request", (int)128, (int)1, (int)10000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<Integer> ENRICH_MAX_FORCE_MERGE_ATTEMPTS = Setting.intSetting((String)"enrich.max_force_merge_attempts", (int)3, (int)1, (int)10, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final String QUEUE_CAPACITY_SETTING_NAME = "enrich.coordinator_proxy.queue_capacity";
    public static final Setting<Integer> COORDINATOR_PROXY_QUEUE_CAPACITY = new Setting("enrich.coordinator_proxy.queue_capacity", settings -> {
        int maxConcurrentRequests = (Integer)COORDINATOR_PROXY_MAX_CONCURRENT_REQUESTS.get(settings);
        int maxLookupsPerRequest = (Integer)COORDINATOR_PROXY_MAX_LOOKUPS_PER_REQUEST.get(settings);
        return String.valueOf(maxConcurrentRequests * maxLookupsPerRequest);
    }, val -> Setting.parseInt((String)val, (int)1, (int)Integer.MAX_VALUE, (String)QUEUE_CAPACITY_SETTING_NAME), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Long> CACHE_SIZE = Setting.longSetting((String)"enrich.cache_size", (long)1000L, (long)0L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final Settings settings;
    private final EnrichCache enrichCache;

    public EnrichPlugin(Settings settings) {
        this.settings = settings;
        this.enrichCache = new EnrichCache((Long)CACHE_SIZE.get(settings));
    }

    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        EnrichProcessorFactory factory = new EnrichProcessorFactory(parameters.client, parameters.scriptService, this.enrichCache);
        parameters.ingestService.addIngestClusterStateListener((Consumer)factory);
        return Map.of("enrich", factory);
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return List.of(new ActionPlugin.ActionHandler(XPackInfoFeatureAction.ENRICH, EnrichInfoTransportAction.class), new ActionPlugin.ActionHandler(XPackUsageFeatureAction.ENRICH, EnrichUsageTransportAction.class), new ActionPlugin.ActionHandler((ActionType)GetEnrichPolicyAction.INSTANCE, TransportGetEnrichPolicyAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteEnrichPolicyAction.INSTANCE, TransportDeleteEnrichPolicyAction.class), new ActionPlugin.ActionHandler((ActionType)PutEnrichPolicyAction.INSTANCE, TransportPutEnrichPolicyAction.class), new ActionPlugin.ActionHandler((ActionType)ExecuteEnrichPolicyAction.INSTANCE, TransportExecuteEnrichPolicyAction.class), new ActionPlugin.ActionHandler((ActionType)EnrichStatsAction.INSTANCE, TransportEnrichStatsAction.class), new ActionPlugin.ActionHandler((ActionType)EnrichCoordinatorProxyAction.INSTANCE, EnrichCoordinatorProxyAction.TransportAction.class), new ActionPlugin.ActionHandler((ActionType)EnrichShardMultiSearchAction.INSTANCE, EnrichShardMultiSearchAction.TransportAction.class), new ActionPlugin.ActionHandler((ActionType)EnrichCoordinatorStatsAction.INSTANCE, EnrichCoordinatorStatsAction.TransportAction.class), new ActionPlugin.ActionHandler((ActionType)EnrichReindexAction.INSTANCE, TransportEnrichReindexAction.class), new ActionPlugin.ActionHandler((ActionType)InternalExecutePolicyAction.INSTANCE, InternalExecutePolicyAction.Transport.class));
    }

    public List<RestHandler> getRestHandlers(Settings unused, NamedWriteableRegistry namedWriteableRegistry, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        return List.of(new RestGetEnrichPolicyAction(), new RestDeleteEnrichPolicyAction(), new RestPutEnrichPolicyAction(), new RestExecuteEnrichPolicyAction(), new RestEnrichStatsAction());
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        EnrichPolicyLocks enrichPolicyLocks = new EnrichPolicyLocks();
        EnrichPolicyExecutor enrichPolicyExecutor = new EnrichPolicyExecutor(this.settings, services.clusterService(), services.indicesService(), services.client(), services.threadPool(), services.indexNameExpressionResolver(), enrichPolicyLocks, System::currentTimeMillis);
        EnrichPolicyMaintenanceService enrichPolicyMaintenanceService = new EnrichPolicyMaintenanceService(this.settings, services.client(), services.clusterService(), services.threadPool(), enrichPolicyLocks);
        enrichPolicyMaintenanceService.initialize();
        return List.of(enrichPolicyLocks, new EnrichCoordinatorProxyAction.Coordinator(services.client(), this.settings), enrichPolicyMaintenanceService, enrichPolicyExecutor, this.enrichCache);
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return List.of(new NamedWriteableRegistry.Entry(Metadata.Custom.class, "enrich", EnrichMetadata::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "enrich", in -> EnrichMetadata.readDiffFrom(Metadata.Custom.class, (String)"enrich", (StreamInput)in)));
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return List.of(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("enrich", new String[0]), EnrichMetadata::fromXContent));
    }

    public List<Setting<?>> getSettings() {
        return List.of(ENRICH_FETCH_SIZE_SETTING, ENRICH_MAX_CONCURRENT_POLICY_EXECUTIONS, ENRICH_CLEANUP_PERIOD, COORDINATOR_PROXY_MAX_CONCURRENT_REQUESTS, COORDINATOR_PROXY_MAX_LOOKUPS_PER_REQUEST, COORDINATOR_PROXY_QUEUE_CAPACITY, ENRICH_MAX_FORCE_MERGE_ATTEMPTS, CACHE_SIZE);
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings unused) {
        return List.of(SystemIndexDescriptor.builder().setIndexPattern(".enrich-*").setDescription("Contains data to support enrich ingest processors.").setType(SystemIndexDescriptor.Type.INTERNAL_UNMANAGED).setAllowedElasticProductOrigins(List.of()).build());
    }

    public String getFeatureName() {
        return "enrich";
    }

    public String getFeatureDescription() {
        return "Manages data related to Enrich policies";
    }
}

