/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.operator.topn.ResultBuilderForBoolean;
import org.elasticsearch.compute.operator.topn.ResultBuilderForBytesRef;
import org.elasticsearch.compute.operator.topn.ResultBuilderForDoc;
import org.elasticsearch.compute.operator.topn.ResultBuilderForDouble;
import org.elasticsearch.compute.operator.topn.ResultBuilderForInt;
import org.elasticsearch.compute.operator.topn.ResultBuilderForLong;
import org.elasticsearch.compute.operator.topn.ResultBuilderForNull;
import org.elasticsearch.compute.operator.topn.TopNEncoder;
import org.elasticsearch.core.Releasable;

interface ResultBuilder
extends Releasable {
    public void decodeKey(BytesRef var1);

    public void decodeValue(BytesRef var1);

    public Block build();

    public static ResultBuilder resultBuilderFor(BlockFactory blockFactory, ElementType elementType, TopNEncoder encoder, boolean inKey, int positions) {
        return switch (elementType) {
            case ElementType.BOOLEAN -> new ResultBuilderForBoolean(blockFactory, encoder, inKey, positions);
            case ElementType.BYTES_REF -> new ResultBuilderForBytesRef(blockFactory, encoder, inKey, positions);
            case ElementType.INT -> new ResultBuilderForInt(blockFactory, encoder, inKey, positions);
            case ElementType.LONG -> new ResultBuilderForLong(blockFactory, encoder, inKey, positions);
            case ElementType.DOUBLE -> new ResultBuilderForDouble(blockFactory, encoder, inKey, positions);
            case ElementType.NULL -> new ResultBuilderForNull(blockFactory);
            case ElementType.DOC -> new ResultBuilderForDoc(blockFactory, positions);
            default -> {
                if (!1.$assertionsDisabled) {
                    throw new AssertionError((Object)("Result builder for [" + elementType + "]"));
                }
                throw new UnsupportedOperationException("Result builder for [" + elementType + "]");
            }
        };
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

