/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.topn.TopNEncoder;

final class DefaultUnsortableTopNEncoder
implements TopNEncoder {
    public static final VarHandle LONG = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.nativeOrder());
    public static final VarHandle INT = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.nativeOrder());
    public static final VarHandle DOUBLE = MethodHandles.byteArrayViewVarHandle(double[].class, ByteOrder.nativeOrder());

    DefaultUnsortableTopNEncoder() {
    }

    @Override
    public void encodeLong(long value, BreakingBytesRefBuilder bytesRefBuilder) {
        bytesRefBuilder.grow(bytesRefBuilder.length() + 8);
        LONG.set(bytesRefBuilder.bytes(), bytesRefBuilder.length(), value);
        bytesRefBuilder.setLength(bytesRefBuilder.length() + 8);
    }

    @Override
    public long decodeLong(BytesRef bytes) {
        if (bytes.length < 8) {
            throw new IllegalArgumentException("not enough bytes");
        }
        long v = LONG.get(bytes.bytes, bytes.offset);
        bytes.offset += 8;
        bytes.length -= 8;
        return v;
    }

    public void encodeVInt(int value, BreakingBytesRefBuilder bytesRefBuilder) {
        while ((value & 0xFFFFFF80) != 0) {
            bytesRefBuilder.append((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
        bytesRefBuilder.append((byte)value);
    }

    public int decodeVInt(BytesRef bytes) {
        byte b = bytes.bytes[bytes.offset];
        if (b >= 0) {
            ++bytes.offset;
            --bytes.length;
            return b;
        }
        int i = b & 0x7F;
        b = bytes.bytes[bytes.offset + 1];
        i |= (b & 0x7F) << 7;
        if (b >= 0) {
            bytes.offset += 2;
            bytes.length -= 2;
            return i;
        }
        b = bytes.bytes[bytes.offset + 2];
        i |= (b & 0x7F) << 14;
        if (b >= 0) {
            bytes.offset += 3;
            bytes.length -= 3;
            return i;
        }
        b = bytes.bytes[bytes.offset + 3];
        i |= (b & 0x7F) << 21;
        if (b >= 0) {
            bytes.offset += 4;
            bytes.length -= 4;
            return i;
        }
        b = bytes.bytes[bytes.offset + 4];
        i |= (b & 0xF) << 28;
        if ((b & 0xF0) != 0) {
            throw new IllegalStateException("Invalid last byte for a vint [" + Integer.toHexString(b) + "]");
        }
        bytes.offset += 5;
        bytes.length -= 5;
        return i;
    }

    @Override
    public void encodeInt(int value, BreakingBytesRefBuilder bytesRefBuilder) {
        bytesRefBuilder.grow(bytesRefBuilder.length() + 4);
        INT.set(bytesRefBuilder.bytes(), bytesRefBuilder.length(), value);
        bytesRefBuilder.setLength(bytesRefBuilder.length() + 4);
    }

    @Override
    public int decodeInt(BytesRef bytes) {
        if (bytes.length < 4) {
            throw new IllegalArgumentException("not enough bytes");
        }
        int v = INT.get(bytes.bytes, bytes.offset);
        bytes.offset += 4;
        bytes.length -= 4;
        return v;
    }

    @Override
    public void encodeDouble(double value, BreakingBytesRefBuilder bytesRefBuilder) {
        bytesRefBuilder.grow(bytesRefBuilder.length() + 8);
        DOUBLE.set(bytesRefBuilder.bytes(), bytesRefBuilder.length(), value);
        bytesRefBuilder.setLength(bytesRefBuilder.length() + 8);
    }

    @Override
    public double decodeDouble(BytesRef bytes) {
        if (bytes.length < 8) {
            throw new IllegalArgumentException("not enough bytes");
        }
        double v = DOUBLE.get(bytes.bytes, bytes.offset);
        bytes.offset += 8;
        bytes.length -= 8;
        return v;
    }

    @Override
    public void encodeBoolean(boolean value, BreakingBytesRefBuilder bytesRefBuilder) {
        bytesRefBuilder.append(value ? (byte)1 : 0);
    }

    @Override
    public boolean decodeBoolean(BytesRef bytes) {
        if (bytes.length < 1) {
            throw new IllegalArgumentException("not enough bytes");
        }
        boolean v = bytes.bytes[bytes.offset] == 1;
        ++bytes.offset;
        --bytes.length;
        return v;
    }

    @Override
    public int encodeBytesRef(BytesRef value, BreakingBytesRefBuilder bytesRefBuilder) {
        int offset = bytesRefBuilder.length();
        this.encodeVInt(value.length, bytesRefBuilder);
        bytesRefBuilder.append(value);
        return bytesRefBuilder.length() - offset;
    }

    @Override
    public BytesRef decodeBytesRef(BytesRef bytes, BytesRef scratch) {
        int len = this.decodeVInt(bytes);
        scratch.bytes = bytes.bytes;
        scratch.offset = bytes.offset;
        scratch.length = len;
        bytes.offset += len;
        bytes.length -= len;
        return scratch;
    }

    @Override
    public TopNEncoder toSortable() {
        return TopNEncoder.DEFAULT_SORTABLE;
    }

    @Override
    public TopNEncoder toUnsortable() {
        return this;
    }

    public String toString() {
        return "DefaultUnsortable";
    }
}

