/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.exchange;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.exchange.ExchangeBuffer;
import org.elasticsearch.compute.operator.exchange.ExchangeResponse;
import org.elasticsearch.compute.operator.exchange.ExchangeSource;
import org.elasticsearch.compute.operator.exchange.RemoteSink;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.transport.TransportException;

public final class ExchangeSourceHandler {
    private final ExchangeBuffer buffer;
    private final Executor fetchExecutor;
    private final PendingInstances outstandingSinks;
    private final PendingInstances outstandingSources;
    private final AtomicReference<Exception> failure = new AtomicReference();

    public ExchangeSourceHandler(int maxBufferSize, Executor fetchExecutor) {
        this.buffer = new ExchangeBuffer(maxBufferSize);
        this.fetchExecutor = fetchExecutor;
        this.outstandingSinks = new PendingInstances(() -> this.buffer.finish(false));
        this.outstandingSources = new PendingInstances(() -> this.buffer.finish(true));
    }

    public void addCompletionListener(ActionListener<Void> listener) {
        this.buffer.addCompletionListener((ActionListener<Void>)ActionListener.running(() -> {
            try (RefCountingListener refs = new RefCountingListener(listener);){
                for (PendingInstances pending : List.of(this.outstandingSinks, this.outstandingSources)) {
                    pending.trackNewInstance();
                    pending.completion.addListener(refs.acquire());
                    pending.finishInstance();
                }
            }
        }));
    }

    public ExchangeSource createExchangeSource() {
        return new ExchangeSourceImpl();
    }

    public void addRemoteSink(RemoteSink remoteSink, int instances) {
        for (int i = 0; i < instances; ++i) {
            final RemoteSinkFetcher fetcher = new RemoteSinkFetcher(remoteSink);
            this.fetchExecutor.execute((Runnable)new AbstractRunnable(){

                public void onFailure(Exception e) {
                    fetcher.onSinkFailed(e);
                }

                protected void doRun() {
                    fetcher.fetchPage();
                }
            });
        }
    }

    public Releasable addEmptySink() {
        this.outstandingSinks.trackNewInstance();
        return this.outstandingSinks::finishInstance;
    }

    private static class PendingInstances {
        private final AtomicInteger instances = new AtomicInteger();
        private final SubscribableListener<Void> completion = new SubscribableListener();

        PendingInstances(Runnable onComplete) {
            this.completion.addListener(ActionListener.running((Runnable)onComplete));
        }

        void trackNewInstance() {
            int refs = this.instances.incrementAndGet();
            assert (refs > 0);
        }

        void finishInstance() {
            int refs = this.instances.decrementAndGet();
            assert (refs >= 0);
            if (refs == 0) {
                this.completion.onResponse(null);
            }
        }
    }

    private class ExchangeSourceImpl
    implements ExchangeSource {
        private boolean finished;

        ExchangeSourceImpl() {
            ExchangeSourceHandler.this.outstandingSources.trackNewInstance();
        }

        private void checkFailure() {
            Exception e = ExchangeSourceHandler.this.failure.get();
            if (e != null) {
                throw ExceptionsHelper.convertToElastic((Exception)e);
            }
        }

        @Override
        public Page pollPage() {
            this.checkFailure();
            return ExchangeSourceHandler.this.buffer.pollPage();
        }

        @Override
        public boolean isFinished() {
            this.checkFailure();
            return this.finished || ExchangeSourceHandler.this.buffer.isFinished();
        }

        @Override
        public SubscribableListener<Void> waitForReading() {
            return ExchangeSourceHandler.this.buffer.waitForReading();
        }

        @Override
        public void finish() {
            if (!this.finished) {
                this.finished = true;
                ExchangeSourceHandler.this.outstandingSources.finishInstance();
            }
        }

        @Override
        public int bufferSize() {
            return ExchangeSourceHandler.this.buffer.size();
        }
    }

    private final class RemoteSinkFetcher {
        private volatile boolean finished = false;
        private final RemoteSink remoteSink;

        RemoteSinkFetcher(RemoteSink remoteSink) {
            ExchangeSourceHandler.this.outstandingSinks.trackNewInstance();
            this.remoteSink = remoteSink;
        }

        void fetchPage() {
            LoopControl loopControl = new LoopControl();
            while (loopControl.isRunning()) {
                loopControl.exiting();
                boolean toFinishSinks = ExchangeSourceHandler.this.buffer.noMoreInputs() || ExchangeSourceHandler.this.failure.get() != null;
                this.remoteSink.fetchPageAsync(toFinishSinks, (ActionListener<ExchangeResponse>)ActionListener.wrap(resp -> {
                    Page page = resp.takePage();
                    if (page != null) {
                        ExchangeSourceHandler.this.buffer.addPage(page);
                    }
                    if (resp.finished()) {
                        this.onSinkComplete();
                    } else {
                        SubscribableListener<Void> future = ExchangeSourceHandler.this.buffer.waitForWriting();
                        if (future.isDone()) {
                            if (!loopControl.tryResume()) {
                                this.fetchPage();
                            }
                        } else {
                            future.addListener(ActionListener.wrap(unused -> {
                                if (!loopControl.tryResume()) {
                                    this.fetchPage();
                                }
                            }, this::onSinkFailed));
                        }
                    }
                }, this::onSinkFailed));
            }
            loopControl.exited();
        }

        void onSinkFailed(Exception originEx) {
            Exception cause;
            Throwable throwable;
            Exception exception = originEx instanceof TransportException ? ((throwable = originEx.getCause()) instanceof Exception ? (cause = (Exception)throwable) : new ElasticsearchException(originEx.getCause())) : originEx;
            Exception e = exception;
            ExchangeSourceHandler.this.failure.getAndUpdate(first -> {
                if (first == null) {
                    return e;
                }
                if (ExceptionsHelper.unwrap((Throwable)e, (Class[])new Class[]{TaskCancelledException.class}) != null) {
                    return first;
                }
                if (ExceptionsHelper.unwrap((Throwable)first, (Class[])new Class[]{TaskCancelledException.class}) != null) {
                    return e;
                }
                if (ExceptionsHelper.unwrapCause((Throwable)first) != ExceptionsHelper.unwrapCause((Throwable)e)) {
                    first.addSuppressed(e);
                }
                return first;
            });
            ExchangeSourceHandler.this.buffer.waitForReading().onResponse(null);
            this.onSinkComplete();
        }

        void onSinkComplete() {
            if (!this.finished) {
                this.finished = true;
                ExchangeSourceHandler.this.outstandingSinks.finishInstance();
            }
        }
    }

    private static class LoopControl {
        private final Thread startedThread;
        private Status status = Status.RUNNING;

        LoopControl() {
            this.startedThread = Thread.currentThread();
        }

        boolean isRunning() {
            return this.status == Status.RUNNING;
        }

        boolean tryResume() {
            if (this.startedThread == Thread.currentThread() && this.status != Status.EXITED) {
                this.status = Status.RUNNING;
                return true;
            }
            return false;
        }

        void exiting() {
            this.status = Status.EXITING;
        }

        void exited() {
            this.status = Status.EXITED;
        }

        static enum Status {
            RUNNING,
            EXITING,
            EXITED;

        }
    }
}

