/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.Arrays;
import java.util.List;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.AbstractPageMappingOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class ProjectOperator
extends AbstractPageMappingOperator {
    private final int[] projection;
    private final Block[] blocks;

    public ProjectOperator(List<Integer> projection) {
        this.projection = projection.stream().mapToInt(Integer::intValue).toArray();
        this.blocks = new Block[projection.size()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Page process(Page page) {
        int blockCount = page.getBlockCount();
        if (blockCount == 0) {
            return page;
        }
        Page output = null;
        try {
            int b = 0;
            for (int source : this.projection) {
                if (source >= blockCount) {
                    throw new IllegalArgumentException("Cannot project block with index [" + source + "] from a page with size [" + blockCount + "]");
                }
                Object block = page.getBlock(source);
                this.blocks[b++] = block;
                block.incRef();
            }
            int positionCount = page.getPositionCount();
            Page page2 = output = new Page(positionCount, this.blocks);
            return page2;
        }
        finally {
            if (output == null) {
                Releasables.close((Releasable[])this.blocks);
            }
            Arrays.fill(this.blocks, null);
            page.releaseBlocks();
        }
    }

    @Override
    public String toString() {
        if (this.projection.length < 10) {
            return "ProjectOperator[projection = " + Arrays.toString(this.projection) + "]";
        }
        return "ProjectOperator[projection = [" + this.projection.length + " fields]]";
    }

    public record ProjectOperatorFactory(List<Integer> projection) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            return new ProjectOperator(this.projection);
        }

        @Override
        public String describe() {
            if (this.projection.size() < 10) {
                return "ProjectOperator[projection = " + this.projection + "]";
            }
            return "ProjectOperator[projection = [" + this.projection.size() + " fields]]";
        }
    }
}

