/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.compute.operator.DriverStatus;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;

public class DriverProfile
implements Writeable,
ChunkedToXContentObject {
    private final long tookNanos;
    private final long cpuNanos;
    private final long iterations;
    private final List<DriverStatus.OperatorStatus> operators;

    public DriverProfile(long tookNanos, long cpuNanos, long iterations, List<DriverStatus.OperatorStatus> operators) {
        this.tookNanos = tookNanos;
        this.cpuNanos = cpuNanos;
        this.iterations = iterations;
        this.operators = operators;
    }

    public DriverProfile(StreamInput in) throws IOException {
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_TIMINGS)) {
            this.tookNanos = in.readVLong();
            this.cpuNanos = in.readVLong();
            this.iterations = in.readVLong();
        } else {
            this.tookNanos = 0L;
            this.cpuNanos = 0L;
            this.iterations = 0L;
        }
        this.operators = in.readCollectionAsImmutableList(DriverStatus.OperatorStatus::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_TIMINGS)) {
            out.writeVLong(this.tookNanos);
            out.writeVLong(this.cpuNanos);
            out.writeVLong(this.iterations);
        }
        out.writeCollection(this.operators);
    }

    public long tookNanos() {
        return this.tookNanos;
    }

    public long cpuNanos() {
        return this.cpuNanos;
    }

    public long iterations() {
        return this.iterations;
    }

    public List<DriverStatus.OperatorStatus> operators() {
        return this.operators;
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat((Iterator[])new Iterator[]{ChunkedToXContentHelper.startObject(), Iterators.single((b, p) -> {
            b.field("took_nanos", this.tookNanos);
            if (b.humanReadable()) {
                b.field("took_time", (Object)TimeValue.timeValueNanos((long)this.tookNanos));
            }
            b.field("cpu_nanos", this.cpuNanos);
            if (b.humanReadable()) {
                b.field("cpu_time", (Object)TimeValue.timeValueNanos((long)this.cpuNanos));
            }
            b.field("iterations", this.iterations);
            return b;
        }), ChunkedToXContentHelper.array((String)"operators", this.operators.iterator()), ChunkedToXContentHelper.endObject()});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DriverProfile that = (DriverProfile)o;
        return this.tookNanos == that.tookNanos && this.cpuNanos == that.cpuNanos && this.iterations == that.iterations && Objects.equals(this.operators, that.operators);
    }

    public int hashCode() {
        return Objects.hash(this.tookNanos, this.cpuNanos, this.iterations, this.operators);
    }

    public String toString() {
        return Strings.toString((ChunkedToXContent)this);
    }
}

