/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.DataPartitioning;
import org.elasticsearch.compute.lucene.LuceneOperator;
import org.elasticsearch.compute.lucene.LuceneSlice;
import org.elasticsearch.compute.lucene.LuceneSliceQueue;
import org.elasticsearch.compute.lucene.PartialLeafReaderContext;
import org.elasticsearch.compute.lucene.ShardContext;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;

public record TimeSeriesSortedSourceOperatorFactory(int limit, int maxPageSize, int taskConcurrency, TimeValue timeSeriesPeriod, LuceneSliceQueue sliceQueue) implements LuceneOperator.Factory
{
    @Override
    public SourceOperator get(DriverContext driverContext) {
        Rounding rounding = !this.timeSeriesPeriod.equals((Object)TimeValue.ZERO) ? Rounding.builder((TimeValue)this.timeSeriesPeriod).build() : null;
        return new Impl(driverContext.blockFactory(), this.sliceQueue, this.maxPageSize, this.limit, rounding);
    }

    @Override
    public String describe() {
        return "TimeSeriesSortedSourceOperator[maxPageSize = " + this.maxPageSize + ", limit = " + this.limit + "]";
    }

    public static TimeSeriesSortedSourceOperatorFactory create(int limit, int maxPageSize, int taskConcurrency, TimeValue timeSeriesPeriod, List<? extends ShardContext> searchContexts, Function<ShardContext, Query> queryFunction) {
        Function<ShardContext, Weight> weightFunction = LuceneOperator.weightFunction(queryFunction, ScoreMode.COMPLETE_NO_SCORES);
        LuceneSliceQueue sliceQueue = LuceneSliceQueue.create(searchContexts, weightFunction, DataPartitioning.SHARD, taskConcurrency);
        taskConcurrency = Math.min(sliceQueue.totalSlices(), taskConcurrency);
        return new TimeSeriesSortedSourceOperatorFactory(limit, maxPageSize, taskConcurrency, timeSeriesPeriod, sliceQueue);
    }

    static final class Impl
    extends SourceOperator {
        private final int maxPageSize;
        private final BlockFactory blockFactory;
        private final LuceneSliceQueue sliceQueue;
        private final Rounding.Prepared rounding;
        private int currentPagePos = 0;
        private int remainingDocs;
        private boolean doneCollecting;
        private IntVector.Builder docsBuilder;
        private IntVector.Builder segmentsBuilder;
        private LongVector.Builder timestampsBuilder;
        private LongVector.Builder intervalsBuilder;
        private BytesRefVector.Builder tsHashesBuilder;
        private TimeSeriesIterator iterator;

        Impl(BlockFactory blockFactory, LuceneSliceQueue sliceQueue, int maxPageSize, int limit, Rounding rounding) {
            this.maxPageSize = maxPageSize;
            this.blockFactory = blockFactory;
            this.remainingDocs = limit;
            this.docsBuilder = blockFactory.newIntVectorBuilder(Math.min(limit, maxPageSize));
            this.segmentsBuilder = null;
            this.timestampsBuilder = blockFactory.newLongVectorBuilder(Math.min(limit, maxPageSize));
            this.tsHashesBuilder = blockFactory.newBytesRefVectorBuilder(Math.min(limit, maxPageSize));
            this.sliceQueue = sliceQueue;
            if (rounding != null) {
                try {
                    long minTimestamp = Long.MAX_VALUE;
                    long maxTimestamp = Long.MIN_VALUE;
                    for (LuceneSlice slice : sliceQueue.getSlices()) {
                        for (PartialLeafReaderContext leaf : slice.leaves()) {
                            PointValues pointValues = leaf.leafReaderContext().reader().getPointValues("@timestamp");
                            long segmentMin = LongPoint.decodeDimension((byte[])pointValues.getMinPackedValue(), (int)0);
                            minTimestamp = Math.min(segmentMin, minTimestamp);
                            long segmentMax = LongPoint.decodeDimension((byte[])pointValues.getMaxPackedValue(), (int)0);
                            maxTimestamp = Math.max(segmentMax, maxTimestamp);
                        }
                    }
                    this.rounding = rounding.prepare(minTimestamp, maxTimestamp);
                    this.intervalsBuilder = blockFactory.newLongVectorBuilder(Math.min(limit, maxPageSize));
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException(ioe);
                }
            } else {
                this.rounding = null;
            }
        }

        @Override
        public void finish() {
            this.doneCollecting = true;
        }

        @Override
        public boolean isFinished() {
            return this.doneCollecting;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Page getOutput() {
            block15: {
                block16: {
                    if (this.isFinished()) {
                        return null;
                    }
                    if (this.remainingDocs <= 0) {
                        this.doneCollecting = true;
                        return null;
                    }
                    page = null;
                    shard = null;
                    leaf = null;
                    docs = null;
                    timestamps = null;
                    intervals = null;
                    tsids = null;
                    if (this.iterator != null) ** GOTO lbl28
                    slice = this.sliceQueue.nextSlice();
                    if (slice != null) break block15;
                    this.doneCollecting = true;
                    var9_11 = null;
                    if (page != null) break block16;
                    Releasables.closeExpectNoException((Releasable[])new Releasable[]{shard, leaf, docs, timestamps, tsids, intervals});
                }
                return var9_11;
            }
            try {
                if (this.segmentsBuilder == null && slice.numLeaves() > 1) {
                    this.segmentsBuilder = this.blockFactory.newIntVectorBuilder(Math.min(this.remainingDocs, this.maxPageSize));
                }
                this.iterator = new TimeSeriesIterator(slice);
lbl28:
                // 2 sources

                this.iterator.consume();
                shard = this.blockFactory.newConstantIntBlockWith(this.iterator.slice.shardContext().index(), this.currentPagePos);
                if (this.iterator.slice.numLeaves() == 1) {
                    segmentOrd = this.iterator.slice.getLeaf((int)0).leafReaderContext().ord;
                    leaf = this.blockFactory.newConstantIntBlockWith(segmentOrd, this.currentPagePos).asVector();
                } else {
                    leaf = this.segmentsBuilder.build();
                    this.segmentsBuilder = this.blockFactory.newIntVectorBuilder(Math.min(this.remainingDocs, this.maxPageSize));
                }
                docs = this.docsBuilder.build();
                this.docsBuilder = this.blockFactory.newIntVectorBuilder(Math.min(this.remainingDocs, this.maxPageSize));
                timestamps = this.timestampsBuilder.build();
                this.timestampsBuilder = this.blockFactory.newLongVectorBuilder(Math.min(this.remainingDocs, this.maxPageSize));
                if (this.rounding != null) {
                    intervals = this.intervalsBuilder.build();
                    this.intervalsBuilder = this.blockFactory.newLongVectorBuilder(Math.min(this.remainingDocs, this.maxPageSize));
                } else {
                    intervals = this.blockFactory.newConstantLongVector(0L, timestamps.getPositionCount());
                }
                tsids = this.tsHashesBuilder.build();
                this.tsHashesBuilder = this.blockFactory.newBytesRefVectorBuilder(Math.min(this.remainingDocs, this.maxPageSize));
                page = new Page(this.currentPagePos, new Block[]{new DocVector(shard.asVector(), leaf, docs, leaf.isConstant()).asBlock(), tsids.asBlock(), timestamps.asBlock(), intervals.asBlock()});
                this.currentPagePos = 0;
                if (this.iterator.completed()) {
                    this.iterator = null;
                }
                ** if (page != null) goto lbl-1000
            }
            catch (IOException e) {
                try {
                    throw new UncheckedIOException(e);
                }
                catch (Throwable var10_12) {
                    if (page == null) {
                        Releasables.closeExpectNoException((Releasable[])new Releasable[]{shard, leaf, docs, timestamps, tsids, intervals});
                    }
                    throw var10_12;
                }
            }
lbl-1000:
            // 1 sources

            {
                Releasables.closeExpectNoException((Releasable[])new Releasable[]{shard, leaf, docs, timestamps, tsids, intervals});
            }
lbl-1000:
            // 2 sources

            {
            }
            return page;
        }

        @Override
        public void close() {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.docsBuilder, this.segmentsBuilder, this.timestampsBuilder, this.intervalsBuilder, this.tsHashesBuilder});
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[maxPageSize=" + this.maxPageSize + ", remainingDocs=" + this.remainingDocs + "]";
        }

        class TimeSeriesIterator {
            final LuceneSlice slice;
            final Leaf leaf;
            final PriorityQueue<Leaf> queue;
            int globalTsidOrd;
            BytesRef currentTsid = new BytesRef();

            TimeSeriesIterator(LuceneSlice slice) throws IOException {
                this.slice = slice;
                Weight weight = slice.weight().get();
                if (slice.numLeaves() == 1) {
                    this.queue = null;
                    this.leaf = new Leaf(weight, slice.getLeaf(0).leafReaderContext());
                } else {
                    this.queue = new PriorityQueue<Leaf>(slice.numLeaves()){

                        protected boolean lessThan(Leaf a, Leaf b) {
                            int cmp = a.timeSeriesHash.compareTo(b.timeSeriesHash);
                            if (cmp == 0) {
                                cmp = -Long.compare(a.timestamp, b.timestamp);
                            }
                            return cmp < 0;
                        }
                    };
                    this.leaf = null;
                    for (PartialLeafReaderContext leafReaderContext : slice.leaves()) {
                        Leaf leaf = new Leaf(weight, leafReaderContext.leafReaderContext());
                        if (!leaf.nextDoc()) continue;
                        this.queue.add((Object)leaf);
                    }
                }
            }

            void consume() throws IOException {
                if (this.queue != null) {
                    this.currentTsid = BytesRef.deepCopyOf((BytesRef)((Leaf)this.queue.top()).timeSeriesHash);
                    if (this.queue.size() > 0) {
                        ((Leaf)this.queue.top()).reinitializeIfNeeded(Thread.currentThread());
                    }
                    while (this.queue.size() > 0 && Impl.this.remainingDocs > 0 && Impl.this.currentPagePos < Impl.this.maxPageSize) {
                        Leaf newTop;
                        ++Impl.this.currentPagePos;
                        --Impl.this.remainingDocs;
                        Leaf leaf = (Leaf)this.queue.top();
                        Impl.this.segmentsBuilder.appendInt(leaf.segmentOrd);
                        Impl.this.docsBuilder.appendInt(leaf.iterator.docID());
                        Impl.this.timestampsBuilder.appendLong(leaf.timestamp);
                        if (Impl.this.rounding != null) {
                            Impl.this.intervalsBuilder.appendLong(Impl.this.rounding.round(leaf.timestamp));
                        }
                        Impl.this.tsHashesBuilder.appendBytesRef(this.currentTsid);
                        if (leaf.nextDoc()) {
                            newTop = (Leaf)this.queue.updateTop();
                        } else {
                            this.queue.pop();
                            Leaf leaf2 = newTop = this.queue.size() > 0 ? (Leaf)this.queue.top() : null;
                        }
                        if (newTop == null) continue;
                        if (newTop != leaf) {
                            newTop.reinitializeIfNeeded(Thread.currentThread());
                        }
                        if (newTop.timeSeriesHash.equals((Object)this.currentTsid)) continue;
                        ++this.globalTsidOrd;
                        this.currentTsid = BytesRef.deepCopyOf((BytesRef)newTop.timeSeriesHash);
                    }
                } else {
                    this.leaf.reinitializeIfNeeded(Thread.currentThread());
                    while (this.leaf.nextDoc()) {
                        Impl.this.tsHashesBuilder.appendBytesRef(this.leaf.timeSeriesHash);
                        Impl.this.timestampsBuilder.appendLong(this.leaf.timestamp);
                        if (Impl.this.rounding != null) {
                            Impl.this.intervalsBuilder.appendLong(Impl.this.rounding.round(this.leaf.timestamp));
                        }
                        Impl.this.docsBuilder.appendInt(this.leaf.iterator.docID());
                        ++Impl.this.currentPagePos;
                        --Impl.this.remainingDocs;
                        if (Impl.this.remainingDocs > 0 && Impl.this.currentPagePos < Impl.this.maxPageSize) continue;
                        break;
                    }
                }
            }

            boolean completed() {
                if (this.queue != null) {
                    return Impl.this.iterator.queue.size() == 0;
                }
                return this.leaf.iterator.docID() == Integer.MAX_VALUE;
            }

            static class Leaf {
                private final int segmentOrd;
                private final Weight weight;
                private final LeafReaderContext leaf;
                private SortedDocValues tsids;
                private SortedNumericDocValues timestamps;
                private DocIdSetIterator iterator;
                private Thread createdThread;
                private long timestamp;
                private int timeSeriesHashOrd;
                private BytesRef timeSeriesHash;
                private int docID = -1;

                Leaf(Weight weight, LeafReaderContext leaf) throws IOException {
                    this.segmentOrd = leaf.ord;
                    this.weight = weight;
                    this.leaf = leaf;
                    this.createdThread = Thread.currentThread();
                    this.tsids = leaf.reader().getSortedDocValues("_tsid");
                    this.timestamps = leaf.reader().getSortedNumericDocValues("@timestamp");
                    this.iterator = weight.scorer(leaf).iterator();
                }

                boolean nextDoc() throws IOException {
                    this.docID = this.iterator.nextDoc();
                    if (this.docID == Integer.MAX_VALUE) {
                        return false;
                    }
                    boolean advanced = this.tsids.advanceExact(this.docID);
                    assert (advanced);
                    this.timeSeriesHashOrd = this.tsids.ordValue();
                    this.timeSeriesHash = this.tsids.lookupOrd(this.timeSeriesHashOrd);
                    advanced = this.timestamps.advanceExact(this.docID);
                    assert (advanced);
                    this.timestamp = this.timestamps.nextValue();
                    return true;
                }

                void reinitializeIfNeeded(Thread executingThread) throws IOException {
                    if (executingThread != this.createdThread) {
                        this.tsids = this.leaf.reader().getSortedDocValues("_tsid");
                        this.timestamps = this.leaf.reader().getSortedNumericDocValues("@timestamp");
                        this.iterator = this.weight.scorer(this.leaf).iterator();
                        if (this.docID != -1) {
                            this.iterator.advance(this.docID);
                        }
                        this.createdThread = executingThread;
                    }
                }
            }
        }
    }
}

